/*
 * Decompiled with CFR 0.152.
 */
package OnePoint.CordovaPlugin;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.DisplayMetrics;
import android.util.TypedValue;

public class ImageLoadingUtils {
    private Context context;
    public Bitmap icon;

    public ImageLoadingUtils(Context context) {
    }

    public int convertDipToPixels(float dips) {
        Resources r = this.context.getResources();
        return (int)TypedValue.applyDimension((int)1, (float)dips, (DisplayMetrics)r.getDisplayMetrics());
    }

    public int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        float totalPixels = width * height;
        float totalReqPixelsCap = reqWidth * reqHeight * 2;
        while (totalPixels / (float)(inSampleSize * inSampleSize) > totalReqPixelsCap) {
            ++inSampleSize;
        }
        return inSampleSize;
    }

    public Bitmap decodeBitmapFromPath(String filePath) {
        Bitmap scaledBitmap = null;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        scaledBitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        options.inSampleSize = this.calculateInSampleSize(options, this.convertDipToPixels(150.0f), this.convertDipToPixels(200.0f));
        options.inDither = false;
        options.inPurgeable = true;
        options.inInputShareable = true;
        options.inJustDecodeBounds = false;
        scaledBitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        return scaledBitmap;
    }
}

