/*
 * Decompiled with CFR 0.152.
 */
package OnePoint.CordovaPlugin;

import OnePoint.CordovaPlugin.RootPlugin;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.location.Location;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AlertDialog;
import com.allatori.annotations.DoNotRename;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.opg.sdk.OPGR;
import com.opg.sdk.OPGSDKConstant;
import java.util.Date;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaArgs;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.PluginResult;
import org.json.JSONException;
import org.json.JSONObject;

@DoNotRename
public class EnableGPSPlugin
extends RootPlugin
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
LocationListener {
    private CallbackContext callback;
    String username;
    String password;
    String version;
    Date signInDate;
    Context context;
    Activity activity;
    private AlertDialog gpsDialog;
    private final int ENABLE_GPS_FROM_SETTINGS = 1;
    private static final int REQUEST_CODE_ASK_LOCATION_PERMISSIONS = 125;
    public static final long UPDATE_INTERVAL_IN_MILLISECONDS = 5000L;
    public static final long FASTEST_UPDATE_INTERVAL_IN_MILLISECONDS = 2500L;
    protected static final String REQUESTING_LOCATION_UPDATES_KEY = "requesting-location-updates-key";
    protected static final String LOCATION_KEY = "location-key";
    protected static final String LAST_UPDATED_TIME_STRING_KEY = "last-updated-time-string-key";
    protected static final String GETTING_LOCATIOON = "Getting Location..";
    protected static final String UNABLE_GET_LOCATION = "Unable to get location, try again.";
    protected static final String OK = "OK";
    protected static final String CANCEL = "Cancel";
    protected GoogleApiClient mGoogleApiClient;
    protected LocationRequest mLocationRequest;
    protected Location mCurrentLocation;
    protected String mLatitudeLabel;
    protected String mLongitudeLabel;
    protected String mLastUpdateTimeLabel;
    protected Boolean mRequestingLocationUpdates;
    protected String mLastUpdateTime;
    private ProgressDialog pDialog;
    protected static final String LATITUDE = "latitude";
    protected static final String LONGITUDE = "longitude";

    @DoNotRename
    public boolean execute(String action, CordovaArgs args, CallbackContext callbackContext) {
        this.context = this.cordova.getActivity();
        this.activity = this.cordova.getActivity();
        this.init(this.context, callbackContext);
        this.callback = callbackContext;
        this.buildGoogleApiClient();
        this.mGoogleApiClient.connect();
        try {
            if (action.equalsIgnoreCase("enableGPS")) {
                this.getLocation();
            } else {
                this.callback.error(this.getReplyJsonString(102));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.callback.error(UNABLE_GET_LOCATION);
        }
        return true;
    }

    private boolean checkPermission() {
        if (ActivityCompat.checkSelfPermission((Context)this.context, (String)OPGSDKConstant.ACCESS_FINE_LOCATION_PERMISSION) == 0 || ActivityCompat.checkSelfPermission((Context)this.context, (String)OPGSDKConstant.ACCESS_COARSE_LOCATION_PERMISSION) == 0) {
            return true;
        }
        if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.cordova.getActivity(), (String)OPGSDKConstant.ACCESS_FINE_LOCATION_PERMISSION) && !ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.cordova.getActivity(), (String)OPGSDKConstant.ACCESS_COARSE_LOCATION_PERMISSION)) {
            this.showAlertDialog();
        } else {
            ActivityCompat.requestPermissions((Activity)this.cordova.getActivity(), (String[])new String[]{OPGSDKConstant.ACCESS_COARSE_LOCATION_PERMISSION, OPGSDKConstant.ACCESS_FINE_LOCATION_PERMISSION}, (int)125);
        }
        return false;
    }

    private void getLocation() {
        try {
            if (Build.VERSION.SDK_INT < 23 || Build.VERSION.SDK_INT >= 23 && this.checkPermission()) {
                if (this.isGPSEnabled()) {
                    this.pDialog = new ProgressDialog(this.context);
                    this.pDialog.setMessage((CharSequence)GETTING_LOCATIOON);
                    this.pDialog.setIndeterminate(false);
                    this.pDialog.setCancelable(true);
                    this.pDialog.show();
                    Handler handler = new Handler();
                    handler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            EnableGPSPlugin.this.startLocationUpdates();
                        }
                    }, 1000L);
                } else {
                    this.enableGPS();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.callback.error(UNABLE_GET_LOCATION);
        }
    }

    private void showAlertDialog() {
        AlertDialog.Builder builder = Build.VERSION.SDK_INT >= 21 ? new AlertDialog.Builder(this.context, 16974374) : new AlertDialog.Builder(this.context);
        builder.setTitle((CharSequence)OPGR.getString(this.context, "string", OPGSDKConstant.RUNTIME_PERMISSION)).setMessage((CharSequence)OPGR.getString(this.context, "string", OPGSDKConstant.LOCATION_PERMISSION_MSG)).setPositiveButton((CharSequence)OPGR.getString(this.context, "string", OPGSDKConstant.SETTINGS), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                EnableGPSPlugin.this.goToSettingPage();
            }
        }).setNegativeButton((CharSequence)OPGR.getString(this.context, "string", OPGSDKConstant.DENY), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).setIcon(17301543).show();
    }

    private void goToSettingPage() {
        Intent intent = new Intent();
        intent.setAction(OPGSDKConstant.APP_DETAILS_SETTINGS);
        Uri uri = Uri.fromParts((String)OPGSDKConstant.PACKAGE, (String)this.cordova.getActivity().getPackageName(), null);
        intent.setData(uri);
        this.cordova.getActivity().startActivity(intent);
    }

    protected synchronized void buildGoogleApiClient() {
        this.mGoogleApiClient = new GoogleApiClient.Builder(this.context).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
        this.createLocationRequest();
    }

    protected void createLocationRequest() {
        this.mLocationRequest = new LocationRequest();
        this.mLocationRequest.setInterval(5000L);
        this.mLocationRequest.setFastestInterval(2500L);
        this.mLocationRequest.setPriority(100);
    }

    private void enableGPS() {
        DialogInterface.OnClickListener dialogClickListener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                switch (which) {
                    case -1: {
                        EnableGPSPlugin.this.enableGPSfromSettings();
                        break;
                    }
                    case -2: {
                        PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, EnableGPSPlugin.this.getReplyJsonString(105));
                        pluginResult.setKeepCallback(true);
                        EnableGPSPlugin.this.callback.error(EnableGPSPlugin.UNABLE_GET_LOCATION);
                    }
                }
            }
        };
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.activity);
        builder.setMessage((CharSequence)OPGR.getString(this.context, "string", "gps_enable_gps_alert")).setPositiveButton((CharSequence)OK, dialogClickListener).setNegativeButton((CharSequence)CANCEL, dialogClickListener);
        if (this.gpsDialog == null) {
            this.gpsDialog = builder.create();
        }
        if (!this.gpsDialog.isShowing()) {
            this.gpsDialog.show();
        }
    }

    public void enableGPSfromSettings() {
        Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
        this.cordova.startActivityForResult((CordovaPlugin)this, intent, 1);
    }

    public void onLocationChanged(Location arg0) {
        this.mCurrentLocation = arg0;
        this.sendCallback();
    }

    private void sendCallback() {
        try {
            JSONObject currentLocationObject = new JSONObject();
            currentLocationObject.put(LATITUDE, this.mCurrentLocation.getLatitude());
            currentLocationObject.put(LONGITUDE, this.mCurrentLocation.getLongitude());
            this.callback.success(currentLocationObject);
            this.stopLocationUpdates();
            this.pDialog.dismiss();
        }
        catch (Exception e) {
            this.pDialog.dismiss();
            e.printStackTrace();
            this.callback.error(e.getLocalizedMessage());
        }
    }

    protected void stopLocationUpdates() {
        LocationServices.FusedLocationApi.removeLocationUpdates(this.mGoogleApiClient, (LocationListener)this);
        this.mGoogleApiClient.disconnect();
    }

    @DoNotRename
    public void onConnectionFailed(ConnectionResult arg0) {
    }

    @DoNotRename
    public void onConnected(Bundle arg0) {
        if (ActivityCompat.checkSelfPermission((Context)this.context, (String)OPGSDKConstant.ACCESS_FINE_LOCATION_PERMISSION) == 0 || ActivityCompat.checkSelfPermission((Context)this.context, (String)OPGSDKConstant.ACCESS_COARSE_LOCATION_PERMISSION) == 0) {
            this.mCurrentLocation = LocationServices.FusedLocationApi.getLastLocation(this.mGoogleApiClient);
        }
    }

    @DoNotRename
    public void onConnectionSuspended(int arg0) {
        this.mGoogleApiClient.connect();
    }

    @DoNotRename
    public void onRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) throws JSONException {
        super.onRequestPermissionResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 125: {
                if (grantResults.length > 0 && grantResults[0] == 0 && (ActivityCompat.checkSelfPermission((Context)this.context, (String)OPGSDKConstant.ACCESS_FINE_LOCATION_PERMISSION) == 0 || ActivityCompat.checkSelfPermission((Context)this.context, (String)OPGSDKConstant.ACCESS_COARSE_LOCATION_PERMISSION) == 0)) {
                    this.mGoogleApiClient.connect();
                    this.getLocation();
                }
                return;
            }
        }
    }

    @DoNotRename
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1) {
            switch (requestCode) {
                case 1: {
                    this.mGoogleApiClient.connect();
                    this.getLocation();
                }
            }
        }
    }

    protected void startLocationUpdates() {
        if (ActivityCompat.checkSelfPermission((Context)this.context, (String)OPGSDKConstant.ACCESS_FINE_LOCATION_PERMISSION) != 0 && ActivityCompat.checkSelfPermission((Context)this.context, (String)OPGSDKConstant.ACCESS_COARSE_LOCATION_PERMISSION) != 0) {
            return;
        }
        LocationServices.FusedLocationApi.requestLocationUpdates(this.mGoogleApiClient, this.mLocationRequest, (LocationListener)this);
    }
}

