/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.clipboard;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.util.Log;

public final class ClipboardInterface {
    private static final String TAG = ClipboardInterface.class.getSimpleName();

    private ClipboardInterface() {
    }

    public static CharSequence getText(Context context) {
        ClipboardManager clipboard = ClipboardInterface.getManager(context);
        ClipData clip = clipboard.getPrimaryClip();
        return ClipboardInterface.hasText(context) ? clip.getItemAt(0).coerceToText(context) : null;
    }

    public static void setText(CharSequence text, Context context) {
        if (text != null) {
            try {
                ClipboardInterface.getManager(context).setPrimaryClip(ClipData.newPlainText(null, (CharSequence)text));
            }
            catch (IllegalStateException | NullPointerException e) {
                Log.w((String)TAG, (String)"Clipboard bug", (Throwable)e);
            }
        }
    }

    public static boolean hasText(Context context) {
        ClipboardManager clipboard = ClipboardInterface.getManager(context);
        ClipData clip = clipboard.getPrimaryClip();
        return clip != null && clip.getItemCount() > 0;
    }

    private static ClipboardManager getManager(Context context) {
        return (ClipboardManager)context.getSystemService("clipboard");
    }
}

