/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.detector;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.common.GridSampler;
import com.google.zxing.common.detector.MathUtils;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Detector {
    private static final int INTEGER_MATH_SHIFT = 8;
    private static final int PATTERN_MATCH_RESULT_SCALE_FACTOR = 256;
    private static final int MAX_AVG_VARIANCE = 107;
    private static final int MAX_INDIVIDUAL_VARIANCE = 204;
    private static final int SKEW_THRESHOLD = 3;
    private static final int[] START_PATTERN = new int[]{8, 1, 1, 1, 1, 1, 1, 3};
    private static final int[] START_PATTERN_REVERSE = new int[]{3, 1, 1, 1, 1, 1, 1, 8};
    private static final int[] STOP_PATTERN = new int[]{7, 1, 1, 3, 1, 1, 1, 2, 1};
    private static final int[] STOP_PATTERN_REVERSE = new int[]{1, 2, 1, 1, 1, 3, 1, 1, 7};
    private final BinaryBitmap image;

    public Detector(BinaryBitmap image) {
        this.image = image;
    }

    public DetectorResult detect() throws NotFoundException {
        return this.detect(null);
    }

    public DetectorResult detect(Map<DecodeHintType, ?> hints) throws NotFoundException {
        boolean tryHarder;
        BitMatrix matrix = this.image.getBlackMatrix();
        ResultPoint[] vertices = Detector.findVertices(matrix, tryHarder = hints != null && hints.containsKey((Object)DecodeHintType.TRY_HARDER));
        if (vertices == null) {
            vertices = Detector.findVertices180(matrix, tryHarder);
            if (vertices != null) {
                Detector.correctCodeWordVertices(vertices, true);
            }
        } else {
            Detector.correctCodeWordVertices(vertices, false);
        }
        if (vertices == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        float moduleWidth = Detector.computeModuleWidth(vertices);
        if (moduleWidth < 1.0f) {
            throw NotFoundException.getNotFoundInstance();
        }
        int dimension = Detector.computeDimension(vertices[4], vertices[6], vertices[5], vertices[7], moduleWidth);
        if (dimension < 1) {
            throw NotFoundException.getNotFoundInstance();
        }
        int ydimension = Detector.computeYDimension(vertices[4], vertices[6], vertices[5], vertices[7], moduleWidth);
        ydimension = ydimension > dimension ? ydimension : dimension;
        BitMatrix bits = Detector.sampleGrid(matrix, vertices[4], vertices[5], vertices[6], vertices[7], dimension, ydimension);
        return new DetectorResult(bits, new ResultPoint[]{vertices[5], vertices[4], vertices[6], vertices[7]});
    }

    private static ResultPoint[] findVertices(BitMatrix matrix, boolean tryHarder) {
        int[] loc;
        int i;
        int height = matrix.getHeight();
        int width = matrix.getWidth();
        ResultPoint[] result = new ResultPoint[8];
        boolean found = false;
        int[] counters = new int[START_PATTERN.length];
        int rowStep = Math.max(1, height >> (tryHarder ? 9 : 7));
        for (i = 0; i < height; i += rowStep) {
            loc = Detector.findGuardPattern(matrix, 0, i, width, false, START_PATTERN, counters);
            if (loc == null) continue;
            result[0] = new ResultPoint(loc[0], i);
            result[4] = new ResultPoint(loc[1], i);
            found = true;
            break;
        }
        if (found) {
            found = false;
            for (i = height - 1; i > 0; i -= rowStep) {
                loc = Detector.findGuardPattern(matrix, 0, i, width, false, START_PATTERN, counters);
                if (loc == null) continue;
                result[1] = new ResultPoint(loc[0], i);
                result[5] = new ResultPoint(loc[1], i);
                found = true;
                break;
            }
        }
        counters = new int[STOP_PATTERN.length];
        if (found) {
            found = false;
            for (i = 0; i < height; i += rowStep) {
                loc = Detector.findGuardPattern(matrix, 0, i, width, false, STOP_PATTERN, counters);
                if (loc == null) continue;
                result[2] = new ResultPoint(loc[1], i);
                result[6] = new ResultPoint(loc[0], i);
                found = true;
                break;
            }
        }
        if (found) {
            found = false;
            for (i = height - 1; i > 0; i -= rowStep) {
                loc = Detector.findGuardPattern(matrix, 0, i, width, false, STOP_PATTERN, counters);
                if (loc == null) continue;
                result[3] = new ResultPoint(loc[1], i);
                result[7] = new ResultPoint(loc[0], i);
                found = true;
                break;
            }
        }
        return found ? result : null;
    }

    private static ResultPoint[] findVertices180(BitMatrix matrix, boolean tryHarder) {
        int[] loc;
        int i;
        int height = matrix.getHeight();
        int width = matrix.getWidth();
        int halfWidth = width >> 1;
        ResultPoint[] result = new ResultPoint[8];
        boolean found = false;
        int[] counters = new int[START_PATTERN_REVERSE.length];
        int rowStep = Math.max(1, height >> (tryHarder ? 9 : 7));
        for (i = height - 1; i > 0; i -= rowStep) {
            loc = Detector.findGuardPattern(matrix, halfWidth, i, halfWidth, true, START_PATTERN_REVERSE, counters);
            if (loc == null) continue;
            result[0] = new ResultPoint(loc[1], i);
            result[4] = new ResultPoint(loc[0], i);
            found = true;
            break;
        }
        if (found) {
            found = false;
            for (i = 0; i < height; i += rowStep) {
                loc = Detector.findGuardPattern(matrix, halfWidth, i, halfWidth, true, START_PATTERN_REVERSE, counters);
                if (loc == null) continue;
                result[1] = new ResultPoint(loc[1], i);
                result[5] = new ResultPoint(loc[0], i);
                found = true;
                break;
            }
        }
        counters = new int[STOP_PATTERN_REVERSE.length];
        if (found) {
            found = false;
            for (i = height - 1; i > 0; i -= rowStep) {
                loc = Detector.findGuardPattern(matrix, 0, i, halfWidth, false, STOP_PATTERN_REVERSE, counters);
                if (loc == null) continue;
                result[2] = new ResultPoint(loc[0], i);
                result[6] = new ResultPoint(loc[1], i);
                found = true;
                break;
            }
        }
        if (found) {
            found = false;
            for (i = 0; i < height; i += rowStep) {
                loc = Detector.findGuardPattern(matrix, 0, i, halfWidth, false, STOP_PATTERN_REVERSE, counters);
                if (loc == null) continue;
                result[3] = new ResultPoint(loc[0], i);
                result[7] = new ResultPoint(loc[1], i);
                found = true;
                break;
            }
        }
        return found ? result : null;
    }

    private static void correctCodeWordVertices(ResultPoint[] vertices, boolean upsideDown) {
        float correction;
        float delta2;
        float deltay;
        float deltax;
        float v0x = vertices[0].getX();
        float v0y = vertices[0].getY();
        float v2x = vertices[2].getX();
        float v2y = vertices[2].getY();
        float v4x = vertices[4].getX();
        float v4y = vertices[4].getY();
        float v6x = vertices[6].getX();
        float v6y = vertices[6].getY();
        float skew = v4y - v6y;
        if (upsideDown) {
            skew = -skew;
        }
        if (skew > 3.0f) {
            deltax = v6x - v0x;
            deltay = v6y - v0y;
            delta2 = deltax * deltax + deltay * deltay;
            correction = (v4x - v0x) * deltax / delta2;
            vertices[4] = new ResultPoint(v0x + correction * deltax, v0y + correction * deltay);
        } else if (-skew > 3.0f) {
            deltax = v2x - v4x;
            deltay = v2y - v4y;
            delta2 = deltax * deltax + deltay * deltay;
            correction = (v2x - v6x) * deltax / delta2;
            vertices[6] = new ResultPoint(v2x - correction * deltax, v2y - correction * deltay);
        }
        float v1x = vertices[1].getX();
        float v1y = vertices[1].getY();
        float v3x = vertices[3].getX();
        float v3y = vertices[3].getY();
        float v5x = vertices[5].getX();
        float v5y = vertices[5].getY();
        float v7x = vertices[7].getX();
        float v7y = vertices[7].getY();
        skew = v7y - v5y;
        if (upsideDown) {
            skew = -skew;
        }
        if (skew > 3.0f) {
            float deltax2 = v7x - v1x;
            float deltay2 = v7y - v1y;
            float delta22 = deltax2 * deltax2 + deltay2 * deltay2;
            float correction2 = (v5x - v1x) * deltax2 / delta22;
            vertices[5] = new ResultPoint(v1x + correction2 * deltax2, v1y + correction2 * deltay2);
        } else if (-skew > 3.0f) {
            float deltax3 = v3x - v5x;
            float deltay3 = v3y - v5y;
            float delta23 = deltax3 * deltax3 + deltay3 * deltay3;
            float correction3 = (v3x - v7x) * deltax3 / delta23;
            vertices[7] = new ResultPoint(v3x - correction3 * deltax3, v3y - correction3 * deltay3);
        }
    }

    private static float computeModuleWidth(ResultPoint[] vertices) {
        float pixels1 = ResultPoint.distance(vertices[0], vertices[4]);
        float pixels2 = ResultPoint.distance(vertices[1], vertices[5]);
        float moduleWidth1 = (pixels1 + pixels2) / 34.0f;
        float pixels3 = ResultPoint.distance(vertices[6], vertices[2]);
        float pixels4 = ResultPoint.distance(vertices[7], vertices[3]);
        float moduleWidth2 = (pixels3 + pixels4) / 36.0f;
        return (moduleWidth1 + moduleWidth2) / 2.0f;
    }

    private static int computeDimension(ResultPoint topLeft, ResultPoint topRight, ResultPoint bottomLeft, ResultPoint bottomRight, float moduleWidth) {
        int topRowDimension = MathUtils.round(ResultPoint.distance(topLeft, topRight) / moduleWidth);
        int bottomRowDimension = MathUtils.round(ResultPoint.distance(bottomLeft, bottomRight) / moduleWidth);
        return ((topRowDimension + bottomRowDimension >> 1) + 8) / 17 * 17;
    }

    private static int computeYDimension(ResultPoint topLeft, ResultPoint topRight, ResultPoint bottomLeft, ResultPoint bottomRight, float moduleWidth) {
        int leftColumnDimension = MathUtils.round(ResultPoint.distance(topLeft, bottomLeft) / moduleWidth);
        int rightColumnDimension = MathUtils.round(ResultPoint.distance(topRight, bottomRight) / moduleWidth);
        return leftColumnDimension + rightColumnDimension >> 1;
    }

    private static BitMatrix sampleGrid(BitMatrix matrix, ResultPoint topLeft, ResultPoint bottomLeft, ResultPoint topRight, ResultPoint bottomRight, int xdimension, int ydimension) throws NotFoundException {
        GridSampler sampler = GridSampler.getInstance();
        return sampler.sampleGrid(matrix, xdimension, ydimension, 0.0f, 0.0f, xdimension, 0.0f, xdimension, ydimension, 0.0f, ydimension, topLeft.getX(), topLeft.getY(), topRight.getX(), topRight.getY(), bottomRight.getX(), bottomRight.getY(), bottomLeft.getX(), bottomLeft.getY());
    }

    private static int[] findGuardPattern(BitMatrix matrix, int column, int row, int width, boolean whiteFirst, int[] pattern, int[] counters) {
        Arrays.fill(counters, 0, counters.length, 0);
        int patternLength = pattern.length;
        boolean isWhite = whiteFirst;
        int counterPosition = 0;
        int patternStart = column;
        for (int x = column; x < column + width; ++x) {
            boolean pixel = matrix.get(x, row);
            if (pixel ^ isWhite) {
                int n = counterPosition;
                counters[n] = counters[n] + 1;
                continue;
            }
            if (counterPosition == patternLength - 1) {
                if (Detector.patternMatchVariance(counters, pattern, 204) < 107) {
                    return new int[]{patternStart, x};
                }
                patternStart += counters[0] + counters[1];
                System.arraycopy(counters, 2, counters, 0, patternLength - 2);
                counters[patternLength - 2] = 0;
                counters[patternLength - 1] = 0;
                --counterPosition;
            } else {
                ++counterPosition;
            }
            counters[counterPosition] = 1;
            isWhite = !isWhite;
        }
        return null;
    }

    private static int patternMatchVariance(int[] counters, int[] pattern, int maxIndividualVariance) {
        int numCounters = counters.length;
        int total = 0;
        int patternLength = 0;
        for (int i = 0; i < numCounters; ++i) {
            total += counters[i];
            patternLength += pattern[i];
        }
        if (total < patternLength) {
            return Integer.MAX_VALUE;
        }
        int unitBarWidth = (total << 8) / patternLength;
        maxIndividualVariance = maxIndividualVariance * unitBarWidth >> 8;
        int totalVariance = 0;
        for (int x = 0; x < numCounters; ++x) {
            int variance;
            int counter = counters[x] << 8;
            int scaledPattern = pattern[x] * unitBarWidth;
            int n = variance = counter > scaledPattern ? counter - scaledPattern : scaledPattern - counter;
            if (variance > maxIndividualVariance) {
                return Integer.MAX_VALUE;
            }
            totalVariance += variance;
        }
        return totalVariance / total;
    }
}

