/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.pdf417.decoder.Decoder;
import com.google.zxing.pdf417.detector.Detector;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PDF417Reader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private final Decoder decoder = new Decoder();

    @Override
    public Result decode(BinaryBitmap image) throws NotFoundException, FormatException, ChecksumException {
        return this.decode(image, null);
    }

    @Override
    public Result decode(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException, FormatException, ChecksumException {
        ResultPoint[] points;
        DecoderResult decoderResult;
        if (hints != null && hints.containsKey((Object)DecodeHintType.PURE_BARCODE)) {
            BitMatrix bits = PDF417Reader.extractPureBits(image.getBlackMatrix());
            decoderResult = this.decoder.decode(bits);
            points = NO_POINTS;
        } else {
            DetectorResult detectorResult = new Detector(image).detect();
            decoderResult = this.decoder.decode(detectorResult.getBits());
            points = detectorResult.getPoints();
        }
        return new Result(decoderResult.getText(), decoderResult.getRawBytes(), points, BarcodeFormat.PDF_417);
    }

    @Override
    public void reset() {
    }

    private static BitMatrix extractPureBits(BitMatrix image) throws NotFoundException {
        int[] leftTopBlack = image.getTopLeftOnBit();
        int[] rightBottomBlack = image.getBottomRightOnBit();
        if (leftTopBlack == null || rightBottomBlack == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        int moduleSize = PDF417Reader.moduleSize(leftTopBlack, image);
        int top = leftTopBlack[1];
        int bottom = rightBottomBlack[1];
        int left = PDF417Reader.findPatternStart(leftTopBlack[0], top, image);
        int right = PDF417Reader.findPatternEnd(leftTopBlack[0], top, image);
        int matrixWidth = (right - left + 1) / moduleSize;
        int matrixHeight = (bottom - top + 1) / moduleSize;
        if (matrixWidth <= 0 || matrixHeight <= 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        int nudge = moduleSize >> 1;
        top += nudge;
        left += nudge;
        BitMatrix bits = new BitMatrix(matrixWidth, matrixHeight);
        for (int y = 0; y < matrixHeight; ++y) {
            int iOffset = top + y * moduleSize;
            for (int x = 0; x < matrixWidth; ++x) {
                if (!image.get(left + x * moduleSize, iOffset)) continue;
                bits.set(x, y);
            }
        }
        return bits;
    }

    private static int moduleSize(int[] leftTopBlack, BitMatrix image) throws NotFoundException {
        int x;
        int y = leftTopBlack[1];
        int width = image.getWidth();
        for (x = leftTopBlack[0]; x < width && image.get(x, y); ++x) {
        }
        if (x == width) {
            throw NotFoundException.getNotFoundInstance();
        }
        int moduleSize = x - leftTopBlack[0] >>> 3;
        if (moduleSize == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        return moduleSize;
    }

    private static int findPatternStart(int x, int y, BitMatrix image) throws NotFoundException {
        int width = image.getWidth();
        int start = x;
        int transitions = 0;
        boolean black = true;
        while (start < width - 1 && transitions < 8) {
            boolean newBlack;
            if (black != (newBlack = image.get(++start, y))) {
                ++transitions;
            }
            black = newBlack;
        }
        if (start == width - 1) {
            throw NotFoundException.getNotFoundInstance();
        }
        return start;
    }

    private static int findPatternEnd(int x, int y, BitMatrix image) throws NotFoundException {
        int end;
        int width = image.getWidth();
        for (end = width - 1; end > x && !image.get(end, y); --end) {
        }
        int transitions = 0;
        boolean black = true;
        while (end > x && transitions < 9) {
            boolean newBlack;
            if (black != (newBlack = image.get(--end, y))) {
                ++transitions;
            }
            black = newBlack;
        }
        if (end == x) {
            throw NotFoundException.getNotFoundInstance();
        }
        return end;
    }
}

