/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.share;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import com.google.zxing.client.android.share.AppPickerActivity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LoadPackagesAsyncTask
extends AsyncTask<List<String[]>, Object, List<String[]>> {
    private static final String[] PKG_PREFIX_WHITELIST = new String[]{"com.google.android.apps."};
    private static final String[] PKG_PREFIX_BLACKLIST = new String[]{"com.android.", "android", "com.google.android.", "com.htc"};
    private final AppPickerActivity activity;

    LoadPackagesAsyncTask(AppPickerActivity activity) {
        this.activity = activity;
    }

    protected List<String[]> doInBackground(List<String[]> ... objects) {
        List<String[]> labelsPackages = objects[0];
        PackageManager packageManager = this.activity.getPackageManager();
        List appInfos = packageManager.getInstalledApplications(0);
        for (ApplicationInfo appInfo : appInfos) {
            String packageName;
            CharSequence label = appInfo.loadLabel(packageManager);
            if (label == null || LoadPackagesAsyncTask.isHidden(packageName = appInfo.packageName)) continue;
            labelsPackages.add(new String[]{label.toString(), packageName});
        }
        Collections.sort(labelsPackages, new ByFirstStringComparator());
        return labelsPackages;
    }

    private static boolean isHidden(String packageName) {
        if (packageName == null) {
            return true;
        }
        for (String prefix : PKG_PREFIX_WHITELIST) {
            if (!packageName.startsWith(prefix)) continue;
            return false;
        }
        for (String prefix : PKG_PREFIX_BLACKLIST) {
            if (!packageName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    protected synchronized void onPostExecute(List<String[]> results) {
        ArrayList<String> labels = new ArrayList<String>(results.size());
        for (String[] result : results) {
            labels.add(result[0]);
        }
        ArrayAdapter listAdapter = new ArrayAdapter((Context)this.activity, 17367043, labels);
        this.activity.setListAdapter((ListAdapter)listAdapter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByFirstStringComparator
    implements Comparator<String[]>,
    Serializable {
        private ByFirstStringComparator() {
        }

        @Override
        public int compare(String[] o1, String[] o2) {
            return o1[0].compareTo(o2[0]);
        }
    }
}

