/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.result.supplement;

import android.widget.TextView;
import com.google.zxing.client.android.HttpHelper;
import com.google.zxing.client.android.history.HistoryManager;
import com.google.zxing.client.android.result.supplement.SupplementalInfoRetriever;
import com.google.zxing.client.result.URIParsedResult;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class TitleRetriever
extends SupplementalInfoRetriever {
    private static final Pattern TITLE_PATTERN = Pattern.compile("<title>([^<]+)");
    private static final int MAX_TITLE_LEN = 100;
    private final String httpUrl;

    TitleRetriever(TextView textView, URIParsedResult result, HistoryManager historyManager) {
        super(textView, historyManager);
        this.httpUrl = result.getURI();
    }

    void retrieveSupplementalInfo() {
        String title;
        Matcher m;
        CharSequence contents;
        try {
            contents = HttpHelper.downloadViaHttp(this.httpUrl, HttpHelper.ContentType.HTML, 4096);
        }
        catch (IOException ioe) {
            return;
        }
        if (contents != null && contents.length() > 0 && (m = TITLE_PATTERN.matcher(contents)).find() && (title = m.group(1)) != null && title.length() > 0) {
            if (title.length() > 100) {
                title = title.substring(0, 100) + "...";
            }
            this.append(this.httpUrl, null, new String[]{title}, this.httpUrl);
        }
    }
}

