/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.result.supplement;

import android.content.Context;
import android.os.AsyncTask;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.method.LinkMovementMethod;
import android.text.style.URLSpan;
import android.util.Log;
import android.widget.TextView;
import com.google.zxing.client.android.common.executor.AsyncTaskExecInterface;
import com.google.zxing.client.android.common.executor.AsyncTaskExecManager;
import com.google.zxing.client.android.history.HistoryManager;
import com.google.zxing.client.android.result.supplement.BookResultInfoRetriever;
import com.google.zxing.client.android.result.supplement.ProductResultInfoRetriever;
import com.google.zxing.client.android.result.supplement.TitleRetriever;
import com.google.zxing.client.android.result.supplement.URIResultInfoRetriever;
import com.google.zxing.client.result.ISBNParsedResult;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ProductParsedResult;
import com.google.zxing.client.result.URIParsedResult;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SupplementalInfoRetriever
extends AsyncTask<Object, Object, Object> {
    private static final String TAG = "SupplementalInfo";
    private final WeakReference<TextView> textViewRef;
    private final WeakReference<HistoryManager> historyManagerRef;
    private final List<Spannable> newContents;
    private final List<String[]> newHistories;

    public static void maybeInvokeRetrieval(TextView textView, ParsedResult result, HistoryManager historyManager, Context context) {
        AsyncTaskExecInterface taskExec = (AsyncTaskExecInterface)new AsyncTaskExecManager().build();
        if (result instanceof URIParsedResult) {
            taskExec.execute(new URIResultInfoRetriever(textView, (URIParsedResult)result, historyManager, context), new Object[0]);
            taskExec.execute(new TitleRetriever(textView, (URIParsedResult)result, historyManager), new Object[0]);
        } else if (result instanceof ProductParsedResult) {
            String productID = ((ProductParsedResult)result).getProductID();
            taskExec.execute(new ProductResultInfoRetriever(textView, productID, historyManager, context), new Object[0]);
        } else if (result instanceof ISBNParsedResult) {
            String isbn = ((ISBNParsedResult)result).getISBN();
            taskExec.execute(new ProductResultInfoRetriever(textView, isbn, historyManager, context), new Object[0]);
            taskExec.execute(new BookResultInfoRetriever(textView, isbn, historyManager, context), new Object[0]);
        }
    }

    SupplementalInfoRetriever(TextView textView, HistoryManager historyManager) {
        this.textViewRef = new WeakReference<TextView>(textView);
        this.historyManagerRef = new WeakReference<HistoryManager>(historyManager);
        this.newContents = new ArrayList<Spannable>();
        this.newHistories = new ArrayList<String[]>();
    }

    public final Object doInBackground(Object ... args) {
        try {
            this.retrieveSupplementalInfo();
        }
        catch (IOException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        return null;
    }

    protected void onPostExecute(Object arg) {
        HistoryManager historyManager;
        TextView textView = (TextView)this.textViewRef.get();
        if (textView != null) {
            for (Spannable content : this.newContents) {
                textView.append((CharSequence)content);
            }
            textView.setMovementMethod(LinkMovementMethod.getInstance());
        }
        if ((historyManager = (HistoryManager)this.historyManagerRef.get()) != null) {
            for (String[] text : this.newHistories) {
                historyManager.addHistoryItemDetails(text[0], text[1]);
            }
        }
    }

    abstract void retrieveSupplementalInfo() throws IOException;

    final void append(String itemID, String source, String[] newTexts, String linkURL) {
        StringBuilder newTextCombined = new StringBuilder();
        if (source != null) {
            newTextCombined.append(source).append(" : ");
        }
        int linkStart = newTextCombined.length();
        boolean first = true;
        for (String newText : newTexts) {
            if (first) {
                newTextCombined.append(newText);
                first = false;
                continue;
            }
            newTextCombined.append(" [");
            newTextCombined.append(newText);
            newTextCombined.append(']');
        }
        int linkEnd = newTextCombined.length();
        String newText = newTextCombined.toString();
        SpannableString content = new SpannableString((CharSequence)(newText + "\n\n"));
        if (linkURL != null) {
            if (linkURL.startsWith("HTTP://")) {
                linkURL = "http" + linkURL.substring(4);
            } else if (linkURL.startsWith("HTTPS://")) {
                linkURL = "https" + linkURL.substring(5);
            }
            content.setSpan((Object)new URLSpan(linkURL), linkStart, linkEnd, 33);
        }
        this.newContents.add((Spannable)content);
        this.newHistories.add(new String[]{itemID, newText});
    }
}

