/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.result.supplement;

import android.content.Context;
import android.text.Html;
import android.widget.TextView;
import com.google.zxing.FakeR;
import com.google.zxing.client.android.HttpHelper;
import com.google.zxing.client.android.LocaleManager;
import com.google.zxing.client.android.history.HistoryManager;
import com.google.zxing.client.android.result.supplement.SupplementalInfoRetriever;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ProductResultInfoRetriever
extends SupplementalInfoRetriever {
    private static final Pattern[] PRODUCT_NAME_PRICE_PATTERNS = new Pattern[]{Pattern.compile(",event\\)\">([^<]+)</a></h3>.+<span class=psrp>([^<]+)</span>"), Pattern.compile("owb63p\">([^<]+).+zdi3pb\">([^<]+)")};
    private final String productID;
    private final String source;
    private final Context context;

    ProductResultInfoRetriever(TextView textView, String productID, HistoryManager historyManager, Context context) {
        super(textView, historyManager);
        this.productID = productID;
        this.source = context.getString(FakeR.getId(context, "string", "msg_google_product"));
        this.context = context;
    }

    void retrieveSupplementalInfo() throws IOException {
        String encodedProductID = URLEncoder.encode(this.productID, "UTF-8");
        String uri = "http://www.google." + LocaleManager.getProductSearchCountryTLD(this.context) + "/m/products?ie=utf8&oe=utf8&scoring=p&source=zxing&q=" + encodedProductID;
        CharSequence content = HttpHelper.downloadViaHttp(uri, HttpHelper.ContentType.HTML);
        for (Pattern p : PRODUCT_NAME_PRICE_PATTERNS) {
            Matcher matcher = p.matcher(content);
            if (!matcher.find()) continue;
            this.append(this.productID, this.source, new String[]{ProductResultInfoRetriever.unescapeHTML(matcher.group(1)), ProductResultInfoRetriever.unescapeHTML(matcher.group(2))}, uri);
            break;
        }
    }

    private static String unescapeHTML(String raw) {
        return Html.fromHtml((String)raw).toString();
    }
}

