/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.result.supplement;

import android.content.Context;
import android.widget.TextView;
import com.google.zxing.FakeR;
import com.google.zxing.client.android.HttpHelper;
import com.google.zxing.client.android.LocaleManager;
import com.google.zxing.client.android.history.HistoryManager;
import com.google.zxing.client.android.result.supplement.SupplementalInfoRetriever;
import java.io.IOException;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

final class BookResultInfoRetriever
extends SupplementalInfoRetriever {
    private final String isbn;
    private final String source;
    private final Context context;

    BookResultInfoRetriever(TextView textView, String isbn, HistoryManager historyManager, Context context) {
        super(textView, historyManager);
        this.isbn = isbn;
        this.source = context.getString(FakeR.getId(context, "string", "msg_google_books"));
        this.context = context;
    }

    void retrieveSupplementalInfo() throws IOException {
        String pages;
        String title;
        CharSequence contents = HttpHelper.downloadViaHttp("https://www.googleapis.com/books/v1/volumes?q=isbn:" + this.isbn, HttpHelper.ContentType.JSON);
        if (contents.length() == 0) {
            return;
        }
        ArrayList<String> authors = null;
        try {
            JSONObject topLevel = (JSONObject)new JSONTokener(contents.toString()).nextValue();
            JSONArray items = topLevel.optJSONArray("items");
            if (items == null || items.isNull(0)) {
                return;
            }
            JSONObject volumeInfo = ((JSONObject)items.get(0)).getJSONObject("volumeInfo");
            if (volumeInfo == null) {
                return;
            }
            title = volumeInfo.optString("title");
            pages = volumeInfo.optString("pageCount");
            JSONArray authorsArray = volumeInfo.optJSONArray("authors");
            if (authorsArray != null && !authorsArray.isNull(0)) {
                authors = new ArrayList<String>(authorsArray.length());
                for (int i = 0; i < authorsArray.length(); ++i) {
                    authors.add(authorsArray.getString(i));
                }
            }
        }
        catch (JSONException e) {
            throw new IOException(e.toString());
        }
        ArrayList<String> newTexts = new ArrayList<String>();
        if (title != null && title.length() > 0) {
            newTexts.add(title);
        }
        if (authors != null && !authors.isEmpty()) {
            boolean first = true;
            StringBuilder authorsText = new StringBuilder();
            for (String author : authors) {
                if (first) {
                    first = false;
                } else {
                    authorsText.append(", ");
                }
                authorsText.append(author);
            }
            newTexts.add(authorsText.toString());
        }
        if (pages != null && pages.length() > 0) {
            newTexts.add(pages + "pp.");
        }
        String baseBookUri = "http://www.google." + LocaleManager.getBookSearchCountryTLD(this.context) + "/search?tbm=bks&source=zxing&q=";
        this.append(this.isbn, this.source, newTexts.toArray(new String[newTexts.size()]), baseBookUri + this.isbn);
    }
}

