/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.result;

import android.content.Context;
import android.net.wifi.WifiManager;
import android.widget.Toast;
import com.google.zxing.client.android.CaptureActivity;
import com.google.zxing.client.android.common.executor.AsyncTaskExecInterface;
import com.google.zxing.client.android.common.executor.AsyncTaskExecManager;
import com.google.zxing.client.android.result.ResultHandler;
import com.google.zxing.client.android.wifi.WifiConfigManager;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.WifiParsedResult;

public final class WifiResultHandler
extends ResultHandler {
    private final CaptureActivity parent;
    private final AsyncTaskExecInterface taskExec;

    public WifiResultHandler(CaptureActivity activity, ParsedResult result) {
        super(activity, result);
        this.parent = activity;
        this.taskExec = (AsyncTaskExecInterface)new AsyncTaskExecManager().build();
    }

    public int getButtonCount() {
        return 1;
    }

    public int getButtonText(int index) {
        return fakeR.getId("string", "button_wifi");
    }

    public void handleButtonPress(int index) {
        if (index == 0) {
            WifiParsedResult wifiResult = (WifiParsedResult)this.getResult();
            WifiManager wifiManager = (WifiManager)this.getActivity().getSystemService("wifi");
            Toast.makeText((Context)this.getActivity(), (int)fakeR.getId("string", "wifi_changing_network"), (int)1).show();
            this.taskExec.execute(new WifiConfigManager(wifiManager), wifiResult);
            this.parent.restartPreviewAfterDelay(0L);
        }
    }

    public CharSequence getDisplayContents() {
        WifiParsedResult wifiResult = (WifiParsedResult)this.getResult();
        StringBuilder contents = new StringBuilder(50);
        String wifiLabel = this.parent.getString(fakeR.getId("string", "wifi_ssid_label"));
        ParsedResult.maybeAppend(wifiLabel + '\n' + wifiResult.getSsid(), contents);
        String typeLabel = this.parent.getString(fakeR.getId("string", "wifi_type_label"));
        ParsedResult.maybeAppend(typeLabel + '\n' + wifiResult.getNetworkEncryption(), contents);
        return contents.toString();
    }

    public int getDisplayTitle() {
        return fakeR.getId("string", "result_wifi");
    }
}

