/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.result;

import android.app.Activity;
import com.google.zxing.client.android.LocaleManager;
import com.google.zxing.client.android.result.ResultHandler;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.URIParsedResult;
import java.util.Locale;

public final class URIResultHandler
extends ResultHandler {
    private static final String[] SECURE_PROTOCOLS = new String[]{"otpauth:"};
    private static int[] buttons;

    public URIResultHandler(Activity activity, ParsedResult result) {
        super(activity, result);
        buttons = new int[]{fakeR.getId("string", "button_open_browser"), fakeR.getId("string", "button_share_by_email"), fakeR.getId("string", "button_share_by_sms"), fakeR.getId("string", "button_search_book_contents")};
    }

    public int getButtonCount() {
        if (LocaleManager.isBookSearchUrl(((URIParsedResult)this.getResult()).getURI())) {
            return buttons.length;
        }
        return buttons.length - 1;
    }

    public int getButtonText(int index) {
        return buttons[index];
    }

    public void handleButtonPress(int index) {
        URIParsedResult uriResult = (URIParsedResult)this.getResult();
        String uri = uriResult.getURI();
        switch (index) {
            case 0: {
                this.openURL(uri);
                break;
            }
            case 1: {
                this.shareByEmail(uri);
                break;
            }
            case 2: {
                this.shareBySMS(uri);
                break;
            }
            case 3: {
                this.searchBookContents(uri);
            }
        }
    }

    public int getDisplayTitle() {
        return fakeR.getId("string", "result_uri");
    }

    public boolean areContentsSecure() {
        URIParsedResult uriResult = (URIParsedResult)this.getResult();
        String uri = uriResult.getURI().toLowerCase(Locale.ENGLISH);
        for (String secure : SECURE_PROTOCOLS) {
            if (!uri.startsWith(secure)) continue;
            return true;
        }
        return false;
    }
}

