/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.result;

import android.app.Activity;
import android.telephony.PhoneNumberUtils;
import com.google.zxing.client.android.result.ResultHandler;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.SMSParsedResult;

public final class SMSResultHandler
extends ResultHandler {
    private static int[] buttons;

    public SMSResultHandler(Activity activity, ParsedResult result) {
        super(activity, result);
        buttons = new int[]{fakeR.getId("string", "button_sms"), fakeR.getId("string", "button_mms")};
    }

    public int getButtonCount() {
        return buttons.length;
    }

    public int getButtonText(int index) {
        return buttons[index];
    }

    public void handleButtonPress(int index) {
        SMSParsedResult smsResult = (SMSParsedResult)this.getResult();
        switch (index) {
            case 0: {
                this.sendSMS(smsResult.getNumbers()[0], smsResult.getBody());
                break;
            }
            case 1: {
                this.sendMMS(smsResult.getNumbers()[0], smsResult.getSubject(), smsResult.getBody());
            }
        }
    }

    public CharSequence getDisplayContents() {
        SMSParsedResult smsResult = (SMSParsedResult)this.getResult();
        StringBuilder contents = new StringBuilder(50);
        String[] rawNumbers = smsResult.getNumbers();
        String[] formattedNumbers = new String[rawNumbers.length];
        for (int i = 0; i < rawNumbers.length; ++i) {
            formattedNumbers[i] = PhoneNumberUtils.formatNumber((String)rawNumbers[i]);
        }
        ParsedResult.maybeAppend(formattedNumbers, contents);
        ParsedResult.maybeAppend(smsResult.getSubject(), contents);
        ParsedResult.maybeAppend(smsResult.getBody(), contents);
        return contents.toString();
    }

    public int getDisplayTitle() {
        return fakeR.getId("string", "result_sms");
    }
}

