/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.result;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.provider.ContactsContract;
import android.util.Log;
import android.view.View;
import com.google.zxing.FakeR;
import com.google.zxing.Result;
import com.google.zxing.client.android.Contents;
import com.google.zxing.client.android.LocaleManager;
import com.google.zxing.client.android.book.SearchBookContentsActivity;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ParsedResultType;
import com.google.zxing.client.result.ResultParser;
import java.util.List;
import java.util.Locale;

public abstract class ResultHandler {
    private static final String TAG = ResultHandler.class.getSimpleName();
    private static final String GOOGLE_SHOPPER_PACKAGE = "com.google.android.apps.shopper";
    private static final String GOOGLE_SHOPPER_ACTIVITY = "com.google.android.apps.shopper.results.SearchResultsActivity";
    private static final String MARKET_URI_PREFIX = "market://details?id=";
    private static final String MARKET_REFERRER_SUFFIX = "&referrer=utm_source%3Dbarcodescanner%26utm_medium%3Dapps%26utm_campaign%3Dscan";
    private static final String[] EMAIL_TYPE_STRINGS = new String[]{"home", "work", "mobile"};
    private static final String[] PHONE_TYPE_STRINGS = new String[]{"home", "work", "mobile", "fax", "pager", "main"};
    private static final String[] ADDRESS_TYPE_STRINGS = new String[]{"home", "work"};
    private static final int[] EMAIL_TYPE_VALUES = new int[]{1, 2, 4};
    private static final int[] PHONE_TYPE_VALUES = new int[]{1, 3, 2, 4, 6, 12};
    private static final int[] ADDRESS_TYPE_VALUES = new int[]{1, 2};
    private static final int NO_TYPE = -1;
    public static final int MAX_BUTTON_COUNT = 4;
    private final ParsedResult result;
    private final Activity activity;
    private final Result rawResult;
    private final String customProductSearch;
    private final DialogInterface.OnClickListener shopperMarketListener = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialogInterface, int which) {
            ResultHandler.this.launchIntent(new Intent("android.intent.action.VIEW", Uri.parse((String)"market://details?id=com.google.android.apps.shopper&referrer=utm_source%3Dbarcodescanner%26utm_medium%3Dapps%26utm_campaign%3Dscan")));
        }
    };
    protected static FakeR fakeR;

    ResultHandler(Activity activity, ParsedResult result) {
        this(activity, result, null);
    }

    ResultHandler(Activity activity, ParsedResult result, Result rawResult) {
        this.result = result;
        this.activity = activity;
        this.rawResult = rawResult;
        this.customProductSearch = this.parseCustomSearchURL();
        fakeR = new FakeR(activity);
        View shopperButton = activity.findViewById(fakeR.getId("id", "shopper_button"));
        shopperButton.setVisibility(8);
    }

    public ParsedResult getResult() {
        return this.result;
    }

    boolean hasCustomProductSearch() {
        return this.customProductSearch != null;
    }

    Activity getActivity() {
        return this.activity;
    }

    public abstract int getButtonCount();

    public abstract int getButtonText(int var1);

    public abstract void handleButtonPress(int var1);

    public boolean areContentsSecure() {
        return false;
    }

    void showGoogleShopperButton(View.OnClickListener listener) {
        View shopperButton = this.activity.findViewById(fakeR.getId("id", "shopper_button"));
        shopperButton.setVisibility(0);
        shopperButton.setOnClickListener(listener);
    }

    public CharSequence getDisplayContents() {
        String contents = this.result.getDisplayResult();
        return contents.replace("\r", "");
    }

    public abstract int getDisplayTitle();

    public final ParsedResultType getType() {
        return this.result.getType();
    }

    final void addPhoneOnlyContact(String[] phoneNumbers, String[] phoneTypes) {
        this.addContact(null, null, phoneNumbers, phoneTypes, null, null, null, null, null, null, null, null, null, null);
    }

    final void addEmailOnlyContact(String[] emails, String[] emailTypes) {
        this.addContact(null, null, null, null, emails, emailTypes, null, null, null, null, null, null, null, null);
    }

    final void addContact(String[] names, String pronunciation, String[] phoneNumbers, String[] phoneTypes, String[] emails, String[] emailTypes, String note, String instantMessenger, String address, String addressType, String org, String title, String url, String birthday) {
        int type;
        Intent intent = new Intent("android.intent.action.INSERT_OR_EDIT", ContactsContract.Contacts.CONTENT_URI);
        intent.setType("vnd.android.cursor.item/contact");
        ResultHandler.putExtra(intent, "name", names != null ? names[0] : null);
        ResultHandler.putExtra(intent, "phonetic_name", pronunciation);
        int phoneCount = Math.min(phoneNumbers != null ? phoneNumbers.length : 0, Contents.PHONE_KEYS.length);
        for (int x = 0; x < phoneCount; ++x) {
            int type2;
            ResultHandler.putExtra(intent, Contents.PHONE_KEYS[x], phoneNumbers[x]);
            if (phoneTypes == null || x >= phoneTypes.length || (type2 = ResultHandler.toPhoneContractType(phoneTypes[x])) < 0) continue;
            intent.putExtra(Contents.PHONE_TYPE_KEYS[x], type2);
        }
        int emailCount = Math.min(emails != null ? emails.length : 0, Contents.EMAIL_KEYS.length);
        for (int x = 0; x < emailCount; ++x) {
            int type3;
            ResultHandler.putExtra(intent, Contents.EMAIL_KEYS[x], emails[x]);
            if (emailTypes == null || x >= emailTypes.length || (type3 = ResultHandler.toEmailContractType(emailTypes[x])) < 0) continue;
            intent.putExtra(Contents.EMAIL_TYPE_KEYS[x], type3);
        }
        StringBuilder aggregatedNotes = new StringBuilder();
        for (String aNote : new String[]{url, birthday, note}) {
            if (aNote == null) continue;
            if (aggregatedNotes.length() > 0) {
                aggregatedNotes.append('\n');
            }
            aggregatedNotes.append(aNote);
        }
        if (aggregatedNotes.length() > 0) {
            ResultHandler.putExtra(intent, "notes", aggregatedNotes.toString());
        }
        ResultHandler.putExtra(intent, "im_handle", instantMessenger);
        ResultHandler.putExtra(intent, "postal", address);
        if (addressType != null && (type = ResultHandler.toAddressContractType(addressType)) >= 0) {
            intent.putExtra("postal_type", type);
        }
        ResultHandler.putExtra(intent, "company", org);
        ResultHandler.putExtra(intent, "job_title", title);
        this.launchIntent(intent);
    }

    private static int toEmailContractType(String typeString) {
        return ResultHandler.doToContractType(typeString, EMAIL_TYPE_STRINGS, EMAIL_TYPE_VALUES);
    }

    private static int toPhoneContractType(String typeString) {
        return ResultHandler.doToContractType(typeString, PHONE_TYPE_STRINGS, PHONE_TYPE_VALUES);
    }

    private static int toAddressContractType(String typeString) {
        return ResultHandler.doToContractType(typeString, ADDRESS_TYPE_STRINGS, ADDRESS_TYPE_VALUES);
    }

    private static int doToContractType(String typeString, String[] types, int[] values) {
        if (typeString == null) {
            return -1;
        }
        for (int i = 0; i < types.length; ++i) {
            String type = types[i];
            if (!typeString.startsWith(type) && !typeString.startsWith(type.toUpperCase(Locale.ENGLISH))) continue;
            return values[i];
        }
        return -1;
    }

    final void shareByEmail(String contents) {
        this.sendEmailFromUri("mailto:", null, this.activity.getString(fakeR.getId("string", "msg_share_subject_line")), contents);
    }

    final void sendEmail(String address, String subject, String body) {
        this.sendEmailFromUri("mailto:" + address, address, subject, body);
    }

    final void sendEmailFromUri(String uri, String email, String subject, String body) {
        Intent intent = new Intent("android.intent.action.SEND", Uri.parse((String)uri));
        if (email != null) {
            intent.putExtra("android.intent.extra.EMAIL", new String[]{email});
        }
        ResultHandler.putExtra(intent, "android.intent.extra.SUBJECT", subject);
        ResultHandler.putExtra(intent, "android.intent.extra.TEXT", body);
        intent.setType("text/plain");
        this.launchIntent(intent);
    }

    final void shareBySMS(String contents) {
        this.sendSMSFromUri("smsto:", this.activity.getString(fakeR.getId("string", "msg_share_subject_line")) + ":\n" + contents);
    }

    final void sendSMS(String phoneNumber, String body) {
        this.sendSMSFromUri("smsto:" + phoneNumber, body);
    }

    final void sendSMSFromUri(String uri, String body) {
        Intent intent = new Intent("android.intent.action.SENDTO", Uri.parse((String)uri));
        ResultHandler.putExtra(intent, "sms_body", body);
        intent.putExtra("compose_mode", true);
        this.launchIntent(intent);
    }

    final void sendMMS(String phoneNumber, String subject, String body) {
        this.sendMMSFromUri("mmsto:" + phoneNumber, subject, body);
    }

    final void sendMMSFromUri(String uri, String subject, String body) {
        Intent intent = new Intent("android.intent.action.SENDTO", Uri.parse((String)uri));
        if (subject == null || subject.length() == 0) {
            ResultHandler.putExtra(intent, "subject", this.activity.getString(fakeR.getId("string", "msg_default_mms_subject")));
        } else {
            ResultHandler.putExtra(intent, "subject", subject);
        }
        ResultHandler.putExtra(intent, "sms_body", body);
        intent.putExtra("compose_mode", true);
        this.launchIntent(intent);
    }

    final void dialPhone(String phoneNumber) {
        this.launchIntent(new Intent("android.intent.action.DIAL", Uri.parse((String)("tel:" + phoneNumber))));
    }

    final void dialPhoneFromUri(String uri) {
        this.launchIntent(new Intent("android.intent.action.DIAL", Uri.parse((String)uri)));
    }

    final void openMap(String geoURI) {
        this.launchIntent(new Intent("android.intent.action.VIEW", Uri.parse((String)geoURI)));
    }

    final void searchMap(String address, CharSequence title) {
        String query = address;
        if (title != null && title.length() > 0) {
            query = query + " (" + title + ')';
        }
        this.launchIntent(new Intent("android.intent.action.VIEW", Uri.parse((String)("geo:0,0?q=" + Uri.encode((String)query)))));
    }

    final void getDirections(double latitude, double longitude) {
        this.launchIntent(new Intent("android.intent.action.VIEW", Uri.parse((String)("http://maps.google." + LocaleManager.getCountryTLD((Context)this.activity) + "/maps?f=d&daddr=" + latitude + ',' + longitude))));
    }

    final void openProductSearch(String upc) {
        Uri uri = Uri.parse((String)("http://www.google." + LocaleManager.getProductSearchCountryTLD((Context)this.activity) + "/m/products?q=" + upc + "&source=zxing"));
        this.launchIntent(new Intent("android.intent.action.VIEW", uri));
    }

    final void openBookSearch(String isbn) {
        Uri uri = Uri.parse((String)("http://books.google." + LocaleManager.getBookSearchCountryTLD((Context)this.activity) + "/books?vid=isbn" + isbn));
        this.launchIntent(new Intent("android.intent.action.VIEW", uri));
    }

    final void searchBookContents(String isbnOrUrl) {
        Intent intent = new Intent("com.google.zxing.client.android.SEARCH_BOOK_CONTENTS");
        intent.setClassName((Context)this.activity, SearchBookContentsActivity.class.getName());
        ResultHandler.putExtra(intent, "ISBN", isbnOrUrl);
        this.launchIntent(intent);
    }

    final void openURL(String url) {
        if (url.startsWith("HTTP://")) {
            url = "http" + url.substring(4);
        } else if (url.startsWith("HTTPS://")) {
            url = "https" + url.substring(5);
        }
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        try {
            this.launchIntent(intent);
        }
        catch (ActivityNotFoundException anfe) {
            Log.w((String)TAG, (String)("Nothing available to handle " + intent));
        }
    }

    final void webSearch(String query) {
        Intent intent = new Intent("android.intent.action.WEB_SEARCH");
        intent.putExtra("query", query);
        this.launchIntent(intent);
    }

    final void openGoogleShopper(String query) {
        Intent intent = new Intent("android.intent.action.SEARCH");
        intent.setClassName(GOOGLE_SHOPPER_PACKAGE, GOOGLE_SHOPPER_ACTIVITY);
        intent.putExtra("query", query);
        PackageManager pm = this.activity.getPackageManager();
        List availableApps = pm.queryIntentActivities(intent, 65536);
        if (availableApps != null && !availableApps.isEmpty()) {
            this.activity.startActivity(intent);
        } else {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.activity);
            builder.setTitle(fakeR.getId("string", "msg_google_shopper_missing"));
            builder.setMessage(fakeR.getId("string", "msg_install_google_shopper"));
            builder.setIcon(fakeR.getId("drawable", "shopper_icon"));
            builder.setPositiveButton(fakeR.getId("string", "button_ok"), this.shopperMarketListener);
            builder.setNegativeButton(fakeR.getId("string", "button_cancel"), null);
            builder.show();
        }
    }

    void rawLaunchIntent(Intent intent) {
        if (intent != null) {
            intent.addFlags(524288);
            Log.d((String)TAG, (String)("Launching intent: " + intent + " with extras: " + intent.getExtras()));
            this.activity.startActivity(intent);
        }
    }

    void launchIntent(Intent intent) {
        try {
            this.rawLaunchIntent(intent);
        }
        catch (ActivityNotFoundException e) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.activity);
            builder.setTitle(fakeR.getId("string", "app_name"));
            builder.setMessage(fakeR.getId("string", "msg_intent_failed"));
            builder.setPositiveButton(fakeR.getId("string", "button_ok"), null);
            builder.show();
        }
    }

    private static void putExtra(Intent intent, String key, String value) {
        if (value != null && value.length() > 0) {
            intent.putExtra(key, value);
        }
    }

    private String parseCustomSearchURL() {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.activity);
        String customProductSearch = prefs.getString("preferences_custom_product_search", null);
        if (customProductSearch != null && customProductSearch.trim().length() == 0) {
            return null;
        }
        return customProductSearch;
    }

    String fillInCustomSearchURL(String text) {
        if (this.customProductSearch == null) {
            return text;
        }
        String url = this.customProductSearch.replace("%s", text);
        if (this.rawResult != null && (url = url.replace("%f", this.rawResult.getBarcodeFormat().toString())).contains("%t")) {
            ParsedResult parsedResultAgain = ResultParser.parseResult(this.rawResult);
            url = url.replace("%t", parsedResultAgain.getType().toString());
        }
        return url;
    }
}

