/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.encode;

import android.telephony.PhoneNumberUtils;
import com.google.zxing.client.android.encode.ContactEncoder;
import com.google.zxing.client.android.encode.Formatter;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class VCardContactEncoder
extends ContactEncoder {
    private static final Pattern RESERVED_VCARD_CHARS = Pattern.compile("([\\\\,;])");
    private static final Pattern NEWLINE = Pattern.compile("\\n");
    private static final Formatter VCARD_FIELD_FORMATTER = new Formatter(){

        public String format(String source) {
            return NEWLINE.matcher(RESERVED_VCARD_CHARS.matcher(source).replaceAll("\\\\$1")).replaceAll("");
        }
    };
    private static final char TERMINATOR = '\n';

    VCardContactEncoder() {
    }

    @Override
    public String[] encode(Iterable<String> names, String organization, Iterable<String> addresses, Iterable<String> phones, Iterable<String> emails, String url, String note) {
        StringBuilder newContents = new StringBuilder(100);
        StringBuilder newDisplayContents = new StringBuilder(100);
        newContents.append("BEGIN:VCARD").append('\n');
        VCardContactEncoder.appendUpToUnique(newContents, newDisplayContents, "N", names, 1, null);
        VCardContactEncoder.append(newContents, newDisplayContents, "ORG", organization);
        VCardContactEncoder.appendUpToUnique(newContents, newDisplayContents, "ADR", addresses, 1, null);
        VCardContactEncoder.appendUpToUnique(newContents, newDisplayContents, "TEL", phones, Integer.MAX_VALUE, new Formatter(){

            public String format(String source) {
                return PhoneNumberUtils.formatNumber((String)source);
            }
        });
        VCardContactEncoder.appendUpToUnique(newContents, newDisplayContents, "EMAIL", emails, Integer.MAX_VALUE, null);
        VCardContactEncoder.append(newContents, newDisplayContents, "URL", url);
        VCardContactEncoder.append(newContents, newDisplayContents, "NOTE", note);
        newContents.append("END:VCARD").append('\n');
        return new String[]{newContents.toString(), newDisplayContents.toString()};
    }

    private static void append(StringBuilder newContents, StringBuilder newDisplayContents, String prefix, String value) {
        VCardContactEncoder.doAppend(newContents, newDisplayContents, prefix, value, VCARD_FIELD_FORMATTER, '\n');
    }

    private static void appendUpToUnique(StringBuilder newContents, StringBuilder newDisplayContents, String prefix, Iterable<String> values, int max, Formatter formatter) {
        VCardContactEncoder.doAppendUpToUnique(newContents, newDisplayContents, prefix, values, max, formatter, VCARD_FIELD_FORMATTER, '\n');
    }
}

