/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.encode;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.telephony.PhoneNumberUtils;
import android.util.Log;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.FakeR;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.android.Contents;
import com.google.zxing.client.android.encode.ContactEncoder;
import com.google.zxing.client.android.encode.MECARDContactEncoder;
import com.google.zxing.client.android.encode.VCardContactEncoder;
import com.google.zxing.client.result.AddressBookParsedResult;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.common.BitMatrix;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class QRCodeEncoder {
    private static final String TAG = QRCodeEncoder.class.getSimpleName();
    private static final int WHITE = -1;
    private static final int BLACK = -16777216;
    private final Activity activity;
    private String contents;
    private String displayContents;
    private String title;
    private BarcodeFormat format;
    private final int dimension;
    private final boolean useVCard;
    private static FakeR fakeR;

    QRCodeEncoder(Activity activity, Intent intent, int dimension, boolean useVCard) throws WriterException {
        fakeR = new FakeR(activity);
        this.activity = activity;
        this.dimension = dimension;
        this.useVCard = useVCard;
        String action = intent.getAction();
        this.encodeContentsFromZXingIntent(intent);
    }

    String getContents() {
        return this.contents;
    }

    String getDisplayContents() {
        return this.displayContents;
    }

    String getTitle() {
        return this.title;
    }

    boolean isUseVCard() {
        return this.useVCard;
    }

    private boolean encodeContentsFromZXingIntent(Intent intent) {
        String formatString = intent.getStringExtra("ENCODE_FORMAT");
        this.format = null;
        if (formatString != null) {
            try {
                this.format = BarcodeFormat.valueOf(formatString);
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        if (this.format == null || this.format == BarcodeFormat.QR_CODE) {
            String type = intent.getStringExtra("ENCODE_TYPE");
            if (type == null || type.length() == 0) {
                return false;
            }
            this.format = BarcodeFormat.QR_CODE;
            this.encodeQRCodeContents(intent, type);
        } else {
            String data = intent.getStringExtra("ENCODE_DATA");
            if (data != null && data.length() > 0) {
                this.contents = data;
                this.displayContents = data;
                this.title = this.activity.getString(fakeR.getId("string", "contents_text"));
            }
        }
        return this.contents != null && this.contents.length() > 0;
    }

    private void encodeContentsFromShareIntent(Intent intent) throws WriterException {
        if (intent.hasExtra("android.intent.extra.STREAM")) {
            this.encodeFromStreamExtra(intent);
        } else {
            this.encodeFromTextExtras(intent);
        }
    }

    private void encodeFromTextExtras(Intent intent) throws WriterException {
        String theContents = ContactEncoder.trim(intent.getStringExtra("android.intent.extra.TEXT"));
        if (theContents == null && (theContents = ContactEncoder.trim(intent.getStringExtra("android.intent.extra.HTML_TEXT"))) == null && (theContents = ContactEncoder.trim(intent.getStringExtra("android.intent.extra.SUBJECT"))) == null) {
            String[] emails = intent.getStringArrayExtra("android.intent.extra.EMAIL");
            theContents = emails != null ? ContactEncoder.trim(emails[0]) : "?";
        }
        if (theContents == null || theContents.length() == 0) {
            throw new WriterException("Empty EXTRA_TEXT");
        }
        this.contents = theContents;
        this.format = BarcodeFormat.QR_CODE;
        this.displayContents = intent.hasExtra("android.intent.extra.SUBJECT") ? intent.getStringExtra("android.intent.extra.SUBJECT") : (intent.hasExtra("android.intent.extra.TITLE") ? intent.getStringExtra("android.intent.extra.TITLE") : this.contents);
        this.title = this.activity.getString(fakeR.getId("string", "contents_text"));
    }

    private void encodeFromStreamExtra(Intent intent) throws WriterException {
        String vcardString;
        byte[] vcard;
        this.format = BarcodeFormat.QR_CODE;
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            throw new WriterException("No extras");
        }
        Uri uri = (Uri)bundle.getParcelable("android.intent.extra.STREAM");
        if (uri == null) {
            throw new WriterException("No EXTRA_STREAM");
        }
        try {
            int bytesRead;
            InputStream stream = this.activity.getContentResolver().openInputStream(uri);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            while ((bytesRead = stream.read(buffer)) > 0) {
                baos.write(buffer, 0, bytesRead);
            }
            vcard = baos.toByteArray();
            vcardString = new String(vcard, 0, vcard.length, "UTF-8");
        }
        catch (IOException ioe) {
            throw new WriterException(ioe);
        }
        Log.d((String)TAG, (String)"Encoding share intent content:");
        Log.d((String)TAG, (String)vcardString);
        Result result = new Result(vcardString, vcard, null, BarcodeFormat.QR_CODE);
        ParsedResult parsedResult = ResultParser.parseResult(result);
        if (!(parsedResult instanceof AddressBookParsedResult)) {
            throw new WriterException("Result was not an address");
        }
        this.encodeQRCodeContents((AddressBookParsedResult)parsedResult);
        if (this.contents == null || this.contents.length() == 0) {
            throw new WriterException("No content to encode");
        }
    }

    private void encodeQRCodeContents(Intent intent, String type) {
        Bundle bundle;
        if (type.equals("TEXT_TYPE")) {
            String data = intent.getStringExtra("ENCODE_DATA");
            if (data != null && data.length() > 0) {
                this.contents = data;
                this.displayContents = data;
                this.title = this.activity.getString(fakeR.getId("string", "contents_text"));
            }
        } else if (type.equals("EMAIL_TYPE")) {
            String data = ContactEncoder.trim(intent.getStringExtra("ENCODE_DATA"));
            if (data != null) {
                this.contents = "mailto:" + data;
                this.displayContents = data;
                this.title = this.activity.getString(fakeR.getId("string", "contents_email"));
            }
        } else if (type.equals("PHONE_TYPE")) {
            String data = ContactEncoder.trim(intent.getStringExtra("ENCODE_DATA"));
            if (data != null) {
                this.contents = "tel:" + data;
                this.displayContents = PhoneNumberUtils.formatNumber((String)data);
                this.title = this.activity.getString(fakeR.getId("string", "contents_phone"));
            }
        } else if (type.equals("SMS_TYPE")) {
            String data = ContactEncoder.trim(intent.getStringExtra("ENCODE_DATA"));
            if (data != null) {
                this.contents = "sms:" + data;
                this.displayContents = PhoneNumberUtils.formatNumber((String)data);
                this.title = this.activity.getString(fakeR.getId("string", "contents_sms"));
            }
        } else if (type.equals("CONTACT_TYPE")) {
            Bundle bundle2 = intent.getBundleExtra("ENCODE_DATA");
            if (bundle2 != null) {
                String name = bundle2.getString("name");
                String organization = bundle2.getString("company");
                String address = bundle2.getString("postal");
                ArrayList<String> phones = new ArrayList<String>(Contents.PHONE_KEYS.length);
                for (int x = 0; x < Contents.PHONE_KEYS.length; ++x) {
                    phones.add(bundle2.getString(Contents.PHONE_KEYS[x]));
                }
                ArrayList<String> emails = new ArrayList<String>(Contents.EMAIL_KEYS.length);
                for (int x = 0; x < Contents.EMAIL_KEYS.length; ++x) {
                    emails.add(bundle2.getString(Contents.EMAIL_KEYS[x]));
                }
                String url = bundle2.getString("URL_KEY");
                String note = bundle2.getString("NOTE_KEY");
                ContactEncoder mecardEncoder = this.useVCard ? new VCardContactEncoder() : new MECARDContactEncoder();
                String[] encoded = mecardEncoder.encode(Collections.singleton(name), organization, Collections.singleton(address), phones, emails, url, note);
                if (encoded[1].length() > 0) {
                    this.contents = encoded[0];
                    this.displayContents = encoded[1];
                    this.title = this.activity.getString(fakeR.getId("string", "contents_contact"));
                }
            }
        } else if (type.equals("LOCATION_TYPE") && (bundle = intent.getBundleExtra("ENCODE_DATA")) != null) {
            float latitude = bundle.getFloat("LAT", Float.MAX_VALUE);
            float longitude = bundle.getFloat("LONG", Float.MAX_VALUE);
            if (latitude != Float.MAX_VALUE && longitude != Float.MAX_VALUE) {
                this.contents = "geo:" + latitude + ',' + longitude;
                this.displayContents = latitude + "," + longitude;
                this.title = this.activity.getString(fakeR.getId("string", "contents_location"));
            }
        }
    }

    private void encodeQRCodeContents(AddressBookParsedResult contact) {
        ContactEncoder encoder = this.useVCard ? new VCardContactEncoder() : new MECARDContactEncoder();
        String[] encoded = encoder.encode(QRCodeEncoder.toIterable(contact.getNames()), contact.getOrg(), QRCodeEncoder.toIterable(contact.getAddresses()), QRCodeEncoder.toIterable(contact.getPhoneNumbers()), QRCodeEncoder.toIterable(contact.getEmails()), contact.getURL(), null);
        if (encoded[1].length() > 0) {
            this.contents = encoded[0];
            this.displayContents = encoded[1];
            this.title = this.activity.getString(fakeR.getId("string", "contents_contact"));
        }
    }

    private static Iterable<String> toIterable(String[] values) {
        return values == null ? null : Arrays.asList(values);
    }

    Bitmap encodeAsBitmap() throws WriterException {
        BitMatrix result;
        String contentsToEncode = this.contents;
        if (contentsToEncode == null) {
            return null;
        }
        EnumMap<EncodeHintType, String> hints = null;
        String encoding = QRCodeEncoder.guessAppropriateEncoding(contentsToEncode);
        if (encoding != null) {
            hints = new EnumMap<EncodeHintType, String>(EncodeHintType.class);
            hints.put(EncodeHintType.CHARACTER_SET, encoding);
        }
        MultiFormatWriter writer = new MultiFormatWriter();
        try {
            result = writer.encode(contentsToEncode, this.format, this.dimension, this.dimension, hints);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        int width = result.getWidth();
        int height = result.getHeight();
        int[] pixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                pixels[offset + x] = result.get(x, y) ? -16777216 : -1;
            }
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return bitmap;
    }

    private static String guessAppropriateEncoding(CharSequence contents) {
        for (int i = 0; i < contents.length(); ++i) {
            if (contents.charAt(i) <= '\u00ff') continue;
            return "UTF-8";
        }
        return null;
    }
}

