/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.encode;

import android.telephony.PhoneNumberUtils;
import com.google.zxing.client.android.encode.ContactEncoder;
import com.google.zxing.client.android.encode.Formatter;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MECARDContactEncoder
extends ContactEncoder {
    private static final Pattern RESERVED_MECARD_CHARS = Pattern.compile("([\\\\:;])");
    private static final Pattern NEWLINE = Pattern.compile("\\n");
    private static final Pattern COMMA = Pattern.compile(",");
    private static final Formatter MECARD_FIELD_FORMATTER = new Formatter(){

        public String format(String source) {
            return NEWLINE.matcher(RESERVED_MECARD_CHARS.matcher(source).replaceAll("\\\\$1")).replaceAll("");
        }
    };
    private static final char TERMINATOR = ';';

    MECARDContactEncoder() {
    }

    @Override
    public String[] encode(Iterable<String> names, String organization, Iterable<String> addresses, Iterable<String> phones, Iterable<String> emails, String url, String note) {
        StringBuilder newContents = new StringBuilder(100);
        StringBuilder newDisplayContents = new StringBuilder(100);
        newContents.append("MECARD:");
        MECARDContactEncoder.appendUpToUnique(newContents, newDisplayContents, "N", names, 1, new Formatter(){

            public String format(String source) {
                return source == null ? null : COMMA.matcher(source).replaceAll("");
            }
        });
        MECARDContactEncoder.append(newContents, newDisplayContents, "ORG", organization);
        MECARDContactEncoder.appendUpToUnique(newContents, newDisplayContents, "ADR", addresses, 1, null);
        MECARDContactEncoder.appendUpToUnique(newContents, newDisplayContents, "TEL", phones, Integer.MAX_VALUE, new Formatter(){

            public String format(String source) {
                return PhoneNumberUtils.formatNumber((String)source);
            }
        });
        MECARDContactEncoder.appendUpToUnique(newContents, newDisplayContents, "EMAIL", emails, Integer.MAX_VALUE, null);
        MECARDContactEncoder.append(newContents, newDisplayContents, "URL", url);
        MECARDContactEncoder.append(newContents, newDisplayContents, "NOTE", note);
        newContents.append(';');
        return new String[]{newContents.toString(), newDisplayContents.toString()};
    }

    private static void append(StringBuilder newContents, StringBuilder newDisplayContents, String prefix, String value) {
        MECARDContactEncoder.doAppend(newContents, newDisplayContents, prefix, value, MECARD_FIELD_FORMATTER, ';');
    }

    private static void appendUpToUnique(StringBuilder newContents, StringBuilder newDisplayContents, String prefix, Iterable<String> values, int max, Formatter formatter) {
        MECARDContactEncoder.doAppendUpToUnique(newContents, newDisplayContents, prefix, values, max, formatter, MECARD_FIELD_FORMATTER, ';');
    }
}

