/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.common;

import android.os.Build;
import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlatformSupportManager<T> {
    private static final String TAG = PlatformSupportManager.class.getSimpleName();
    private final Class<T> managedInterface;
    private final T defaultImplementation;
    private final SortedMap<Integer, String> implementations;

    protected PlatformSupportManager(Class<T> managedInterface, T defaultImplementation) {
        if (!managedInterface.isInterface()) {
            throw new IllegalArgumentException();
        }
        if (!managedInterface.isInstance(defaultImplementation)) {
            throw new IllegalArgumentException();
        }
        this.managedInterface = managedInterface;
        this.defaultImplementation = defaultImplementation;
        this.implementations = new TreeMap(Collections.reverseOrder());
    }

    protected void addImplementationClass(int minVersion, String className) {
        this.implementations.put(minVersion, className);
    }

    public T build() {
        for (Integer minVersion : this.implementations.keySet()) {
            if (Build.VERSION.SDK_INT < minVersion) continue;
            String className = (String)this.implementations.get(minVersion);
            try {
                Class<T> clazz = Class.forName(className).asSubclass(this.managedInterface);
                Log.i((String)TAG, (String)("Using implementation " + clazz + " of " + this.managedInterface + " for SDK " + minVersion));
                return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException cnfe) {
                Log.w((String)TAG, (Throwable)cnfe);
            }
            catch (IllegalAccessException iae) {
                Log.w((String)TAG, (Throwable)iae);
            }
            catch (InstantiationException ie) {
                Log.w((String)TAG, (Throwable)ie);
            }
            catch (NoSuchMethodException nsme) {
                Log.w((String)TAG, (Throwable)nsme);
            }
            catch (InvocationTargetException ite) {
                Log.w((String)TAG, (Throwable)ite);
            }
        }
        Log.i((String)TAG, (String)("Using default implementation " + this.defaultImplementation.getClass() + " of " + this.managedInterface));
        return this.defaultImplementation;
    }
}

