/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.camera.exposure;

import android.annotation.TargetApi;
import android.hardware.Camera;
import android.util.Log;
import com.google.zxing.client.android.camera.exposure.ExposureInterface;

@TargetApi(value=8)
public final class FroyoExposureInterface
implements ExposureInterface {
    private static final String TAG = FroyoExposureInterface.class.getSimpleName();
    private static final float MAX_EXPOSURE_COMPENSATION = 1.5f;
    private static final float MIN_EXPOSURE_COMPENSATION = 0.0f;

    public void setExposure(Camera.Parameters parameters, boolean lightOn) {
        int minExposure = parameters.getMinExposureCompensation();
        int maxExposure = parameters.getMaxExposureCompensation();
        if (minExposure != 0 || maxExposure != 0) {
            float step = parameters.getExposureCompensationStep();
            int desiredCompensation = lightOn ? Math.max((int)(0.0f / step), minExposure) : Math.min((int)(1.5f / step), maxExposure);
            Log.i((String)TAG, (String)("Setting exposure compensation to " + desiredCompensation + " / " + step * (float)desiredCompensation));
            parameters.setExposureCompensation(desiredCompensation);
        } else {
            Log.i((String)TAG, (String)"Camera does not support exposure compensation");
        }
    }
}

