/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.camera;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Point;
import android.hardware.Camera;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CameraConfigurationManager {
    private static final String TAG = "CameraConfiguration";
    private static final int MIN_PREVIEW_PIXELS = 150400;
    private static final int MAX_PREVIEW_PIXELS = 921600;
    private final Context context;
    private Point screenResolution;
    private Point cameraResolution;

    CameraConfigurationManager(Context context) {
        this.context = context;
    }

    void initFromCameraParameters(Camera camera) {
        int height;
        Camera.Parameters parameters = camera.getParameters();
        WindowManager manager = (WindowManager)this.context.getSystemService("window");
        Display display = manager.getDefaultDisplay();
        int width = display.getWidth();
        if (width < (height = display.getHeight())) {
            Log.i((String)TAG, (String)"Display reports portrait orientation; assuming this is incorrect");
            int temp = width;
            width = height;
            height = temp;
        }
        this.screenResolution = new Point(width, height);
        Log.i((String)TAG, (String)("Screen resolution: " + this.screenResolution));
        this.cameraResolution = this.findBestPreviewSizeValue(parameters, this.screenResolution);
        Log.i((String)TAG, (String)("Camera resolution: " + this.cameraResolution));
    }

    void setDesiredCameraParameters(Camera camera, boolean safeMode) {
        Camera.Parameters parameters = camera.getParameters();
        if (parameters == null) {
            Log.w((String)TAG, (String)"Device error: no camera parameters are available. Proceeding without configuration.");
            return;
        }
        Log.i((String)TAG, (String)("Initial camera parameters: " + parameters.flatten()));
        if (safeMode) {
            Log.w((String)TAG, (String)"In camera config safe mode -- most settings will not be honored");
        }
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
        this.initializeTorch(parameters, prefs, safeMode);
        String focusMode = null;
        if (prefs.getBoolean("preferences_auto_focus", true)) {
            focusMode = safeMode || prefs.getBoolean("preferences_disable_continuous_focus", false) ? CameraConfigurationManager.findSettableValue(parameters.getSupportedFocusModes(), "auto") : CameraConfigurationManager.findSettableValue(parameters.getSupportedFocusModes(), "continuous-picture", "continuous-video", "auto");
        }
        if (!safeMode && focusMode == null) {
            focusMode = CameraConfigurationManager.findSettableValue(parameters.getSupportedFocusModes(), "macro", "edof");
        }
        if (focusMode != null) {
            parameters.setFocusMode(focusMode);
        }
        parameters.setPreviewSize(this.cameraResolution.x, this.cameraResolution.y);
        camera.setParameters(parameters);
    }

    Point getCameraResolution() {
        return this.cameraResolution;
    }

    Point getScreenResolution() {
        return this.screenResolution;
    }

    void setTorch(Camera camera, boolean newSetting) {
        Camera.Parameters parameters = camera.getParameters();
        this.doSetTorch(parameters, newSetting, false);
        camera.setParameters(parameters);
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
        boolean currentSetting = prefs.getBoolean("preferences_front_light", false);
        if (currentSetting != newSetting) {
            SharedPreferences.Editor editor = prefs.edit();
            editor.putBoolean("preferences_front_light", newSetting);
            editor.commit();
        }
    }

    private void initializeTorch(Camera.Parameters parameters, SharedPreferences prefs, boolean safeMode) {
        boolean currentSetting = prefs.getBoolean("preferences_front_light", false);
        this.doSetTorch(parameters, currentSetting, safeMode);
    }

    private void doSetTorch(Camera.Parameters parameters, boolean newSetting, boolean safeMode) {
        String flashMode = newSetting ? CameraConfigurationManager.findSettableValue(parameters.getSupportedFlashModes(), "torch", "on") : CameraConfigurationManager.findSettableValue(parameters.getSupportedFlashModes(), "off");
        if (flashMode != null) {
            parameters.setFlashMode(flashMode);
        }
    }

    private Point findBestPreviewSizeValue(Camera.Parameters parameters, Point screenResolution) {
        List rawSupportedSizes = parameters.getSupportedPreviewSizes();
        if (rawSupportedSizes == null) {
            Log.w((String)TAG, (String)"Device returned no supported preview sizes; using default");
            Camera.Size defaultSize = parameters.getPreviewSize();
            return new Point(defaultSize.width, defaultSize.height);
        }
        ArrayList supportedPreviewSizes = new ArrayList(rawSupportedSizes);
        Collections.sort(supportedPreviewSizes, new Comparator<Camera.Size>(){

            @Override
            public int compare(Camera.Size a, Camera.Size b) {
                int bPixels = b.height * b.width;
                int aPixels = a.height * a.width;
                if (bPixels < aPixels) {
                    return -1;
                }
                if (bPixels > aPixels) {
                    return 1;
                }
                return 0;
            }
        });
        if (Log.isLoggable((String)TAG, (int)4)) {
            StringBuilder previewSizesString = new StringBuilder();
            for (Camera.Size supportedPreviewSize : supportedPreviewSizes) {
                previewSizesString.append(supportedPreviewSize.width).append('x').append(supportedPreviewSize.height).append(' ');
            }
            Log.i((String)TAG, (String)("Supported preview sizes: " + previewSizesString));
        }
        Point bestSize = null;
        float screenAspectRatio = (float)screenResolution.x / (float)screenResolution.y;
        float diff = Float.POSITIVE_INFINITY;
        for (Camera.Size supportedPreviewSize : supportedPreviewSizes) {
            int maybeFlippedHeight;
            int realWidth = supportedPreviewSize.width;
            int realHeight = supportedPreviewSize.height;
            int pixels = realWidth * realHeight;
            if (pixels < 150400 || pixels > 921600) continue;
            boolean isCandidatePortrait = realWidth < realHeight;
            int maybeFlippedWidth = isCandidatePortrait ? realHeight : realWidth;
            int n = maybeFlippedHeight = isCandidatePortrait ? realWidth : realHeight;
            if (maybeFlippedWidth == screenResolution.x && maybeFlippedHeight == screenResolution.y) {
                Point exactPoint = new Point(realWidth, realHeight);
                Log.i((String)TAG, (String)("Found preview size exactly matching screen size: " + exactPoint));
                return exactPoint;
            }
            float aspectRatio = (float)maybeFlippedWidth / (float)maybeFlippedHeight;
            float newDiff = Math.abs(aspectRatio - screenAspectRatio);
            if (!(newDiff < diff)) continue;
            bestSize = new Point(realWidth, realHeight);
            diff = newDiff;
        }
        if (bestSize == null) {
            Camera.Size defaultSize = parameters.getPreviewSize();
            bestSize = new Point(defaultSize.width, defaultSize.height);
            Log.i((String)TAG, (String)("No suitable preview sizes, using default: " + bestSize));
        }
        Log.i((String)TAG, (String)("Found best approximate preview size: " + bestSize));
        return bestSize;
    }

    private static String findSettableValue(Collection<String> supportedValues, String ... desiredValues) {
        Log.i((String)TAG, (String)("Supported values: " + supportedValues));
        String result = null;
        if (supportedValues != null) {
            for (String desiredValue : desiredValues) {
                if (!supportedValues.contains(desiredValue)) continue;
                result = desiredValue;
                break;
            }
        }
        Log.i((String)TAG, (String)("Settable value: " + result));
        return result;
    }
}

