/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.camera;

import android.content.Context;
import android.content.SharedPreferences;
import android.hardware.Camera;
import android.os.AsyncTask;
import android.preference.PreferenceManager;
import android.util.Log;
import com.google.zxing.client.android.common.executor.AsyncTaskExecInterface;
import com.google.zxing.client.android.common.executor.AsyncTaskExecManager;
import java.util.ArrayList;
import java.util.Collection;

final class AutoFocusManager
implements Camera.AutoFocusCallback {
    private static final String TAG = AutoFocusManager.class.getSimpleName();
    private static final long AUTO_FOCUS_INTERVAL_MS = 2000L;
    private static final Collection<String> FOCUS_MODES_CALLING_AF = new ArrayList<String>(2);
    private boolean active;
    private final boolean useAutoFocus;
    private final Camera camera;
    private AutoFocusTask outstandingTask;
    private final AsyncTaskExecInterface taskExec;

    AutoFocusManager(Context context, Camera camera) {
        this.camera = camera;
        this.taskExec = (AsyncTaskExecInterface)new AsyncTaskExecManager().build();
        SharedPreferences sharedPrefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
        String currentFocusMode = camera.getParameters().getFocusMode();
        this.useAutoFocus = sharedPrefs.getBoolean("preferences_auto_focus", true) && FOCUS_MODES_CALLING_AF.contains(currentFocusMode);
        Log.i((String)TAG, (String)("Current focus mode '" + currentFocusMode + "'; use auto focus? " + this.useAutoFocus));
        this.start();
    }

    public synchronized void onAutoFocus(boolean success, Camera theCamera) {
        if (this.active) {
            this.outstandingTask = new AutoFocusTask();
            this.taskExec.execute(this.outstandingTask, new Object[0]);
        }
    }

    synchronized void start() {
        if (this.useAutoFocus) {
            this.active = true;
            try {
                this.camera.autoFocus((Camera.AutoFocusCallback)this);
            }
            catch (RuntimeException re) {
                Log.w((String)TAG, (String)"Unexpected exception while focusing", (Throwable)re);
            }
        }
    }

    synchronized void stop() {
        if (this.useAutoFocus) {
            try {
                this.camera.cancelAutoFocus();
            }
            catch (RuntimeException re) {
                Log.w((String)TAG, (String)"Unexpected exception while cancelling focusing", (Throwable)re);
            }
        }
        if (this.outstandingTask != null) {
            this.outstandingTask.cancel(true);
            this.outstandingTask = null;
        }
        this.active = false;
    }

    static {
        FOCUS_MODES_CALLING_AF.add("auto");
        FOCUS_MODES_CALLING_AF.add("macro");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AutoFocusTask
    extends AsyncTask<Object, Object, Object> {
        private AutoFocusTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doInBackground(Object ... voids) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            AutoFocusManager autoFocusManager = AutoFocusManager.this;
            synchronized (autoFocusManager) {
                if (AutoFocusManager.this.active) {
                    AutoFocusManager.this.start();
                }
            }
            return null;
        }
    }
}

