/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.book;

import android.content.Context;
import android.text.SpannableString;
import android.text.style.StyleSpan;
import android.util.AttributeSet;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.zxing.FakeR;
import com.google.zxing.client.android.book.SearchBookContentsResult;
import java.util.Locale;

public final class SearchBookContentsListItem
extends LinearLayout {
    private TextView pageNumberView;
    private TextView snippetView;
    private static FakeR fakeR;

    SearchBookContentsListItem(Context context) {
        super(context);
        fakeR = new FakeR(context);
    }

    public SearchBookContentsListItem(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.pageNumberView = (TextView)this.findViewById(fakeR.getId("id", "page_number_view"));
        this.snippetView = (TextView)this.findViewById(fakeR.getId("id", "snippet_view"));
    }

    public void set(SearchBookContentsResult result) {
        this.pageNumberView.setText((CharSequence)result.getPageNumber());
        String snippet = result.getSnippet();
        if (snippet.length() > 0) {
            if (result.getValidSnippet()) {
                int pos;
                String lowerQuery = SearchBookContentsResult.getQuery().toLowerCase(Locale.getDefault());
                String lowerSnippet = snippet.toLowerCase(Locale.getDefault());
                SpannableString styledSnippet = new SpannableString((CharSequence)snippet);
                StyleSpan boldSpan = new StyleSpan(1);
                int queryLength = lowerQuery.length();
                int offset = 0;
                while ((pos = lowerSnippet.indexOf(lowerQuery, offset)) >= 0) {
                    styledSnippet.setSpan((Object)boldSpan, pos, pos + queryLength, 0);
                    offset = pos + queryLength;
                }
                this.snippetView.setText((CharSequence)styledSnippet);
            } else {
                this.snippetView.setText((CharSequence)snippet);
            }
        } else {
            this.snippetView.setText((CharSequence)"");
        }
    }
}

