/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.book;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.google.zxing.FakeR;
import com.google.zxing.client.android.HttpHelper;
import com.google.zxing.client.android.LocaleManager;
import com.google.zxing.client.android.book.BrowseBookListener;
import com.google.zxing.client.android.book.SearchBookContentsAdapter;
import com.google.zxing.client.android.book.SearchBookContentsResult;
import com.google.zxing.client.android.common.executor.AsyncTaskExecInterface;
import com.google.zxing.client.android.common.executor.AsyncTaskExecManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class SearchBookContentsActivity
extends Activity {
    private static final String TAG = SearchBookContentsActivity.class.getSimpleName();
    private static final Pattern TAG_PATTERN = Pattern.compile("\\<.*?\\>");
    private static final Pattern LT_ENTITY_PATTERN = Pattern.compile("&lt;");
    private static final Pattern GT_ENTITY_PATTERN = Pattern.compile("&gt;");
    private static final Pattern QUOTE_ENTITY_PATTERN = Pattern.compile("&#39;");
    private static final Pattern QUOT_ENTITY_PATTERN = Pattern.compile("&quot;");
    private String isbn;
    private EditText queryTextView;
    private Button queryButton;
    private ListView resultListView;
    private TextView headerView;
    private NetworkTask networkTask;
    private final AsyncTaskExecInterface taskExec;
    private final View.OnClickListener buttonListener = new View.OnClickListener(){

        public void onClick(View view) {
            SearchBookContentsActivity.this.launchSearch();
        }
    };
    private final View.OnKeyListener keyListener = new View.OnKeyListener(){

        public boolean onKey(View view, int keyCode, KeyEvent event) {
            if (keyCode == 66 && event.getAction() == 0) {
                SearchBookContentsActivity.this.launchSearch();
                return true;
            }
            return false;
        }
    };
    private static FakeR fakeR;

    public SearchBookContentsActivity() {
        this.taskExec = (AsyncTaskExecInterface)new AsyncTaskExecManager().build();
    }

    String getISBN() {
        return this.isbn;
    }

    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        fakeR = new FakeR(this);
        CookieSyncManager.createInstance((Context)this);
        CookieManager.getInstance().removeExpiredCookie();
        Intent intent = this.getIntent();
        if (intent == null || !intent.getAction().equals("com.google.zxing.client.android.SEARCH_BOOK_CONTENTS")) {
            this.finish();
            return;
        }
        this.isbn = intent.getStringExtra("ISBN");
        if (LocaleManager.isBookSearchUrl(this.isbn)) {
            this.setTitle(this.getString(fakeR.getId("string", "sbc_name")));
        } else {
            this.setTitle(this.getString(fakeR.getId("string", "sbc_name")) + ": ISBN " + this.isbn);
        }
        this.setContentView(fakeR.getId("layout", "search_book_contents"));
        this.queryTextView = (EditText)this.findViewById(fakeR.getId("id", "query_text_view"));
        String initialQuery = intent.getStringExtra("QUERY");
        if (initialQuery != null && initialQuery.length() > 0) {
            this.queryTextView.setText((CharSequence)initialQuery);
        }
        this.queryTextView.setOnKeyListener(this.keyListener);
        this.queryButton = (Button)this.findViewById(fakeR.getId("id", "query_button"));
        this.queryButton.setOnClickListener(this.buttonListener);
        this.resultListView = (ListView)this.findViewById(fakeR.getId("id", "result_list_view"));
        LayoutInflater factory = LayoutInflater.from((Context)this);
        this.headerView = (TextView)factory.inflate(fakeR.getId("layout", "search_book_contents_header"), (ViewGroup)this.resultListView, false);
        this.resultListView.addHeaderView((View)this.headerView);
    }

    protected void onResume() {
        super.onResume();
        this.queryTextView.selectAll();
    }

    protected void onPause() {
        NetworkTask oldTask = this.networkTask;
        if (oldTask != null) {
            oldTask.cancel(true);
            this.networkTask = null;
        }
        super.onPause();
    }

    private void launchSearch() {
        String query = this.queryTextView.getText().toString();
        if (query != null && query.length() > 0) {
            NetworkTask oldTask = this.networkTask;
            if (oldTask != null) {
                oldTask.cancel(true);
            }
            this.networkTask = new NetworkTask();
            this.taskExec.execute(this.networkTask, query, this.isbn);
            this.headerView.setText(fakeR.getId("string", "msg_sbc_searching_book"));
            this.resultListView.setAdapter(null);
            this.queryTextView.setEnabled(false);
            this.queryButton.setEnabled(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class NetworkTask
    extends AsyncTask<String, Object, JSONObject> {
        private NetworkTask() {
        }

        protected JSONObject doInBackground(String ... args) {
            try {
                String uri;
                String theQuery = args[0];
                String theIsbn = args[1];
                if (LocaleManager.isBookSearchUrl(theIsbn)) {
                    int equals = theIsbn.indexOf(61);
                    String volumeId = theIsbn.substring(equals + 1);
                    uri = "http://www.google.com/books?id=" + volumeId + "&jscmd=SearchWithinVolume2&q=" + theQuery;
                } else {
                    uri = "http://www.google.com/books?vid=isbn" + theIsbn + "&jscmd=SearchWithinVolume2&q=" + theQuery;
                }
                CharSequence content = HttpHelper.downloadViaHttp(uri, HttpHelper.ContentType.JSON);
                return new JSONObject(content.toString());
            }
            catch (IOException ioe) {
                Log.w((String)TAG, (String)"Error accessing book search", (Throwable)ioe);
                return null;
            }
            catch (JSONException je) {
                Log.w((String)TAG, (String)"Error accessing book search", (Throwable)je);
                return null;
            }
        }

        protected void onPostExecute(JSONObject result) {
            if (result == null) {
                SearchBookContentsActivity.this.headerView.setText(fakeR.getId("string", "msg_sbc_failed"));
            } else {
                this.handleSearchResults(result);
            }
            SearchBookContentsActivity.this.queryTextView.setEnabled(true);
            SearchBookContentsActivity.this.queryTextView.selectAll();
            SearchBookContentsActivity.this.queryButton.setEnabled(true);
        }

        private void handleSearchResults(JSONObject json) {
            try {
                int count = json.getInt("number_of_results");
                SearchBookContentsActivity.this.headerView.setText((CharSequence)(SearchBookContentsActivity.this.getString(fakeR.getId("string", "msg_sbc_results")) + " : " + count));
                if (count > 0) {
                    JSONArray results = json.getJSONArray("search_results");
                    SearchBookContentsResult.setQuery(SearchBookContentsActivity.this.queryTextView.getText().toString());
                    ArrayList<SearchBookContentsResult> items = new ArrayList<SearchBookContentsResult>(count);
                    for (int x = 0; x < count; ++x) {
                        items.add(this.parseResult(results.getJSONObject(x)));
                    }
                    SearchBookContentsActivity.this.resultListView.setOnItemClickListener((AdapterView.OnItemClickListener)new BrowseBookListener(SearchBookContentsActivity.this, items));
                    SearchBookContentsActivity.this.resultListView.setAdapter((ListAdapter)new SearchBookContentsAdapter((Context)SearchBookContentsActivity.this, items));
                } else {
                    String searchable = json.optString("searchable");
                    if ("false".equals(searchable)) {
                        SearchBookContentsActivity.this.headerView.setText(fakeR.getId("string", "msg_sbc_book_not_searchable"));
                    }
                    SearchBookContentsActivity.this.resultListView.setAdapter(null);
                }
            }
            catch (JSONException e) {
                Log.w((String)TAG, (String)"Bad JSON from book search", (Throwable)e);
                SearchBookContentsActivity.this.resultListView.setAdapter(null);
                SearchBookContentsActivity.this.headerView.setText(fakeR.getId("string", "msg_sbc_failed"));
            }
        }

        private SearchBookContentsResult parseResult(JSONObject json) {
            try {
                String pageId = json.getString("page_id");
                String pageNumber = json.getString("page_number");
                pageNumber = pageNumber.length() > 0 ? SearchBookContentsActivity.this.getString(fakeR.getId("string", "msg_sbc_page")) + ' ' + pageNumber : SearchBookContentsActivity.this.getString(fakeR.getId("string", "msg_sbc_unknown_page"));
                String snippet = json.optString("snippet_text");
                boolean valid = true;
                if (snippet.length() > 0) {
                    snippet = TAG_PATTERN.matcher(snippet).replaceAll("");
                    snippet = LT_ENTITY_PATTERN.matcher(snippet).replaceAll("<");
                    snippet = GT_ENTITY_PATTERN.matcher(snippet).replaceAll(">");
                    snippet = QUOTE_ENTITY_PATTERN.matcher(snippet).replaceAll("'");
                    snippet = QUOT_ENTITY_PATTERN.matcher(snippet).replaceAll("\"");
                } else {
                    snippet = '(' + SearchBookContentsActivity.this.getString(fakeR.getId("string", "msg_sbc_snippet_unavailable")) + ')';
                    valid = false;
                }
                return new SearchBookContentsResult(pageId, pageNumber, snippet, valid);
            }
            catch (JSONException e) {
                return new SearchBookContentsResult(SearchBookContentsActivity.this.getString(fakeR.getId("string", "msg_sbc_no_page_returned")), "", "", false);
            }
        }
    }
}

