/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.util.Log;
import com.google.zxing.client.android.common.executor.AsyncTaskExecInterface;
import com.google.zxing.client.android.common.executor.AsyncTaskExecManager;

final class InactivityTimer {
    private static final String TAG = InactivityTimer.class.getSimpleName();
    private static final long INACTIVITY_DELAY_MS = 300000L;
    private final Activity activity;
    private final AsyncTaskExecInterface taskExec;
    private final BroadcastReceiver powerStatusReceiver;
    private InactivityAsyncTask inactivityTask;

    InactivityTimer(Activity activity) {
        this.activity = activity;
        this.taskExec = (AsyncTaskExecInterface)new AsyncTaskExecManager().build();
        this.powerStatusReceiver = new PowerStatusReceiver();
        this.onActivity();
    }

    synchronized void onActivity() {
        this.cancel();
        this.inactivityTask = new InactivityAsyncTask();
        this.taskExec.execute(this.inactivityTask, new Object[0]);
    }

    public void onPause() {
        this.cancel();
        this.activity.unregisterReceiver(this.powerStatusReceiver);
    }

    public void onResume() {
        this.activity.registerReceiver(this.powerStatusReceiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        this.onActivity();
    }

    private synchronized void cancel() {
        InactivityAsyncTask task = this.inactivityTask;
        if (task != null) {
            task.cancel(true);
            this.inactivityTask = null;
        }
    }

    void shutdown() {
        this.cancel();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InactivityAsyncTask
    extends AsyncTask<Object, Object, Object> {
        private InactivityAsyncTask() {
        }

        protected Object doInBackground(Object ... objects) {
            try {
                Thread.sleep(300000L);
                Log.i((String)TAG, (String)"Finishing activity due to inactivity");
                InactivityTimer.this.activity.finish();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }
    }

    private final class PowerStatusReceiver
    extends BroadcastReceiver {
        private PowerStatusReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.BATTERY_CHANGED".equals(intent.getAction())) {
                boolean onBatteryNow;
                boolean bl = onBatteryNow = intent.getIntExtra("plugged", -1) <= 0;
                if (onBatteryNow) {
                    InactivityTimer.this.onActivity();
                } else {
                    InactivityTimer.this.cancel();
                }
            }
        }
    }
}

