/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android;

import android.util.Log;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public final class HttpHelper {
    private static final String TAG = HttpHelper.class.getSimpleName();
    private static final Collection<String> REDIRECTOR_DOMAINS = new HashSet<String>(Arrays.asList("amzn.to", "bit.ly", "bitly.com", "fb.me", "goo.gl", "is.gd", "j.mp", "lnkd.in", "ow.ly", "R.BEETAGG.COM", "r.beetagg.com", "SCN.BY", "su.pr", "t.co", "tinyurl.com", "tr.im"));

    private HttpHelper() {
    }

    public static CharSequence downloadViaHttp(String uri, ContentType type) throws IOException {
        return HttpHelper.downloadViaHttp(uri, type, Integer.MAX_VALUE);
    }

    public static CharSequence downloadViaHttp(String uri, ContentType type, int maxChars) throws IOException {
        String contentTypes;
        switch (type) {
            case HTML: {
                contentTypes = "application/xhtml+xml,text/html,text/*,*/*";
                break;
            }
            case JSON: {
                contentTypes = "application/json,text/*,*/*";
                break;
            }
            default: {
                contentTypes = "text/*,*/*";
            }
        }
        return HttpHelper.downloadViaHttp(uri, contentTypes, maxChars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CharSequence downloadViaHttp(String uri, String contentTypes, int maxChars) throws IOException {
        Log.i((String)TAG, (String)("Downloading " + uri));
        URL url = new URL(uri);
        URLConnection conn = url.openConnection();
        if (!(conn instanceof HttpURLConnection)) {
            throw new IOException();
        }
        HttpURLConnection connection = (HttpURLConnection)conn;
        connection.setRequestProperty("Accept", contentTypes);
        connection.setRequestProperty("Accept-Charset", "utf-8,*");
        connection.setRequestProperty("User-Agent", "ZXing (Android)");
        try {
            int responseCode;
            try {
                connection.connect();
            }
            catch (NullPointerException npe) {
                Log.w((String)TAG, (String)("Bad URI? " + uri));
                throw new IOException(npe);
            }
            catch (IllegalArgumentException iae) {
                Log.w((String)TAG, (String)("Bad URI? " + uri));
                throw new IOException(iae);
            }
            try {
                responseCode = connection.getResponseCode();
            }
            catch (NullPointerException npe) {
                Log.w((String)TAG, (String)("Bad URI? " + uri));
                throw new IOException(npe);
            }
            if (responseCode != 200) {
                throw new IOException("Bad HTTP response: " + responseCode);
            }
            Log.i((String)TAG, (String)("Consuming " + uri));
            CharSequence charSequence = HttpHelper.consume(connection, maxChars);
            return charSequence;
        }
        finally {
            connection.disconnect();
        }
    }

    private static String getEncoding(URLConnection connection) {
        int charsetStart;
        String contentTypeHeader = connection.getHeaderField("Content-Type");
        if (contentTypeHeader != null && (charsetStart = contentTypeHeader.indexOf("charset=")) >= 0) {
            return contentTypeHeader.substring(charsetStart + "charset=".length());
        }
        return "UTF-8";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CharSequence consume(URLConnection connection, int maxChars) throws IOException {
        String encoding = HttpHelper.getEncoding(connection);
        StringBuilder out = new StringBuilder();
        InputStreamReader in = null;
        try {
            int charsRead;
            in = new InputStreamReader(connection.getInputStream(), encoding);
            char[] buffer = new char[1024];
            while (out.length() < maxChars && (charsRead = in.read(buffer)) > 0) {
                out.append(buffer, 0, charsRead);
            }
        }
        finally {
            if (in != null) {
                try {
                    ((Reader)in).close();
                }
                catch (IOException ioe) {
                }
                catch (NullPointerException npe) {}
            }
        }
        return out;
    }

    /*
     * Exception decompiling
     */
    public static URI unredirect(URI uri) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[SWITCH], 6[CASE]], but top level block is 11[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentType {
        HTML,
        JSON,
        TEXT;

    }
}

