/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import com.google.zxing.FakeR;
import com.google.zxing.client.android.LocaleManager;

public final class HelpActivity
extends Activity {
    public static final String REQUESTED_PAGE_KEY = "requested_page_key";
    public static final String DEFAULT_PAGE = "index.html";
    public static final String WHATS_NEW_PAGE = "whatsnew.html";
    private static final String BASE_URL = "file:///android_asset/html-" + LocaleManager.getTranslatedAssetLanguage() + '/';
    private static final String WEBVIEW_STATE_PRESENT = "webview_state_present";
    private WebView webView;
    private Button backButton;
    private static FakeR fakeR;
    private final View.OnClickListener backListener = new View.OnClickListener(){

        public void onClick(View view) {
            HelpActivity.this.webView.goBack();
        }
    };
    private final View.OnClickListener doneListener = new View.OnClickListener(){

        public void onClick(View view) {
            HelpActivity.this.finish();
        }
    };

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        fakeR = new FakeR(this);
        this.setContentView(fakeR.getId("layout", "help"));
        this.webView = (WebView)this.findViewById(fakeR.getId("id", "help_contents"));
        this.webView.setWebViewClient((WebViewClient)new HelpClient());
        Intent intent = this.getIntent();
        if (icicle != null && icicle.getBoolean(WEBVIEW_STATE_PRESENT, false)) {
            this.webView.restoreState(icicle);
        } else if (intent != null) {
            String page = intent.getStringExtra(REQUESTED_PAGE_KEY);
            if (page != null && page.length() > 0) {
                this.webView.loadUrl(BASE_URL + page);
            } else {
                this.webView.loadUrl(BASE_URL + DEFAULT_PAGE);
            }
        } else {
            this.webView.loadUrl(BASE_URL + DEFAULT_PAGE);
        }
        this.backButton = (Button)this.findViewById(fakeR.getId("id", "back_button"));
        this.backButton.setOnClickListener(this.backListener);
        View doneButton = this.findViewById(fakeR.getId("id", "done_button"));
        doneButton.setOnClickListener(this.doneListener);
    }

    protected void onSaveInstanceState(Bundle state) {
        String url = this.webView.getUrl();
        if (url != null && url.length() > 0) {
            this.webView.saveState(state);
            state.putBoolean(WEBVIEW_STATE_PRESENT, true);
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.webView.canGoBack()) {
            this.webView.goBack();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    private final class HelpClient
    extends WebViewClient {
        private HelpClient() {
        }

        public void onPageFinished(WebView view, String url) {
            HelpActivity.this.setTitle(view.getTitle());
            HelpActivity.this.backButton.setEnabled(view.canGoBack());
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (url.startsWith("file")) {
                return false;
            }
            HelpActivity.this.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)url)));
            return true;
        }
    }
}

