/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.util.Log;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FakeR;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.client.android.CaptureActivity;
import com.google.zxing.common.HybridBinarizer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DecodeHandler
extends Handler {
    private static final String TAG = DecodeHandler.class.getSimpleName();
    private final CaptureActivity activity;
    private final MultiFormatReader multiFormatReader;
    private boolean running = true;
    private static FakeR fakeR;

    DecodeHandler(CaptureActivity activity, Map<DecodeHintType, Object> hints) {
        fakeR = new FakeR(activity);
        this.multiFormatReader = new MultiFormatReader();
        this.multiFormatReader.setHints(hints);
        this.activity = activity;
    }

    public void handleMessage(Message message) {
        if (!this.running) {
            return;
        }
        if (message.what == fakeR.getId("id", "decode")) {
            this.decode((byte[])message.obj, message.arg1, message.arg2);
        } else if (message.what == fakeR.getId("id", "quit")) {
            this.running = false;
            Looper.myLooper().quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decode(byte[] data, int width, int height) {
        long start = System.currentTimeMillis();
        Result rawResult = null;
        PlanarYUVLuminanceSource source = this.activity.getCameraManager().buildLuminanceSource(data, width, height);
        if (source != null) {
            BinaryBitmap bitmap = new BinaryBitmap(new HybridBinarizer(source));
            try {
                rawResult = this.multiFormatReader.decodeWithState(bitmap);
            }
            catch (ReaderException re) {
            }
            finally {
                this.multiFormatReader.reset();
            }
        }
        Handler handler = this.activity.getHandler();
        if (rawResult != null) {
            long end = System.currentTimeMillis();
            Log.d((String)TAG, (String)("Found barcode in " + (end - start) + " ms"));
            if (handler != null) {
                Message message = Message.obtain((Handler)handler, (int)fakeR.getId("id", "decode_succeeded"), (Object)rawResult);
                Bundle bundle = new Bundle();
                Bitmap grayscaleBitmap = DecodeHandler.toBitmap(source, source.renderCroppedGreyscaleBitmap());
                bundle.putParcelable("barcode_bitmap", (Parcelable)grayscaleBitmap);
                message.setData(bundle);
                message.sendToTarget();
            }
        } else if (handler != null) {
            Message message = Message.obtain((Handler)handler, (int)fakeR.getId("id", "decode_failed"));
            message.sendToTarget();
        }
    }

    private static Bitmap toBitmap(LuminanceSource source, int[] pixels) {
        int width = source.getWidth();
        int height = source.getHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return bitmap;
    }
}

