/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android;

import android.content.Intent;
import android.net.Uri;
import com.google.zxing.BarcodeFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DecodeFormatManager {
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    static final Collection<BarcodeFormat> PRODUCT_FORMATS;
    static final Collection<BarcodeFormat> ONE_D_FORMATS;
    static final Collection<BarcodeFormat> QR_CODE_FORMATS;
    static final Collection<BarcodeFormat> DATA_MATRIX_FORMATS;

    private DecodeFormatManager() {
    }

    static Collection<BarcodeFormat> parseDecodeFormats(Intent intent) {
        List<String> scanFormats = null;
        String scanFormatsString = intent.getStringExtra("SCAN_FORMATS");
        if (scanFormatsString != null) {
            scanFormats = Arrays.asList(COMMA_PATTERN.split(scanFormatsString));
        }
        return DecodeFormatManager.parseDecodeFormats(scanFormats, intent.getStringExtra("SCAN_MODE"));
    }

    static Collection<BarcodeFormat> parseDecodeFormats(Uri inputUri) {
        List<String> formats = inputUri.getQueryParameters("SCAN_FORMATS");
        if (formats != null && formats.size() == 1 && formats.get(0) != null) {
            formats = Arrays.asList(COMMA_PATTERN.split((CharSequence)formats.get(0)));
        }
        return DecodeFormatManager.parseDecodeFormats((Iterable<String>)formats, inputUri.getQueryParameter("SCAN_MODE"));
    }

    private static Collection<BarcodeFormat> parseDecodeFormats(Iterable<String> scanFormats, String decodeMode) {
        if (scanFormats != null) {
            EnumSet<BarcodeFormat> formats = EnumSet.noneOf(BarcodeFormat.class);
            try {
                for (String format : scanFormats) {
                    formats.add(BarcodeFormat.valueOf(format));
                }
                return formats;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (decodeMode != null) {
            if ("PRODUCT_MODE".equals(decodeMode)) {
                return PRODUCT_FORMATS;
            }
            if ("QR_CODE_MODE".equals(decodeMode)) {
                return QR_CODE_FORMATS;
            }
            if ("DATA_MATRIX_MODE".equals(decodeMode)) {
                return DATA_MATRIX_FORMATS;
            }
            if ("ONE_D_MODE".equals(decodeMode)) {
                return ONE_D_FORMATS;
            }
        }
        return null;
    }

    static {
        QR_CODE_FORMATS = EnumSet.of(BarcodeFormat.QR_CODE);
        DATA_MATRIX_FORMATS = EnumSet.of(BarcodeFormat.DATA_MATRIX);
        PRODUCT_FORMATS = EnumSet.of(BarcodeFormat.UPC_A, BarcodeFormat.UPC_E, BarcodeFormat.EAN_13, BarcodeFormat.EAN_8, BarcodeFormat.RSS_14);
        ONE_D_FORMATS = EnumSet.of(BarcodeFormat.CODE_39, BarcodeFormat.CODE_93, BarcodeFormat.CODE_128, BarcodeFormat.ITF, BarcodeFormat.CODABAR);
        ONE_D_FORMATS.addAll(PRODUCT_FORMATS);
    }
}

