/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android;

import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.FakeR;
import com.google.zxing.Result;
import com.google.zxing.client.android.CaptureActivity;
import com.google.zxing.client.android.DecodeThread;
import com.google.zxing.client.android.ViewfinderResultPointCallback;
import com.google.zxing.client.android.camera.CameraManager;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CaptureActivityHandler
extends Handler {
    private static final String TAG = CaptureActivityHandler.class.getSimpleName();
    private final CaptureActivity activity;
    private final DecodeThread decodeThread;
    private State state;
    private final CameraManager cameraManager;
    private static FakeR fakeR;

    CaptureActivityHandler(CaptureActivity activity, Collection<BarcodeFormat> decodeFormats, String characterSet, CameraManager cameraManager) {
        fakeR = new FakeR(activity);
        this.activity = activity;
        this.decodeThread = new DecodeThread(activity, decodeFormats, characterSet, new ViewfinderResultPointCallback(activity.getViewfinderView()));
        this.decodeThread.start();
        this.state = State.SUCCESS;
        this.cameraManager = cameraManager;
        cameraManager.startPreview();
        this.restartPreviewAndDecode();
    }

    public void handleMessage(Message message) {
        if (message.what == fakeR.getId("id", "restart_preview")) {
            Log.d((String)TAG, (String)"Got restart preview message");
            this.restartPreviewAndDecode();
        } else if (message.what == fakeR.getId("id", "decode_succeeded")) {
            Log.d((String)TAG, (String)"Got decode succeeded message");
            this.state = State.SUCCESS;
            Bundle bundle = message.getData();
            Bitmap barcode = bundle == null ? null : (Bitmap)bundle.getParcelable("barcode_bitmap");
            this.activity.handleDecode((Result)message.obj, barcode);
        } else if (message.what == fakeR.getId("id", "decode_failed")) {
            this.state = State.PREVIEW;
            this.cameraManager.requestPreviewFrame(this.decodeThread.getHandler(), fakeR.getId("id", "decode"));
        } else if (message.what == fakeR.getId("id", "return_scan_result")) {
            Log.d((String)TAG, (String)"Got return scan result message");
            this.activity.setResult(-1, (Intent)message.obj);
            this.activity.finish();
        } else if (message.what == fakeR.getId("id", "launch_product_query")) {
            Log.d((String)TAG, (String)"Got product query message");
            String url = (String)message.obj;
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.addFlags(524288);
            intent.setData(Uri.parse((String)url));
            ResolveInfo resolveInfo = this.activity.getPackageManager().resolveActivity(intent, 65536);
            String browserPackageName = null;
            if (resolveInfo.activityInfo != null) {
                browserPackageName = resolveInfo.activityInfo.packageName;
                Log.d((String)TAG, (String)("Using browser in package " + browserPackageName));
            }
            if ("com.android.browser".equals(browserPackageName)) {
                intent.setPackage(browserPackageName);
                intent.addFlags(0x10000000);
                intent.putExtra("com.android.browser.application_id", browserPackageName);
            }
            try {
                this.activity.startActivity(intent);
            }
            catch (ActivityNotFoundException anfe) {
                Log.w((String)TAG, (String)("Can't find anything to handle VIEW of URI " + url));
            }
        }
    }

    public void quitSynchronously() {
        this.state = State.DONE;
        this.cameraManager.stopPreview();
        Message quit = Message.obtain((Handler)this.decodeThread.getHandler(), (int)fakeR.getId("id", "quit"));
        quit.sendToTarget();
        try {
            this.decodeThread.join(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.removeMessages(fakeR.getId("id", "decode_succeeded"));
        this.removeMessages(fakeR.getId("id", "decode_failed"));
    }

    private void restartPreviewAndDecode() {
        if (this.state == State.SUCCESS) {
            this.state = State.PREVIEW;
            this.cameraManager.requestPreviewFrame(this.decodeThread.getHandler(), fakeR.getId("id", "decode"));
            this.activity.drawViewfinder();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        PREVIEW,
        SUCCESS,
        DONE;

    }
}

