/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.preference.PreferenceManager;
import android.text.ClipboardManager;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.FakeR;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.client.android.BeepManager;
import com.google.zxing.client.android.CaptureActivityHandler;
import com.google.zxing.client.android.DecodeFormatManager;
import com.google.zxing.client.android.FinishListener;
import com.google.zxing.client.android.HelpActivity;
import com.google.zxing.client.android.InactivityTimer;
import com.google.zxing.client.android.IntentSource;
import com.google.zxing.client.android.PreferencesActivity;
import com.google.zxing.client.android.ViewfinderView;
import com.google.zxing.client.android.camera.CameraManager;
import com.google.zxing.client.android.history.HistoryActivity;
import com.google.zxing.client.android.history.HistoryItem;
import com.google.zxing.client.android.history.HistoryManager;
import com.google.zxing.client.android.result.ResultButtonListener;
import com.google.zxing.client.android.result.ResultHandler;
import com.google.zxing.client.android.result.ResultHandlerFactory;
import com.google.zxing.client.android.result.supplement.SupplementalInfoRetriever;
import com.google.zxing.client.android.share.ShareActivity;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public final class CaptureActivity
extends Activity
implements SurfaceHolder.Callback {
    private static FakeR fakeR;
    private static final String TAG;
    private static final long DEFAULT_INTENT_RESULT_DURATION_MS = 1500L;
    private static final long BULK_MODE_SCAN_DELAY_MS = 1000L;
    private static final String PACKAGE_NAME = "com.google.zxing.client.android";
    private static final String PRODUCT_SEARCH_URL_PREFIX = "http://www.google";
    private static final String PRODUCT_SEARCH_URL_SUFFIX = "/m/products/scan";
    private static final String[] ZXING_URLS;
    private static final String RETURN_CODE_PLACEHOLDER = "{CODE}";
    private static final String RETURN_URL_PARAM = "ret";
    private static final String RAW_PARAM = "raw";
    public static final int HISTORY_REQUEST_CODE = 47820;
    private static final Set<ResultMetadataType> DISPLAYABLE_METADATA_TYPES;
    private CameraManager cameraManager;
    private CaptureActivityHandler handler;
    private Result savedResultToShow;
    private ViewfinderView viewfinderView;
    private TextView statusView;
    private View resultView;
    private Result lastResult;
    private boolean hasSurface;
    private boolean copyToClipboard;
    private IntentSource source;
    private String sourceUrl;
    private String returnUrlTemplate;
    private boolean returnRaw;
    private Collection<BarcodeFormat> decodeFormats;
    private String characterSet;
    private HistoryManager historyManager;
    private InactivityTimer inactivityTimer;
    private BeepManager beepManager;

    ViewfinderView getViewfinderView() {
        return this.viewfinderView;
    }

    public Handler getHandler() {
        return this.handler;
    }

    CameraManager getCameraManager() {
        return this.cameraManager;
    }

    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        fakeR = new FakeR(this);
        Window window = this.getWindow();
        window.addFlags(128);
        this.setContentView(fakeR.getId("layout", "capture"));
        this.hasSurface = false;
        this.historyManager = new HistoryManager(this);
        this.historyManager.trimHistory();
        this.inactivityTimer = new InactivityTimer(this);
        this.beepManager = new BeepManager(this);
        PreferenceManager.setDefaultValues((Context)this, (int)fakeR.getId("xml", "preferences"), (boolean)false);
    }

    protected void onResume() {
        super.onResume();
        this.cameraManager = new CameraManager((Context)this.getApplication());
        this.viewfinderView = (ViewfinderView)this.findViewById(fakeR.getId("id", "viewfinder_view"));
        this.viewfinderView.setCameraManager(this.cameraManager);
        this.resultView = this.findViewById(fakeR.getId("id", "result_view"));
        this.statusView = (TextView)this.findViewById(fakeR.getId("id", "status_view"));
        this.handler = null;
        this.lastResult = null;
        this.resetStatusView();
        SurfaceView surfaceView = (SurfaceView)this.findViewById(fakeR.getId("id", "preview_view"));
        SurfaceHolder surfaceHolder = surfaceView.getHolder();
        if (this.hasSurface) {
            this.initCamera(surfaceHolder);
        } else {
            surfaceHolder.addCallback((SurfaceHolder.Callback)this);
            surfaceHolder.setType(3);
        }
        this.beepManager.updatePrefs();
        this.inactivityTimer.onResume();
        Intent intent = this.getIntent();
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
        this.copyToClipboard = prefs.getBoolean("preferences_copy_to_clipboard", true) && (intent == null || intent.getBooleanExtra("SAVE_HISTORY", true));
        this.source = IntentSource.NATIVE_APP_INTENT;
        this.decodeFormats = null;
        this.characterSet = null;
        if (intent != null) {
            String action = intent.getAction();
            String dataString = intent.getDataString();
            if ("com.google.zxing.client.android.SCAN".equals(action)) {
                String customPromptMessage;
                this.source = IntentSource.NATIVE_APP_INTENT;
                this.decodeFormats = DecodeFormatManager.parseDecodeFormats(intent);
                if (intent.hasExtra("SCAN_WIDTH") && intent.hasExtra("SCAN_HEIGHT")) {
                    int width = intent.getIntExtra("SCAN_WIDTH", 0);
                    int height = intent.getIntExtra("SCAN_HEIGHT", 0);
                    if (width > 0 && height > 0) {
                        this.cameraManager.setManualFramingRect(width, height);
                    }
                }
                if ((customPromptMessage = intent.getStringExtra("PROMPT_MESSAGE")) != null) {
                    this.statusView.setText((CharSequence)customPromptMessage);
                }
            } else if (dataString != null && dataString.contains(PRODUCT_SEARCH_URL_PREFIX) && dataString.contains(PRODUCT_SEARCH_URL_SUFFIX)) {
                this.source = IntentSource.PRODUCT_SEARCH_LINK;
                this.sourceUrl = dataString;
                this.decodeFormats = DecodeFormatManager.PRODUCT_FORMATS;
            } else if (CaptureActivity.isZXingURL(dataString)) {
                this.source = IntentSource.ZXING_LINK;
                this.sourceUrl = dataString;
                Uri inputUri = Uri.parse((String)this.sourceUrl);
                this.returnUrlTemplate = inputUri.getQueryParameter(RETURN_URL_PARAM);
                this.returnRaw = inputUri.getQueryParameter(RAW_PARAM) != null;
                this.decodeFormats = DecodeFormatManager.parseDecodeFormats(inputUri);
            }
            this.characterSet = intent.getStringExtra("CHARACTER_SET");
        }
    }

    private static boolean isZXingURL(String dataString) {
        if (dataString == null) {
            return false;
        }
        for (String url : ZXING_URLS) {
            if (!dataString.startsWith(url)) continue;
            return true;
        }
        return false;
    }

    protected void onPause() {
        if (this.handler != null) {
            this.handler.quitSynchronously();
            this.handler = null;
        }
        this.inactivityTimer.onPause();
        this.cameraManager.closeDriver();
        if (!this.hasSurface) {
            SurfaceView surfaceView = (SurfaceView)this.findViewById(fakeR.getId("id", "preview_view"));
            SurfaceHolder surfaceHolder = surfaceView.getHolder();
            surfaceHolder.removeCallback((SurfaceHolder.Callback)this);
        }
        super.onPause();
    }

    protected void onDestroy() {
        this.inactivityTimer.shutdown();
        super.onDestroy();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                if (this.source == IntentSource.NATIVE_APP_INTENT) {
                    this.setResult(0);
                    this.finish();
                    return true;
                }
                if (this.source != IntentSource.NONE && this.source != IntentSource.ZXING_LINK || this.lastResult == null) break;
                this.restartPreviewAfterDelay(0L);
                return true;
            }
            case 27: 
            case 80: {
                return true;
            }
            case 25: {
                this.cameraManager.setTorch(false);
                return true;
            }
            case 24: {
                this.cameraManager.setTorch(true);
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater menuInflater = this.getMenuInflater();
        menuInflater.inflate(fakeR.getId("menu", "capture"), menu);
        return super.onCreateOptionsMenu(menu);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addFlags(524288);
        int itemId = item.getItemId();
        if (itemId == fakeR.getId("id", "menu_share")) {
            intent.setClassName((Context)this, ShareActivity.class.getName());
            this.startActivity(intent);
        } else if (itemId == fakeR.getId("id", "menu_history")) {
            intent.setClassName((Context)this, HistoryActivity.class.getName());
            this.startActivityForResult(intent, 47820);
        } else if (itemId == fakeR.getId("id", "menu_settings")) {
            intent.setClassName((Context)this, PreferencesActivity.class.getName());
            this.startActivity(intent);
        } else if (itemId == fakeR.getId("id", "menu_help")) {
            intent.setClassName((Context)this, HelpActivity.class.getName());
            this.startActivity(intent);
        } else {
            return super.onOptionsItemSelected(item);
        }
        return true;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        int itemNumber;
        if (resultCode == -1 && requestCode == 47820 && (itemNumber = intent.getIntExtra("ITEM_NUMBER", -1)) >= 0) {
            HistoryItem historyItem = this.historyManager.buildHistoryItem(itemNumber);
            this.decodeOrStoreSavedBitmap(null, historyItem.getResult());
        }
    }

    private void decodeOrStoreSavedBitmap(Bitmap bitmap, Result result) {
        if (this.handler == null) {
            this.savedResultToShow = result;
        } else {
            if (result != null) {
                this.savedResultToShow = result;
            }
            if (this.savedResultToShow != null) {
                Message message = Message.obtain((Handler)this.handler, (int)fakeR.getId("id", "decode_succeeded"), (Object)this.savedResultToShow);
                this.handler.sendMessage(message);
            }
            this.savedResultToShow = null;
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (holder == null) {
            Log.e((String)TAG, (String)"*** WARNING *** surfaceCreated() gave us a null surface!");
        }
        if (!this.hasSurface) {
            this.hasSurface = true;
            this.initCamera(holder);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.hasSurface = false;
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void handleDecode(Result rawResult, Bitmap barcode) {
        boolean fromLiveScan;
        this.inactivityTimer.onActivity();
        this.lastResult = rawResult;
        ResultHandler resultHandler = ResultHandlerFactory.makeResultHandler(this, rawResult);
        boolean bl = fromLiveScan = barcode != null;
        if (fromLiveScan) {
            this.historyManager.addHistoryItem(rawResult, resultHandler);
            this.beepManager.playBeepSoundAndVibrate();
            this.drawResultPoints(barcode, rawResult);
        }
        switch (this.source) {
            case NATIVE_APP_INTENT: 
            case PRODUCT_SEARCH_LINK: {
                this.handleDecodeExternally(rawResult, resultHandler, barcode);
                break;
            }
            case ZXING_LINK: {
                if (this.returnUrlTemplate == null) {
                    this.handleDecodeInternally(rawResult, resultHandler, barcode);
                    break;
                }
                this.handleDecodeExternally(rawResult, resultHandler, barcode);
                break;
            }
            case NONE: {
                SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
                if (fromLiveScan && prefs.getBoolean("preferences_bulk_mode", false)) {
                    String message = this.getResources().getString(fakeR.getId("string", "msg_bulk_mode_scanned")) + " (" + rawResult.getText() + ')';
                    Toast.makeText((Context)this, (CharSequence)message, (int)0).show();
                    this.restartPreviewAfterDelay(1000L);
                    break;
                }
                this.handleDecodeInternally(rawResult, resultHandler, barcode);
            }
        }
    }

    private void drawResultPoints(Bitmap barcode, Result rawResult) {
        ResultPoint[] points = rawResult.getResultPoints();
        if (points != null && points.length > 0) {
            Canvas canvas = new Canvas(barcode);
            Paint paint = new Paint();
            paint.setColor(this.getResources().getColor(fakeR.getId("color", "result_points")));
            if (points.length == 2) {
                paint.setStrokeWidth(4.0f);
                CaptureActivity.drawLine(canvas, paint, points[0], points[1]);
            } else if (points.length == 4 && (rawResult.getBarcodeFormat() == BarcodeFormat.UPC_A || rawResult.getBarcodeFormat() == BarcodeFormat.EAN_13)) {
                CaptureActivity.drawLine(canvas, paint, points[0], points[1]);
                CaptureActivity.drawLine(canvas, paint, points[2], points[3]);
            } else {
                paint.setStrokeWidth(10.0f);
                for (ResultPoint point : points) {
                    canvas.drawPoint(point.getX(), point.getY(), paint);
                }
            }
        }
    }

    private static void drawLine(Canvas canvas, Paint paint, ResultPoint a, ResultPoint b) {
        canvas.drawLine(a.getX(), a.getY(), b.getX(), b.getY(), paint);
    }

    private void handleDecodeInternally(Result rawResult, ResultHandler resultHandler, Bitmap barcode) {
        this.statusView.setVisibility(8);
        this.viewfinderView.setVisibility(8);
        this.resultView.setVisibility(0);
        ImageView barcodeImageView = (ImageView)this.findViewById(fakeR.getId("id", "barcode_image_view"));
        if (barcode == null) {
            barcodeImageView.setImageBitmap(BitmapFactory.decodeResource((Resources)this.getResources(), (int)fakeR.getId("drawable", "launcher_icon")));
        } else {
            barcodeImageView.setImageBitmap(barcode);
        }
        TextView formatTextView = (TextView)this.findViewById(fakeR.getId("id", "format_text_view"));
        formatTextView.setText((CharSequence)rawResult.getBarcodeFormat().toString());
        TextView typeTextView = (TextView)this.findViewById(fakeR.getId("id", "type_text_view"));
        typeTextView.setText((CharSequence)resultHandler.getType().toString());
        DateFormat formatter = DateFormat.getDateTimeInstance(3, 3);
        String formattedTime = formatter.format(new Date(rawResult.getTimestamp()));
        TextView timeTextView = (TextView)this.findViewById(fakeR.getId("id", "time_text_view"));
        timeTextView.setText((CharSequence)formattedTime);
        TextView metaTextView = (TextView)this.findViewById(fakeR.getId("id", "meta_text_view"));
        View metaTextViewLabel = this.findViewById(fakeR.getId("id", "meta_text_view_label"));
        metaTextView.setVisibility(8);
        metaTextViewLabel.setVisibility(8);
        Map<ResultMetadataType, Object> metadata = rawResult.getResultMetadata();
        if (metadata != null) {
            StringBuilder metadataText = new StringBuilder(20);
            for (Map.Entry<ResultMetadataType, Object> entry : metadata.entrySet()) {
                if (!DISPLAYABLE_METADATA_TYPES.contains((Object)entry.getKey())) continue;
                metadataText.append(entry.getValue()).append('\n');
            }
            if (metadataText.length() > 0) {
                metadataText.setLength(metadataText.length() - 1);
                metaTextView.setText((CharSequence)metadataText);
                metaTextView.setVisibility(0);
                metaTextViewLabel.setVisibility(0);
            }
        }
        TextView contentsTextView = (TextView)this.findViewById(fakeR.getId("id", "contents_text_view"));
        CharSequence displayContents = resultHandler.getDisplayContents();
        contentsTextView.setText(displayContents);
        int scaledSize = Math.max(22, 32 - displayContents.length() / 4);
        contentsTextView.setTextSize(2, (float)scaledSize);
        TextView supplementTextView = (TextView)this.findViewById(fakeR.getId("id", "contents_supplement_text_view"));
        supplementTextView.setText((CharSequence)"");
        supplementTextView.setOnClickListener(null);
        if (PreferenceManager.getDefaultSharedPreferences((Context)this).getBoolean("preferences_supplemental", true)) {
            SupplementalInfoRetriever.maybeInvokeRetrieval(supplementTextView, resultHandler.getResult(), this.historyManager, (Context)this);
        }
        int buttonCount = resultHandler.getButtonCount();
        ViewGroup buttonView = (ViewGroup)this.findViewById(fakeR.getId("id", "result_button_view"));
        buttonView.requestFocus();
        for (int x = 0; x < 4; ++x) {
            TextView button = (TextView)buttonView.getChildAt(x);
            if (x < buttonCount) {
                button.setVisibility(0);
                button.setText(resultHandler.getButtonText(x));
                button.setOnClickListener((View.OnClickListener)new ResultButtonListener(resultHandler, x));
                continue;
            }
            button.setVisibility(8);
        }
        if (this.copyToClipboard && !resultHandler.areContentsSecure()) {
            ClipboardManager clipboard = (ClipboardManager)this.getSystemService("clipboard");
            if (displayContents != null) {
                clipboard.setText(displayContents);
            }
        }
    }

    private void handleDecodeExternally(Result rawResult, ResultHandler resultHandler, Bitmap barcode) {
        String replyURL;
        long resultDurationMS;
        if (barcode != null) {
            this.viewfinderView.drawResultBitmap(barcode);
        }
        if ((resultDurationMS = this.getIntent() == null ? 1500L : this.getIntent().getLongExtra("RESULT_DISPLAY_DURATION_MS", 1500L)) > 0L) {
            this.statusView.setText((CharSequence)this.getString(resultHandler.getDisplayTitle()));
        }
        if (this.copyToClipboard && !resultHandler.areContentsSecure()) {
            ClipboardManager clipboard = (ClipboardManager)this.getSystemService("clipboard");
            CharSequence text = resultHandler.getDisplayContents();
            if (text != null) {
                clipboard.setText(text);
            }
        }
        if (this.source == IntentSource.NATIVE_APP_INTENT) {
            Map<ResultMetadataType, Object> metadata;
            Intent intent = new Intent(this.getIntent().getAction());
            intent.addFlags(524288);
            intent.putExtra("SCAN_RESULT", rawResult.toString());
            intent.putExtra("SCAN_RESULT_FORMAT", rawResult.getBarcodeFormat().toString());
            byte[] rawBytes = rawResult.getRawBytes();
            if (rawBytes != null && rawBytes.length > 0) {
                intent.putExtra("SCAN_RESULT_BYTES", rawBytes);
            }
            if ((metadata = rawResult.getResultMetadata()) != null) {
                Iterable byteSegments;
                String ecLevel;
                Integer orientation;
                if (metadata.containsKey((Object)ResultMetadataType.UPC_EAN_EXTENSION)) {
                    intent.putExtra("SCAN_RESULT_UPC_EAN_EXTENSION", metadata.get((Object)ResultMetadataType.UPC_EAN_EXTENSION).toString());
                }
                if ((orientation = (Integer)metadata.get((Object)ResultMetadataType.ORIENTATION)) != null) {
                    intent.putExtra("SCAN_RESULT_ORIENTATION", orientation.intValue());
                }
                if ((ecLevel = (String)metadata.get((Object)ResultMetadataType.ERROR_CORRECTION_LEVEL)) != null) {
                    intent.putExtra("SCAN_RESULT_ERROR_CORRECTION_LEVEL", ecLevel);
                }
                if ((byteSegments = (Iterable)metadata.get((Object)ResultMetadataType.BYTE_SEGMENTS)) != null) {
                    int i = 0;
                    for (byte[] byteSegment : byteSegments) {
                        intent.putExtra("SCAN_RESULT_BYTE_SEGMENTS_" + i, byteSegment);
                        ++i;
                    }
                }
            }
            this.sendReplyMessage(fakeR.getId("id", "return_scan_result"), intent, resultDurationMS);
        } else if (this.source == IntentSource.PRODUCT_SEARCH_LINK) {
            int end = this.sourceUrl.lastIndexOf("/scan");
            replyURL = this.sourceUrl.substring(0, end) + "?q=" + resultHandler.getDisplayContents() + "&source=zxing";
            this.sendReplyMessage(fakeR.getId("id", "launch_product_query"), replyURL, resultDurationMS);
        } else if (this.source == IntentSource.ZXING_LINK && this.returnUrlTemplate != null) {
            CharSequence codeReplacement = this.returnRaw ? rawResult.getText() : resultHandler.getDisplayContents();
            try {
                codeReplacement = URLEncoder.encode(codeReplacement.toString(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            replyURL = this.returnUrlTemplate.replace(RETURN_CODE_PLACEHOLDER, codeReplacement);
            this.sendReplyMessage(fakeR.getId("id", "launch_product_query"), replyURL, resultDurationMS);
        }
    }

    private void sendReplyMessage(int id, Object arg, long delayMS) {
        Message message = Message.obtain((Handler)this.handler, (int)id, (Object)arg);
        if (delayMS > 0L) {
            this.handler.sendMessageDelayed(message, delayMS);
        } else {
            this.handler.sendMessage(message);
        }
    }

    private boolean showHelpOnFirstLaunch() {
        try {
            PackageInfo info = this.getPackageManager().getPackageInfo(PACKAGE_NAME, 0);
            int currentVersion = info.versionCode;
            SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
            int lastVersion = prefs.getInt("preferences_help_version_shown", 0);
            if (currentVersion > lastVersion) {
                prefs.edit().putInt("preferences_help_version_shown", currentVersion).commit();
                Intent intent = new Intent((Context)this, HelpActivity.class);
                intent.addFlags(524288);
                String page = lastVersion == 0 ? "index.html" : "whatsnew.html";
                intent.putExtra("requested_page_key", page);
                this.startActivity(intent);
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        return false;
    }

    private void initCamera(SurfaceHolder surfaceHolder) {
        if (surfaceHolder == null) {
            throw new IllegalStateException("No SurfaceHolder provided");
        }
        if (this.cameraManager.isOpen()) {
            Log.w((String)TAG, (String)"initCamera() while already open -- late SurfaceView callback?");
            return;
        }
        try {
            this.cameraManager.openDriver(surfaceHolder);
            if (this.handler == null) {
                this.handler = new CaptureActivityHandler(this, this.decodeFormats, this.characterSet, this.cameraManager);
            }
            this.decodeOrStoreSavedBitmap(null, null);
        }
        catch (IOException ioe) {
            Log.w((String)TAG, (Throwable)ioe);
            this.displayFrameworkBugMessageAndExit();
        }
        catch (RuntimeException e) {
            Log.w((String)TAG, (String)"Unexpected error initializing camera", (Throwable)e);
            this.displayFrameworkBugMessageAndExit();
        }
    }

    private void displayFrameworkBugMessageAndExit() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle((CharSequence)this.getString(fakeR.getId("string", "app_name")));
        builder.setMessage((CharSequence)this.getString(fakeR.getId("string", "msg_camera_framework_bug")));
        builder.setPositiveButton(fakeR.getId("string", "button_ok"), (DialogInterface.OnClickListener)new FinishListener(this));
        builder.setOnCancelListener((DialogInterface.OnCancelListener)new FinishListener(this));
        builder.show();
    }

    public void restartPreviewAfterDelay(long delayMS) {
        if (this.handler != null) {
            this.handler.sendEmptyMessageDelayed(fakeR.getId("id", "restart_preview"), delayMS);
        }
        this.resetStatusView();
    }

    private void resetStatusView() {
        this.resultView.setVisibility(8);
        this.statusView.setText(fakeR.getId("string", "msg_default_status"));
        this.statusView.setVisibility(0);
        this.viewfinderView.setVisibility(0);
        this.lastResult = null;
    }

    public void drawViewfinder() {
        this.viewfinderView.drawViewfinder();
    }

    static {
        TAG = CaptureActivity.class.getSimpleName();
        ZXING_URLS = new String[]{"http://zxing.appspot.com/scan", "zxing://scan/"};
        DISPLAYABLE_METADATA_TYPES = EnumSet.of(ResultMetadataType.ISSUE_NUMBER, ResultMetadataType.SUGGESTED_PRICE, ResultMetadataType.ERROR_CORRECTION_LEVEL, ResultMetadataType.POSSIBLE_COUNTRY);
    }
}

