/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.AssetFileDescriptor;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Vibrator;
import android.preference.PreferenceManager;
import android.util.Log;
import com.google.zxing.FakeR;
import java.io.IOException;

final class BeepManager {
    private static final String TAG = BeepManager.class.getSimpleName();
    private static final float BEEP_VOLUME = 0.1f;
    private static final long VIBRATE_DURATION = 200L;
    private final Activity activity;
    private MediaPlayer mediaPlayer;
    private boolean playBeep;
    private boolean vibrate;
    private static FakeR fakeR;

    BeepManager(Activity activity) {
        fakeR = new FakeR(activity);
        this.activity = activity;
        this.mediaPlayer = null;
        this.updatePrefs();
    }

    void updatePrefs() {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.activity);
        this.playBeep = BeepManager.shouldBeep(prefs, (Context)this.activity);
        this.vibrate = prefs.getBoolean("preferences_vibrate", false);
        if (this.playBeep && this.mediaPlayer == null) {
            this.activity.setVolumeControlStream(3);
            this.mediaPlayer = BeepManager.buildMediaPlayer((Context)this.activity);
        }
    }

    void playBeepSoundAndVibrate() {
        if (this.playBeep && this.mediaPlayer != null) {
            this.mediaPlayer.start();
        }
        if (this.vibrate) {
            Vibrator vibrator = (Vibrator)this.activity.getSystemService("vibrator");
            vibrator.vibrate(200L);
        }
    }

    private static boolean shouldBeep(SharedPreferences prefs, Context activity) {
        AudioManager audioService;
        boolean shouldPlayBeep = prefs.getBoolean("preferences_play_beep", true);
        if (shouldPlayBeep && (audioService = (AudioManager)activity.getSystemService("audio")).getRingerMode() != 2) {
            shouldPlayBeep = false;
        }
        return shouldPlayBeep;
    }

    private static MediaPlayer buildMediaPlayer(Context activity) {
        MediaPlayer mediaPlayer = new MediaPlayer();
        mediaPlayer.setAudioStreamType(3);
        mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer player) {
                player.seekTo(0);
            }
        });
        AssetFileDescriptor file = activity.getResources().openRawResourceFd(fakeR.getId("raw", "beep"));
        try {
            mediaPlayer.setDataSource(file.getFileDescriptor(), file.getStartOffset(), file.getLength());
            file.close();
            mediaPlayer.setVolume(0.1f, 0.1f);
            mediaPlayer.prepare();
        }
        catch (IOException ioe) {
            Log.w((String)TAG, (Throwable)ioe);
            mediaPlayer = null;
        }
        return mediaPlayer;
    }
}

