/*
 * Decompiled with CFR 0.152.
 */
package com.opg.sdk.restclient;

import android.content.Context;
import android.util.Base64;
import com.opg.sdk.OPGPreference;
import com.opg.sdk.OPGUploadProgress;
import com.opg.sdk.exceptions.OPGException;
import com.opg.sdk.restclient.OPGHttpUrlRequest;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.json.JSONObject;

public class OPGNetworkRequest {
    private static final int BUFFER_SIZE = 4096;
    private static final int CONNECT_TIMEOUT = 360000;
    private static final int READ_TIMEOUT = 360000;

    public static OPGHttpUrlRequest createRequestParams(Context mContext, JSONObject reqEntity, String apiRoute) throws Exception {
        String url = OPGPreference.getApiURL(mContext) + apiRoute;
        JSONObject data = new JSONObject();
        data.put("Data", (Object)reqEntity.toString());
        String dataString = data.toString();
        String contentLength = String.valueOf(dataString.getBytes().length);
        String contentType = null;
        contentType = apiRoute.equalsIgnoreCase("Media/ProfileMedia") ? "application/json;charset=utf-8" : "application/json";
        String base64auth = OPGNetworkRequest.getBase64Auth(mContext);
        return new OPGHttpUrlRequest(url, dataString, base64auth, contentType, contentLength);
    }

    public static String getBase64Auth(Context mContext) {
        String authorisation = OPGPreference.getUsername(mContext) + ":" + OPGPreference.getSharedKey(mContext);
        return "Basic " + Base64.encodeToString((byte[])authorisation.getBytes(), (int)0).replace("\n", "");
    }

    public static String performRequest(OPGHttpUrlRequest opgRequest) throws IOException, OPGException {
        String result = null;
        String output = null;
        URL url = new URL(opgRequest.getUrl());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(360000);
        connection.setReadTimeout(360000);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("USER-AGENT", "Mozilla/5.0");
        connection.setRequestProperty("ACCEPT-LANGUAGE", "en-US,en;0.5");
        if (opgRequest.getAuthKey() != null) {
            connection.setRequestProperty("Authorization", opgRequest.getAuthKey());
        }
        connection.setRequestProperty("Content-Type", opgRequest.getContentType());
        connection.setRequestProperty("Content-Length", opgRequest.getContentLength());
        connection.setUseCaches(false);
        DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
        wr.write(opgRequest.getData().getBytes("UTF-8"));
        wr.flush();
        wr.close();
        int responseCode = connection.getResponseCode();
        if (responseCode >= 200 && responseCode < 400) {
            InputStream instream = connection.getInputStream();
            output = result = OPGNetworkRequest.convertStreamToString(instream);
            instream.close();
        } else if (responseCode >= 400) {
            InputStream instream = connection.getErrorStream();
            output = result = OPGNetworkRequest.convertStreamToString(instream);
            instream.close();
        } else {
            throw new OPGException("Unknown Exception");
        }
        connection.disconnect();
        return output;
    }

    public static String uploadMediaRequest(Context mContext, String apiRoute, String AUTH_KEY, String selectedFilePath, OPGUploadProgress uploadProgress, long folderSize) throws Exception {
        String output = null;
        String SERVER_URL = OPGPreference.getApiURL(mContext) + apiRoute;
        HttpURLConnection connection = null;
        FileInputStream fileInputStream = null;
        DataOutputStream dataOutputStream = null;
        String lineEnd = "\r\n";
        String twoHyphens = "--";
        String boundary = "*****";
        int maxBufferSize = 0x100000;
        File selectedFile = new File(selectedFilePath);
        selectedFilePath = selectedFile.getAbsolutePath();
        long totalSize = folderSize;
        if (totalSize == 0L) {
            totalSize = selectedFile.length();
        }
        String[] parts = selectedFilePath.split("/");
        String fileName = parts[parts.length - 1];
        try {
            fileInputStream = new FileInputStream(selectedFile);
            URL url = new URL(SERVER_URL);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(360000);
            connection.setReadTimeout(360000);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setChunkedStreamingMode(1024);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Connection", "Keep-Alive");
            connection.setRequestProperty("ENCTYPE", "multipart/form-data");
            connection.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
            connection.setRequestProperty("file", selectedFilePath);
            if (AUTH_KEY != null) {
                connection.setRequestProperty("Authorization", AUTH_KEY);
            }
            dataOutputStream = new DataOutputStream(connection.getOutputStream());
            dataOutputStream.writeBytes(twoHyphens + boundary + lineEnd);
            dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"file\";filename=\"" + fileName + "\"" + lineEnd);
            dataOutputStream.writeBytes(lineEnd);
            int bytesAvailable = fileInputStream.available();
            int bufferSize = Math.min(bytesAvailable, maxBufferSize);
            byte[] buffer = new byte[bufferSize];
            int bytesRead = fileInputStream.read(buffer, 0, bufferSize);
            while (bytesRead > 0) {
                dataOutputStream.write(buffer, 0, bufferSize);
                bytesAvailable = fileInputStream.available();
                bufferSize = Math.min(bytesAvailable, maxBufferSize);
                bytesRead = fileInputStream.read(buffer, 0, bufferSize);
            }
            dataOutputStream.writeBytes(lineEnd);
            dataOutputStream.writeBytes(twoHyphens + boundary + twoHyphens + lineEnd);
            int responseCode = connection.getResponseCode();
            if (responseCode >= 200 && responseCode < 400) {
                InputStream instream = connection.getInputStream();
                output = OPGNetworkRequest.convertStreamToString(instream);
                instream.close();
            } else if (responseCode >= 400) {
                InputStream instream = connection.getErrorStream();
                output = OPGNetworkRequest.convertStreamToString(instream);
                instream.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (dataOutputStream != null) {
                dataOutputStream.flush();
                dataOutputStream.close();
            }
        }
        return output;
    }

    public static boolean downloadMediaRequest(Context mContext, String mediaID, String mediaType, String fileName, String filePath) throws Exception {
        boolean status = false;
        String fileURL = OPGPreference.getDownloadURL(mContext) + "mediaid=" + mediaID + "&mediatype=" + mediaType;
        URL url = new URL(fileURL);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.setConnectTimeout(360000);
        httpConn.setReadTimeout(360000);
        int responseCode = httpConn.getResponseCode();
        if (responseCode == 200) {
            String disposition = httpConn.getHeaderField("Content-Disposition: form-data; name=\"file\";filename=\"");
            String contentType = httpConn.getContentType();
            int contentLength = httpConn.getContentLength();
            InputStream inputStream = httpConn.getInputStream();
            if (contentType.contains("Image/") || contentType.contains("video/") || contentType.contains("audio/")) {
                if (inputStream != null) {
                    File pathFile = new File(filePath);
                    if (!pathFile.exists()) {
                        pathFile.mkdirs();
                    }
                    String saveFilePath = pathFile.getAbsolutePath() + File.separator + fileName;
                    FileOutputStream outputStream = new FileOutputStream(saveFilePath);
                    int bytesRead = -1;
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, bytesRead);
                    }
                    outputStream.close();
                    inputStream.close();
                    status = true;
                }
            } else {
                status = false;
                String string = OPGNetworkRequest.convertStreamToString(inputStream);
            }
        } else {
            status = false;
        }
        httpConn.disconnect();
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

