/*
 * Decompiled with CFR 0.152.
 */
package com.opg.sdk.geofence;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.allatori.annotations.DoNotRename;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import com.google.gson.Gson;
import com.opg.sdk.OPGR;
import com.opg.sdk.OPGSDK;
import com.opg.sdk.geofence.OPGGeofenceErrorMessages;
import com.opg.sdk.geofence.OPGWakefulReceiver;
import com.opg.sdk.models.OPGGeofenceSurvey;
import java.util.ArrayList;
import java.util.List;

@DoNotRename
public class OPGGeofenceTransitionsIntentService
extends IntentService {
    protected static final String TAG = "GeofenceTransitionsIS";
    @DoNotRename
    public String BROADCAST_GEOFENCE_TRANSITION_ENTER = ".transition.enter";
    @DoNotRename
    public String BROADCAST_GEOFENCE_TRANSITION_EXIT = ".transition.exit";
    @DoNotRename
    public String BROADCAST_GEOFENCE_TRANSITION_DWELL = ".transition.dwell";
    private Context context;
    private OPGSDK opgsdk;

    public OPGGeofenceTransitionsIntentService() {
        super(OPGGeofenceTransitionsIntentService.class.getName());
    }

    @DoNotRename
    public void onCreate() {
        super.onCreate();
        this.opgsdk = new OPGSDK();
        this.context = this;
    }

    @DoNotRename
    protected void onHandleIntent(Intent intent) {
        GeofencingEvent geofencingEvent = GeofencingEvent.fromIntent((Intent)intent);
        if (geofencingEvent.hasError()) {
            String errorMessage = OPGGeofenceErrorMessages.getErrorString((Context)this, geofencingEvent.getErrorCode());
            return;
        }
        int geofenceTransition = geofencingEvent.getGeofenceTransition();
        if (geofenceTransition == 1 || geofenceTransition == 2 || geofenceTransition == 4) {
            Intent broadcastIntent = new Intent();
            ArrayList triggeringGeofences = (ArrayList)geofencingEvent.getTriggeringGeofences();
            List<OPGGeofenceSurvey> triggeredOPGGeofences = this.convertGeofenceToOPGObject(this.context, triggeringGeofences);
            if (geofenceTransition == 1) {
                if (this.opgsdk.getOpgGeofenceTriggerEvents() != null) {
                    this.opgsdk.getOpgGeofenceTriggerEvents().didEnterSurveyRegion(geofencingEvent.getTriggeringLocation(), this.convertGeofenceToOPGObject(this.context, geofencingEvent.getTriggeringGeofences()));
                }
                broadcastIntent.setAction(this.context.getPackageName() + this.BROADCAST_GEOFENCE_TRANSITION_ENTER);
            }
            if (geofenceTransition == 2) {
                if (this.opgsdk.getOpgGeofenceTriggerEvents() != null) {
                    this.opgsdk.getOpgGeofenceTriggerEvents().didExitSurveyRegion(geofencingEvent.getTriggeringLocation(), this.convertGeofenceToOPGObject(this.context, geofencingEvent.getTriggeringGeofences()));
                }
                broadcastIntent.setAction(this.context.getPackageName() + this.BROADCAST_GEOFENCE_TRANSITION_EXIT);
            }
            if (geofenceTransition == 4) {
                if (this.opgsdk.getOpgGeofenceTriggerEvents() != null) {
                    this.opgsdk.getOpgGeofenceTriggerEvents().didDwellSurveyRegion(geofencingEvent.getTriggeringLocation(), this.convertGeofenceToOPGObject(this.context, geofencingEvent.getTriggeringGeofences()));
                }
                broadcastIntent.setAction(this.context.getPackageName() + this.BROADCAST_GEOFENCE_TRANSITION_DWELL);
            }
            broadcastIntent.putExtra("Latitude", geofencingEvent.getTriggeringLocation().getLatitude());
            broadcastIntent.putExtra("Longitude", geofencingEvent.getTriggeringLocation().getLongitude());
            broadcastIntent.putExtra("triggeredGeofences", this.convertOPGObjectsToString(triggeredOPGGeofences));
            String geofenceTransitionDetails = this.getGeofenceTransitionDetails((Context)this, geofenceTransition, triggeringGeofences);
            this.sendBroadcast(broadcastIntent);
        }
        OPGWakefulReceiver.completeWakefulIntent((Intent)intent);
    }

    private String convertOPGObjectsToString(List<OPGGeofenceSurvey> opgGeofenceSurveys) {
        Gson gson = new Gson();
        return gson.toJson(opgGeofenceSurveys);
    }

    private List<OPGGeofenceSurvey> convertGeofenceToOPGObject(Context context, List<Geofence> triggeredGeofences) {
        ArrayList<OPGGeofenceSurvey> triggeredOPGGeofenceSurveys = new ArrayList<OPGGeofenceSurvey>();
        List<OPGGeofenceSurvey> savedOPGGeofenceSurveys = OPGSDK.getOPGGeofenceSurveys(context);
        if (savedOPGGeofenceSurveys != null && savedOPGGeofenceSurveys.size() > 0 && triggeredGeofences.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            block0: for (OPGGeofenceSurvey opgGeofenceSurvey : OPGSDK.getOPGGeofenceSurveys(context)) {
                stringBuilder.setLength(0);
                stringBuilder.append(opgGeofenceSurvey.getSurveyReference()).append("-").append(opgGeofenceSurvey.getLatitude()).append("-").append(opgGeofenceSurvey.getLongitude());
                for (Geofence geofence : triggeredGeofences) {
                    if (!geofence.getRequestId().equalsIgnoreCase(stringBuilder.toString())) continue;
                    triggeredOPGGeofenceSurveys.add(opgGeofenceSurvey);
                    continue block0;
                }
            }
        }
        return triggeredOPGGeofenceSurveys;
    }

    private String getGeofenceTransitionDetails(Context context, int geofenceTransition, List<Geofence> triggeringGeofences) {
        String geofenceTransitionString = this.getTransitionString(geofenceTransition);
        ArrayList<String> triggeringGeofencesIdsList = new ArrayList<String>();
        for (Geofence geofence : triggeringGeofences) {
            triggeringGeofencesIdsList.add(geofence.getRequestId());
        }
        String triggeringGeofencesIdsString = TextUtils.join((CharSequence)", ", triggeringGeofencesIdsList);
        return geofenceTransitionString + ":" + triggeringGeofencesIdsString;
    }

    private String getTransitionString(int transitionType) {
        switch (transitionType) {
            case 1: {
                return OPGR.getString(this.getApplicationContext(), "string", "geofence_transition_entered");
            }
            case 2: {
                return OPGR.getString(this.getApplicationContext(), "string", "geofence_transition_exited");
            }
            case 4: {
                return OPGR.getString(this.getApplicationContext(), "string", "geofence_transition_dwell");
            }
        }
        return OPGR.getString(this.getApplicationContext(), "string", "unknown_geofence_transition");
    }
}

