/*
 * Decompiled with CFR 0.152.
 */
package com.opg.sdk;

import android.content.Context;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.opg.sdk.models.OPGGeofenceSurvey;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OPGPreference {
    private static final String PREFS_NAME = "OnePointPreference";
    private static final String OPG_GEOFENCE_PREF = "OnePointGeofencePerference";
    private static final String PREF_GEOFENCE_KEY = "OPGGeofenceKey";
    private static final String PREFERENCES_API_URL = "ApiUrl";
    private static final String PREFERENCES_INTERVIEW_URL = "InterviewUrl";
    private static final String PREFERENCES_USERNAME = "Username";
    private static final String PREFERENCES_SHARED_KEY = "SharedKey";
    private static final String PREFERENCES_APP_VERSION = "AppVersion";
    private static final String PREFERENCES_UNIQUE_ID = "UniqueID";
    private static final String PREFERENCES_DOWNLOAD_URL = "DownloadUrl";
    private static final String FCM_DEVICE_TOKEN = "FcmDeviceToken";
    private static final String PREFS_MYSURVEY_APP_ADMIN_NAME = "MySurveysAppAdminName";
    private static final String PREFS_MYSURVEY_APP_SHARED_KEY = "MySurveysAppSharedKey";
    private static final String PREFS_IS_GEOFENCING_TRIGGERED = "isGeoFencingTriggered";
    private static final String PREFS_GEOFENCING_SURVEYS = "geoFencingTriggered";
    private static final String LOGIN_TYPE = "loginType";
    private static final String FACEBOOK_TOKEN = "FacebookToken";
    private static final String GOOGLE_TOKEN = "GoogleToken";
    private static final String APP_LOGIN_USERNAME = "appLoginUser";
    private static final String APP_LOGIN_PASSWORD = "appLoginPassword";
    private static final String IS_APP_DEBUGABLE = "appDebuggable";

    private OPGPreference() {
    }

    private static synchronized void setProperty(Context context, String name, String value) {
        context.getSharedPreferences(PREFS_NAME, 0).edit().putString(name, value).apply();
    }

    private static synchronized String getProperty(Context context, String name, String defaultValue) {
        try {
            String value = context.getSharedPreferences(PREFS_NAME, 0).getString(name, null);
            if (value == null) {
                OPGPreference.setProperty(context, name, defaultValue);
                return defaultValue;
            }
            return value;
        }
        catch (Exception e) {
            OPGPreference.setProperty(context, name, defaultValue);
            return defaultValue;
        }
    }

    private static synchronized void setProperty(Context context, String name, boolean value) {
        context.getSharedPreferences(PREFS_NAME, 0).edit().putBoolean(name, value).apply();
    }

    private static synchronized boolean getProperty(Context context, String name, boolean defaultValue) {
        try {
            return context.getSharedPreferences(PREFS_NAME, 0).getBoolean(name, defaultValue);
        }
        catch (ClassCastException e) {
            OPGPreference.setProperty(context, name, defaultValue);
            return defaultValue;
        }
    }

    private static synchronized void setProperty(Context context, String name, int value) {
        context.getSharedPreferences(PREFS_NAME, 0).edit().putInt(name, value).apply();
    }

    private static synchronized int getProperty(Context context, String name, int defaultValue) {
        try {
            int value = context.getSharedPreferences(PREFS_NAME, 0).getInt(name, -100);
            if (value == -100) {
                OPGPreference.setProperty(context, name, defaultValue);
                return defaultValue;
            }
            return value;
        }
        catch (ClassCastException e) {
            OPGPreference.setProperty(context, name, defaultValue);
            return defaultValue;
        }
    }

    public static void setInterviewURL(String interviewURL, Context context) {
        OPGPreference.setProperty(context, PREFERENCES_INTERVIEW_URL, interviewURL);
    }

    public static String getInterviewURL(Context context) {
        String interviewURL = OPGPreference.getProperty(context, PREFERENCES_INTERVIEW_URL, null);
        return interviewURL;
    }

    public static void setApiURL(String apiUrl, Context context) {
        OPGPreference.setProperty(context, PREFERENCES_API_URL, apiUrl);
    }

    public static String getApiURL(Context context) {
        String apiURL = OPGPreference.getProperty(context, PREFERENCES_API_URL, null);
        return apiURL;
    }

    public static void setUsername(String username, Context context) {
        OPGPreference.setProperty(context, PREFERENCES_USERNAME, username);
    }

    public static String getUsername(Context context) {
        String username = OPGPreference.getProperty(context, PREFERENCES_USERNAME, null);
        return username;
    }

    public static void setSharedKey(String sharedKey, Context context) {
        OPGPreference.setProperty(context, PREFERENCES_SHARED_KEY, sharedKey);
    }

    public static String getSharedKey(Context context) {
        String sharedKey = OPGPreference.getProperty(context, PREFERENCES_SHARED_KEY, null);
        return sharedKey;
    }

    public static void setAppVersion(String appVersion, Context context) {
        OPGPreference.setProperty(context, PREFERENCES_APP_VERSION, appVersion);
    }

    public static String getAppVersion(Context context) {
        String appVersion = OPGPreference.getProperty(context, PREFERENCES_APP_VERSION, null);
        return appVersion;
    }

    public static void setUniqueID(String uniqueID, Context context) {
        OPGPreference.setProperty(context, PREFERENCES_UNIQUE_ID, uniqueID);
    }

    public static String getUniqueID(Context context) {
        String uniqueID = OPGPreference.getProperty(context, PREFERENCES_UNIQUE_ID, null);
        return uniqueID;
    }

    public static void setDownloadURL(String downloadUrl, Context context) {
        OPGPreference.setProperty(context, PREFERENCES_DOWNLOAD_URL, downloadUrl);
    }

    public static String getDownloadURL(Context context) {
        String downloadUrl = OPGPreference.getProperty(context, PREFERENCES_DOWNLOAD_URL, null);
        return downloadUrl;
    }

    public static void clearOPGPreference(Context context) {
        context.getSharedPreferences(PREFS_NAME, 0).edit().clear().apply();
        context.getSharedPreferences(OPG_GEOFENCE_PREF, 0).edit().clear().apply();
    }

    public static void setMySurevyAppAdminName(Context context, String name) {
        OPGPreference.setProperty(context, PREFS_MYSURVEY_APP_ADMIN_NAME, name);
    }

    public static String getMySurevyAppAdminName(Context context) {
        return OPGPreference.getProperty(context, PREFS_MYSURVEY_APP_ADMIN_NAME, null);
    }

    public static void setMySurevyAppSharedKey(Context context, String name) {
        OPGPreference.setProperty(context, PREFS_MYSURVEY_APP_SHARED_KEY, name);
    }

    public static String getMySurevyAppSharedKey(Context context) {
        return OPGPreference.getProperty(context, PREFS_MYSURVEY_APP_SHARED_KEY, null);
    }

    public static void setIsGeofencingTriggered(Context context, Boolean isGeoFencingTriggered) {
        OPGPreference.setProperty(context, PREFS_IS_GEOFENCING_TRIGGERED, isGeoFencingTriggered);
    }

    public static boolean getIsGeofencingTriggered(Context context) {
        return OPGPreference.getProperty(context, PREFS_IS_GEOFENCING_TRIGGERED, false);
    }

    public static void setIsAppDebugable(Context context, Boolean is_app_debugable) {
        OPGPreference.setProperty(context, IS_APP_DEBUGABLE, is_app_debugable);
    }

    public static boolean getIsAppDebugable(Context context) {
        return OPGPreference.getProperty(context, IS_APP_DEBUGABLE, false);
    }

    public static void setGeofencingSurveys(Context context, List<OPGGeofenceSurvey> surveyList) {
        Gson gson = new Gson();
        String json = gson.toJson(surveyList);
        OPGPreference.setProperty(context, PREFS_GEOFENCING_SURVEYS, json);
    }

    public static List<OPGGeofenceSurvey> getGeofencingSurveys(Context context) {
        ArrayList<OPGGeofenceSurvey> resultGeofenceSurveys = new ArrayList<OPGGeofenceSurvey>();
        String jsonString = OPGPreference.getProperty(context, PREFS_GEOFENCING_SURVEYS, null);
        if (jsonString != null) {
            Gson gson = new Gson();
            Type listType = new TypeToken<List<OPGGeofenceSurvey>>(){}.getType();
            return (List)gson.fromJson(jsonString, listType);
        }
        return resultGeofenceSurveys;
    }

    public static void setLoginType(Context context, int type) {
        OPGPreference.setProperty(context, LOGIN_TYPE, type);
    }

    public static int getLoginType(Context context) {
        return OPGPreference.getProperty(context, LOGIN_TYPE, -1);
    }

    public static void setFacebookToken(Context context, String token) {
        OPGPreference.setProperty(context, FACEBOOK_TOKEN, token);
    }

    public static String getFacebookToken(Context context) {
        return OPGPreference.getProperty(context, FACEBOOK_TOKEN, "");
    }

    public static void setGoogleToken(Context context, String token) {
        OPGPreference.setProperty(context, GOOGLE_TOKEN, token);
    }

    public static String getGoogleToken(Context context) {
        return OPGPreference.getProperty(context, GOOGLE_TOKEN, "");
    }

    public static void setAppLoginUsername(Context context, String token) {
        OPGPreference.setProperty(context, APP_LOGIN_USERNAME, token);
    }

    public static String getAppLoginUsername(Context context) {
        return OPGPreference.getProperty(context, APP_LOGIN_USERNAME, "");
    }

    public static void setAppLoginPassword(Context context, String token) {
        OPGPreference.setProperty(context, APP_LOGIN_PASSWORD, token);
    }

    public static String getAppLoginPassword(Context context) {
        return OPGPreference.getProperty(context, APP_LOGIN_PASSWORD, "");
    }

    public static void saveOPGGeofenceSurveys(Context context, List<OPGGeofenceSurvey> geofenceSurveys) {
        Gson gson = new Gson();
        JSONArray jsonArray = new JSONArray();
        for (OPGGeofenceSurvey opgGeofenceSurvey : geofenceSurveys) {
            try {
                JSONObject jsonObject = new JSONObject(gson.toJson((Object)opgGeofenceSurvey));
                jsonArray.put((Object)jsonObject);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        context.getSharedPreferences(OPG_GEOFENCE_PREF, 0).edit().putString(PREF_GEOFENCE_KEY, jsonArray.toString()).apply();
    }

    public static List<OPGGeofenceSurvey> getOPGGeofenceSurveys(Context context) {
        Gson gson = new Gson();
        ArrayList<OPGGeofenceSurvey> opgGeofenceSurveyList = new ArrayList<OPGGeofenceSurvey>();
        String jsonString = context.getSharedPreferences(OPG_GEOFENCE_PREF, 0).getString(PREF_GEOFENCE_KEY, "");
        if (jsonString.length() != 0) {
            try {
                JSONArray jsonArray = new JSONArray(jsonString);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    opgGeofenceSurveyList.add((OPGGeofenceSurvey)gson.fromJson(jsonObject.toString(), OPGGeofenceSurvey.class));
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return opgGeofenceSurveyList;
    }

    public static boolean clearOPGGeofenceSurveys(Context context) {
        return context.getSharedPreferences(OPG_GEOFENCE_PREF, 0).edit().clear().commit();
    }
}

