/*
 * Decompiled with CFR 0.152.
 */
package com.opg.sdk;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.location.LocationManager;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationServices;
import com.opg.sdk.OPGPreference;
import com.opg.sdk.exceptions.OPGException;
import com.opg.sdk.geofence.OPGGeofenceErrorMessages;
import com.opg.sdk.geofence.OPGGeofenceTransitionsIntentService;
import com.opg.sdk.geofence.OPGGeofenceTriggerEvents;
import com.opg.sdk.models.OPGGeofenceStatus;
import com.opg.sdk.models.OPGGeofenceSurvey;
import java.util.ArrayList;
import java.util.List;

class OPGGeofenceMonitor {
    private static OPGGeofenceMonitor opgGeofenceMonitor;
    private PendingIntent mGeofencePendingIntent;
    private OPGGeofenceTriggerEvents opgGeofenceTriggerEvents;

    public static OPGGeofenceMonitor getInstance() {
        if (opgGeofenceMonitor == null) {
            opgGeofenceMonitor = new OPGGeofenceMonitor();
        }
        return opgGeofenceMonitor;
    }

    private OPGGeofenceMonitor() {
    }

    private List<OPGGeofenceSurvey> getOpgGeofenceSurveyList(Context context) {
        return OPGPreference.getOPGGeofenceSurveys(context);
    }

    private void setOpgGeofenceSurveyList(Context context, List<OPGGeofenceSurvey> opgGeofenceSurveyList) {
        OPGPreference.clearOPGGeofenceSurveys(context);
        OPGPreference.saveOPGGeofenceSurveys(context, opgGeofenceSurveyList);
    }

    protected OPGGeofenceTriggerEvents getOpgGeofenceTriggerEvents() {
        return this.opgGeofenceTriggerEvents;
    }

    protected void setOpgGeofenceTriggerEvents(OPGGeofenceTriggerEvents opgGeofenceTriggerEvents) {
        this.opgGeofenceTriggerEvents = opgGeofenceTriggerEvents;
    }

    protected void startGeofencingMonitor(final Context mContext, GoogleApiClient googleApiClient, List<OPGGeofenceSurvey> opgGeofencesList, final OPGGeofenceTriggerEvents opgGeofenceTriggerEvents) throws OPGException {
        this.verifyGoogleApiClient(googleApiClient);
        ArrayList<OPGGeofenceSurvey> opgGeofenceSurveyList = new ArrayList();
        if (opgGeofenceTriggerEvents == null) {
            throw new OPGException(OPGGeofenceErrorMessages.OPGGFTRIGGEREVENTS_NULL);
        }
        if (!this.locationServicesEnabled(mContext)) {
            throw new OPGException(OPGGeofenceErrorMessages.LOCATIONSERVICES_NOTENABLED);
        }
        if (opgGeofencesList == null || opgGeofencesList.isEmpty()) {
            throw new OPGException(OPGGeofenceErrorMessages.GEOFENCES_SIZE);
        }
        try {
            this.opgGeofenceTriggerEvents = opgGeofenceTriggerEvents;
            opgGeofenceSurveyList = opgGeofencesList.size() > 100 ? opgGeofencesList.subList(0, 100) : opgGeofencesList;
            this.setOpgGeofenceSurveyList(mContext, opgGeofenceSurveyList);
            if (OPGPreference.getIsGeofencingTriggered(mContext)) {
                this.stopGeofencingMonitor(mContext, googleApiClient, opgGeofenceTriggerEvents);
            }
            LocationServices.GeofencingApi.addGeofences(googleApiClient, this.getGeofencingRequest(this.convertOPGObjectToGeofence(mContext)), this.getGeofencePendingIntent(mContext)).setResultCallback((ResultCallback)new ResultCallback<Status>(){

                public void onResult(@NonNull Status status) {
                    OPGGeofenceStatus opgGeofenceStatus = new OPGGeofenceStatus();
                    if (status.isSuccess()) {
                        OPGPreference.setIsGeofencingTriggered(mContext, true);
                        opgGeofenceStatus.setSuccess(true);
                        opgGeofenceStatus.setMessage("Successfully added geofence for monitoring");
                    } else {
                        opgGeofenceStatus.setSuccess(false);
                        opgGeofenceStatus.setMessage(OPGGeofenceErrorMessages.getErrorString(mContext, status.getStatusCode()));
                    }
                    opgGeofenceStatus.setMonitoring(OPGPreference.getIsGeofencingTriggered(mContext));
                    if (opgGeofenceTriggerEvents != null) {
                        opgGeofenceTriggerEvents.onResult(opgGeofenceStatus);
                    }
                }
            });
        }
        catch (SecurityException securityException) {
            this.logSecurityException(mContext, securityException);
            throw securityException;
        }
    }

    private List<Geofence> convertOPGObjectToGeofence(Context context) {
        List<OPGGeofenceSurvey> opgGeofenceSurveyList = this.getOpgGeofenceSurveyList(context);
        ArrayList<Geofence> geofenceList = new ArrayList<Geofence>();
        if (opgGeofenceSurveyList != null && !opgGeofenceSurveyList.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (OPGGeofenceSurvey entry : opgGeofenceSurveyList) {
                stringBuilder.setLength(0);
                stringBuilder.append(entry.getSurveyReference()).append("-").append(entry.getLatitude()).append("-").append(entry.getLongitude());
                geofenceList.add(new Geofence.Builder().setRequestId(stringBuilder.toString()).setCircularRegion(entry.getLatitude(), entry.getLongitude(), (float)entry.getRange()).setExpirationDuration(-1L).setTransitionTypes(3).build());
            }
        }
        return geofenceList;
    }

    protected void stopGeofencingMonitor(final Context mContext, GoogleApiClient googleApiClient, final OPGGeofenceTriggerEvents opgGeofenceTriggerEvents) throws OPGException {
        this.verifyGoogleApiClient(googleApiClient);
        try {
            this.opgGeofenceTriggerEvents = opgGeofenceTriggerEvents;
            LocationServices.GeofencingApi.removeGeofences(googleApiClient, this.getGeofencePendingIntent(mContext)).setResultCallback((ResultCallback)new ResultCallback<Status>(){

                public void onResult(@NonNull Status status) {
                    OPGGeofenceStatus opgGeofenceStatus = new OPGGeofenceStatus();
                    if (status.isSuccess()) {
                        OPGPreference.setIsGeofencingTriggered(mContext, false);
                        opgGeofenceStatus.setSuccess(true);
                        opgGeofenceStatus.setMessage("Successfully removed geofence from monitoring....");
                    } else {
                        opgGeofenceStatus.setSuccess(false);
                        opgGeofenceStatus.setMessage(OPGGeofenceErrorMessages.getErrorString(mContext, status.getStatusCode()));
                    }
                    opgGeofenceStatus.setMonitoring(OPGPreference.getIsGeofencingTriggered(mContext));
                    if (opgGeofenceTriggerEvents != null) {
                        opgGeofenceTriggerEvents.onResult(opgGeofenceStatus);
                    }
                }
            });
        }
        catch (SecurityException securityException) {
            this.logSecurityException(mContext, securityException);
        }
    }

    private GeofencingRequest getGeofencingRequest(List<Geofence> geofenceList) {
        GeofencingRequest.Builder builder = new GeofencingRequest.Builder();
        builder.setInitialTrigger(1);
        builder.addGeofences(geofenceList);
        return builder.build();
    }

    private void verifyGoogleApiClient(GoogleApiClient googleApiClient) throws OPGException {
        if (googleApiClient != null || !googleApiClient.isConnected()) {
            if (googleApiClient == null) {
                throw new OPGException(OPGGeofenceErrorMessages.GOOGLEAPICLIENT_NULL);
            }
            if (!googleApiClient.isConnected()) {
                throw new OPGException(OPGGeofenceErrorMessages.GOOGLEAPICLIENT_NOT_CONNECT);
            }
        }
    }

    private void logSecurityException(Context mContext, SecurityException securityException) {
        Log.e((String)mContext.getClass().getName(), (String)"Invalid location permission. You need to use ACCESS_FINE_LOCATION with geofences", (Throwable)securityException);
    }

    private PendingIntent getGeofencePendingIntent(Context mContext) {
        if (this.mGeofencePendingIntent != null) {
            return this.mGeofencePendingIntent;
        }
        Intent intent = new Intent(mContext, OPGGeofenceTransitionsIntentService.class);
        return PendingIntent.getService((Context)mContext, (int)0, (Intent)intent, (int)0x8000000);
    }

    private boolean locationServicesEnabled(Context mContext) {
        LocationManager lm = (LocationManager)mContext.getSystemService("location");
        boolean gps_enabled = false;
        boolean net_enabled = false;
        try {
            gps_enabled = lm.isProviderEnabled("gps");
        }
        catch (Exception ex) {
            Log.e((String)mContext.getPackageName(), (String)"Exception gps_enabled");
        }
        try {
            net_enabled = lm.isProviderEnabled("network");
        }
        catch (Exception ex) {
            Log.e((String)mContext.getPackageName(), (String)"Exception network_enabled");
        }
        return gps_enabled || net_enabled;
    }
}

