/*
 * Decompiled with CFR 0.152.
 */
package com.opg.sdk;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import com.allatori.annotations.DoNotRename;
import com.opg.sdk.OPGR;
import com.opg.sdk.exceptions.OPGException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaArgs;
import org.apache.cordova.CordovaPlugin;
import org.json.JSONException;
import org.json.JSONObject;

@DoNotRename
public class ImagePreviewPlugin
extends CordovaPlugin {
    Context context;
    CallbackContext callback;

    @DoNotRename
    public boolean execute(String action, CordovaArgs args, CallbackContext callbackContext) {
        this.context = this.cordova.getActivity();
        this.callback = callbackContext;
        try {
            JSONObject obj = args.getJSONObject(0);
            if (obj.get("path") != null) {
                String path = obj.get("path").toString();
                this.showImage(path);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.callback.error(e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.callback.error(e.getLocalizedMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.callback.error(e.getLocalizedMessage());
        }
        this.callback.success("Success");
        return true;
    }

    @DoNotRename
    private void showImage(String path) throws FileNotFoundException, Exception {
        final Dialog dialog = new Dialog(this.context);
        dialog.setContentView(OPGR.getId(this.context, "layout", "image_preview"));
        ImageView image = (ImageView)dialog.findViewById(OPGR.getId(this.context, "id", "image_preview_iopg"));
        Button ok = (Button)dialog.findViewById(OPGR.getId(this.context, "id", "ok_bopg"));
        image.setImageBitmap(BitmapFactory.decodeStream((InputStream)new FileInputStream(new File(path))));
        File imagePath = new File(path);
        if (imagePath.exists()) {
            BitmapFactory.Options bmOptions = new BitmapFactory.Options();
            Bitmap bitmap = BitmapFactory.decodeFile((String)imagePath.getAbsolutePath(), (BitmapFactory.Options)bmOptions);
            if (image != null) {
                image.setImageBitmap(bitmap);
            }
        } else {
            throw new OPGException("Caused by: Caused by:File not found");
        }
        dialog.show();
        dialog.show();
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog.dismiss();
            }
        });
    }
}

