/*
 * Decompiled with CFR 0.152.
 */
package OnePoint.dialogs;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import com.allatori.annotations.DoNotRename;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@DoNotRename
public class Notification
extends CordovaPlugin {
    public int confirmResult = -1;
    public ProgressDialog spinnerDialog = null;
    public ProgressDialog progressDialog = null;

    @DoNotRename
    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        if (this.cordova.getActivity().isFinishing()) {
            return true;
        }
        if (action.equals("beep")) {
            this.beep(args.getLong(0));
        } else {
            if (action.equals("alert")) {
                this.alert(args.getString(0), args.getString(1), args.getString(2), callbackContext);
                return true;
            }
            if (action.equals("confirm")) {
                this.confirm(args.getString(0), args.getString(1), args.getJSONArray(2), callbackContext);
                return true;
            }
            if (action.equals("prompt")) {
                this.prompt(args.getString(0), args.getString(1), args.getJSONArray(2), args.getString(3), callbackContext);
                return true;
            }
            if (action.equals("activityStart")) {
                this.activityStart(args.getString(0), args.getString(1));
            } else if (action.equals("activityStop")) {
                this.activityStop();
            } else if (action.equals("progressStart")) {
                this.progressStart(args.getString(0), args.getString(1));
            } else if (action.equals("progressValue")) {
                this.progressValue(args.getInt(0));
            } else if (action.equals("progressStop")) {
                this.progressStop();
            } else {
                return false;
            }
        }
        callbackContext.success();
        return true;
    }

    public void beep(final long count) {
        this.cordova.getThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                Uri ringtone = RingtoneManager.getDefaultUri((int)2);
                Ringtone notification = RingtoneManager.getRingtone((Context)Notification.this.cordova.getActivity().getBaseContext(), (Uri)ringtone);
                if (notification != null) {
                    for (long i = 0L; i < count; ++i) {
                        notification.play();
                        long timeout = 5000L;
                        while (notification.isPlaying() && timeout > 0L) {
                            timeout -= 100L;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }
            }
        });
    }

    public synchronized void alert(final String message, final String title, final String buttonLabel, final CallbackContext callbackContext) {
        final CordovaInterface cordova = this.cordova;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AlertDialog.Builder dlg = Notification.this.createDialog(cordova);
                dlg.setMessage((CharSequence)message);
                dlg.setTitle((CharSequence)title);
                dlg.setCancelable(true);
                dlg.setPositiveButton((CharSequence)buttonLabel, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, 0));
                    }
                });
                dlg.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        dialog.dismiss();
                        callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, 0));
                    }
                });
                Notification.this.changeTextDirection(dlg);
            }
        };
        this.cordova.getActivity().runOnUiThread(runnable);
    }

    public synchronized void confirm(final String message, final String title, final JSONArray buttonLabels, final CallbackContext callbackContext) {
        final CordovaInterface cordova = this.cordova;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AlertDialog.Builder dlg = Notification.this.createDialog(cordova);
                dlg.setMessage((CharSequence)message);
                dlg.setTitle((CharSequence)title);
                dlg.setCancelable(true);
                if (buttonLabels.length() > 0) {
                    try {
                        dlg.setNegativeButton((CharSequence)buttonLabels.getString(0), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, 1));
                            }
                        });
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                if (buttonLabels.length() > 1) {
                    try {
                        dlg.setNeutralButton((CharSequence)buttonLabels.getString(1), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, 2));
                            }
                        });
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                if (buttonLabels.length() > 2) {
                    try {
                        dlg.setPositiveButton((CharSequence)buttonLabels.getString(2), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, 3));
                            }
                        });
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                dlg.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        dialog.dismiss();
                        callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, 0));
                    }
                });
                Notification.this.changeTextDirection(dlg);
            }
        };
        this.cordova.getActivity().runOnUiThread(runnable);
    }

    public synchronized void prompt(final String message, final String title, final JSONArray buttonLabels, final String defaultText, final CallbackContext callbackContext) {
        final CordovaInterface cordova = this.cordova;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                final EditText promptInput = new EditText((Context)cordova.getActivity());
                promptInput.setHint((CharSequence)defaultText);
                AlertDialog.Builder dlg = Notification.this.createDialog(cordova);
                dlg.setMessage((CharSequence)message);
                dlg.setTitle((CharSequence)title);
                dlg.setCancelable(true);
                dlg.setView((View)promptInput);
                final JSONObject result = new JSONObject();
                if (buttonLabels.length() > 0) {
                    try {
                        dlg.setNegativeButton((CharSequence)buttonLabels.getString(0), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                                try {
                                    result.put("buttonIndex", 1);
                                    result.put("input1", (Object)(promptInput.getText().toString().trim().length() == 0 ? defaultText : promptInput.getText()));
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                }
                                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, result));
                            }
                        });
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                if (buttonLabels.length() > 1) {
                    try {
                        dlg.setNeutralButton((CharSequence)buttonLabels.getString(1), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                                try {
                                    result.put("buttonIndex", 2);
                                    result.put("input1", (Object)(promptInput.getText().toString().trim().length() == 0 ? defaultText : promptInput.getText()));
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                }
                                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, result));
                            }
                        });
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                if (buttonLabels.length() > 2) {
                    try {
                        dlg.setPositiveButton((CharSequence)buttonLabels.getString(2), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                                try {
                                    result.put("buttonIndex", 3);
                                    result.put("input1", (Object)(promptInput.getText().toString().trim().length() == 0 ? defaultText : promptInput.getText()));
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                }
                                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, result));
                            }
                        });
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                dlg.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        dialog.dismiss();
                        try {
                            result.put("buttonIndex", 0);
                            result.put("input1", (Object)(promptInput.getText().toString().trim().length() == 0 ? defaultText : promptInput.getText()));
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                        callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, result));
                    }
                });
                Notification.this.changeTextDirection(dlg);
            }
        };
        this.cordova.getActivity().runOnUiThread(runnable);
    }

    public synchronized void activityStart(final String title, final String message) {
        if (this.spinnerDialog != null) {
            this.spinnerDialog.dismiss();
            this.spinnerDialog = null;
        }
        final Notification notification = this;
        final CordovaInterface cordova = this.cordova;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                notification.spinnerDialog = Notification.this.createProgressDialog(cordova);
                notification.spinnerDialog.setTitle((CharSequence)title);
                notification.spinnerDialog.setMessage((CharSequence)message);
                notification.spinnerDialog.setCancelable(true);
                notification.spinnerDialog.setIndeterminate(true);
                notification.spinnerDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        notification.spinnerDialog = null;
                    }
                });
                notification.spinnerDialog.show();
            }
        };
        this.cordova.getActivity().runOnUiThread(runnable);
    }

    public synchronized void activityStop() {
        if (this.spinnerDialog != null) {
            this.spinnerDialog.dismiss();
            this.spinnerDialog = null;
        }
    }

    public synchronized void progressStart(final String title, final String message) {
        if (this.progressDialog != null) {
            this.progressDialog.dismiss();
            this.progressDialog = null;
        }
        final Notification notification = this;
        final CordovaInterface cordova = this.cordova;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                notification.progressDialog = Notification.this.createProgressDialog(cordova);
                notification.progressDialog.setProgressStyle(1);
                notification.progressDialog.setTitle((CharSequence)title);
                notification.progressDialog.setMessage((CharSequence)message);
                notification.progressDialog.setCancelable(true);
                notification.progressDialog.setMax(100);
                notification.progressDialog.setProgress(0);
                notification.progressDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        notification.progressDialog = null;
                    }
                });
                notification.progressDialog.show();
            }
        };
        this.cordova.getActivity().runOnUiThread(runnable);
    }

    public synchronized void progressValue(int value) {
        if (this.progressDialog != null) {
            this.progressDialog.setProgress(value);
        }
    }

    public synchronized void progressStop() {
        if (this.progressDialog != null) {
            this.progressDialog.dismiss();
            this.progressDialog = null;
        }
    }

    @SuppressLint(value={"NewApi"})
    private AlertDialog.Builder createDialog(CordovaInterface cordova) {
        int currentapiVersion = Build.VERSION.SDK_INT;
        if (currentapiVersion >= 11) {
            return new AlertDialog.Builder((Context)cordova.getActivity(), 5);
        }
        return new AlertDialog.Builder((Context)cordova.getActivity());
    }

    @SuppressLint(value={"InlinedApi"})
    private ProgressDialog createProgressDialog(CordovaInterface cordova) {
        int currentapiVersion = Build.VERSION.SDK_INT;
        if (currentapiVersion >= 14) {
            return new ProgressDialog((Context)cordova.getActivity(), 5);
        }
        return new ProgressDialog((Context)cordova.getActivity());
    }

    @SuppressLint(value={"NewApi"})
    private void changeTextDirection(AlertDialog.Builder dlg) {
        int currentapiVersion = Build.VERSION.SDK_INT;
        dlg.create();
        AlertDialog dialog = dlg.show();
        if (currentapiVersion >= 17) {
            TextView messageview = (TextView)dialog.findViewById(16908299);
            messageview.setTextDirection(5);
        }
    }
}

