/*
 * Decompiled with CFR 0.152.
 */
package OnePoint.CordovaPlugin.Utils;

import OnePoint.Common.Utils;
import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.webkit.MimeTypeMap;
import com.allatori.annotations.DoNotRename;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.Locale;
import org.json.JSONObject;

@DoNotRename
public class FileUtils {
    public static final String HIDDEN_PREFIX = ".";
    static final String TAG = "FileUtils";
    private static final String MEDIAID = "MediaID";
    @DoNotRename
    public static Comparator<File> sComparator = new Comparator<File>(){

        @Override
        public int compare(File f1, File f2) {
            return f1.getName().toLowerCase(Locale.US).compareTo(f2.getName().toLowerCase(Locale.US));
        }
    };
    @DoNotRename
    public static FileFilter sFileFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            String fileName = file.getName();
            return file.isFile() && !fileName.startsWith(FileUtils.HIDDEN_PREFIX);
        }
    };
    @DoNotRename
    public static FileFilter sDirFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            String fileName = file.getName();
            return file.isDirectory() && !fileName.startsWith(FileUtils.HIDDEN_PREFIX);
        }
    };

    private FileUtils() {
    }

    @DoNotRename
    public static String getExtension(String uri) {
        if (uri == null) {
            return null;
        }
        int dot = uri.lastIndexOf(HIDDEN_PREFIX);
        if (dot >= 0) {
            return uri.substring(dot);
        }
        return "";
    }

    @DoNotRename
    public static String getJSONPathObj(String path) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("path", (Object)path);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jsonObject.toString();
    }

    @DoNotRename
    public static String getJSONMediaPathObj(String mediaID, String path) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(MEDIAID, (Object)mediaID);
            jsonObject.put("path", (Object)path);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jsonObject.toString();
    }

    @DoNotRename
    public static boolean isLocal(String url) {
        return url != null && !url.startsWith("http://") && !url.startsWith("https://");
    }

    @DoNotRename
    public static boolean isMediaUri(Uri uri) {
        return "media".equalsIgnoreCase(uri.getAuthority());
    }

    @DoNotRename
    public static Uri getUri(File file) {
        if (file != null) {
            return Uri.fromFile((File)file);
        }
        return null;
    }

    @DoNotRename
    public static File getPathWithoutFilename(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return file;
            }
            String filename = file.getName();
            String filepath = file.getAbsolutePath();
            String pathwithoutname = filepath.substring(0, filepath.length() - filename.length());
            if (pathwithoutname.endsWith("\"")) {
                pathwithoutname = pathwithoutname.substring(0, pathwithoutname.length() - 1);
            }
            return new File(pathwithoutname);
        }
        return null;
    }

    @DoNotRename
    public static String getMimeType(File file) {
        String extension = FileUtils.getExtension(file.getName());
        if (extension.length() > 0) {
            return MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension.substring(1));
        }
        return "application/octet-stream";
    }

    @DoNotRename
    public static String getMimeType(Context context, Uri uri) {
        File file = new File(FileUtils.getPath(context, uri));
        return FileUtils.getMimeType(file);
    }

    @DoNotRename
    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    @DoNotRename
    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    @DoNotRename
    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotRename
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                String path = cursor.getString(column_index);
                if (path == null) {
                    String filename;
                    File saveFile;
                    InputStream ist = context.getContentResolver().openInputStream(uri);
                    File vitaccessMediaDir = new File(Environment.getExternalStorageDirectory() + File.separator + Utils.getApplicationName(context) + File.separator + "media" + "/");
                    File vitaccessMediaImageDir = new File(vitaccessMediaDir + "/Opg_Image/");
                    if (!vitaccessMediaImageDir.exists()) {
                        vitaccessMediaImageDir.mkdir();
                    }
                    String format = String.format(Locale.ENGLISH, "%%0%dd", 3);
                    while ((saveFile = new File(vitaccessMediaImageDir, filename = "image_capture_" + String.format(Locale.ENGLISH, format, System.currentTimeMillis() / 1000L) + ".jpeg")).exists()) {
                    }
                    FileUtils.copyToFile(ist, saveFile);
                    String string = saveFile.getAbsolutePath();
                    return string;
                }
                String string = path;
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyToFile(InputStream inputStream, File destFile) {
        if (inputStream == null || destFile == null) {
            return false;
        }
        try {
            try (FileOutputStream out = new FileOutputStream(destFile);){
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = inputStream.read(buffer)) >= 0) {
                    ((OutputStream)out).write(buffer, 0, bytesRead);
                }
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @TargetApi(value=19)
    @DoNotRename
    public static String getPath(Context context, Uri uri) {
        boolean isKitKat;
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (FileUtils.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "\"" + split[1];
                }
            } else {
                if (FileUtils.isDownloadsDocument(uri)) {
                    String id = DocumentsContract.getDocumentId((Uri)uri);
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id));
                    return FileUtils.getDataColumn(context, contentUri, null, null);
                }
                if (FileUtils.isMediaDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return FileUtils.getDataColumn(context, contentUri, "_id=?", selectionArgs);
                }
            }
        } else {
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                return FileUtils.getDataColumn(context, uri, null, null);
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        return null;
    }

    @DoNotRename
    public static File getFile(Context context, Uri uri) {
        String path;
        if (uri != null && (path = FileUtils.getPath(context, uri)) != null && FileUtils.isLocal(path)) {
            return new File(path);
        }
        return null;
    }

    @DoNotRename
    public static String getReadableFileSize(int size) {
        int BYTES_IN_KILOBYTES = 1024;
        DecimalFormat dec = new DecimalFormat("###.#");
        String KILOBYTES = " KB";
        String MEGABYTES = " MB";
        String GIGABYTES = " GB";
        float fileSize = 0.0f;
        String suffix = " KB";
        if (size > 1024 && (fileSize = (float)(size / 1024)) > 1024.0f) {
            if ((fileSize /= 1024.0f) > 1024.0f) {
                fileSize /= 1024.0f;
                suffix = " GB";
            } else {
                suffix = " MB";
            }
        }
        return String.valueOf(dec.format(fileSize) + suffix);
    }

    @DoNotRename
    public static Bitmap getThumbnail(Context context, File file) {
        return FileUtils.getThumbnail(context, FileUtils.getUri(file), FileUtils.getMimeType(file));
    }

    @DoNotRename
    public static Bitmap getThumbnail(Context context, Uri uri) {
        return FileUtils.getThumbnail(context, uri, FileUtils.getMimeType(context, uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotRename
    public static Bitmap getThumbnail(Context context, Uri uri, String mimeType) {
        if (!FileUtils.isMediaUri(uri)) {
            return null;
        }
        Bitmap bm = null;
        if (uri != null) {
            ContentResolver resolver = context.getContentResolver();
            try (Cursor cursor = null;){
                cursor = resolver.query(uri, null, null, null, null);
                if (cursor.moveToFirst()) {
                    int id = cursor.getInt(0);
                    if (mimeType.contains("video/")) {
                        bm = MediaStore.Video.Thumbnails.getThumbnail((ContentResolver)resolver, (long)id, (int)1, null);
                    } else if (mimeType.contains("image/*")) {
                        bm = MediaStore.Images.Thumbnails.getThumbnail((ContentResolver)resolver, (long)id, (int)1, null);
                    }
                }
            }
        }
        return bm;
    }

    @DoNotRename
    public static Intent createGetContentIntent() {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("*/*");
        intent.addCategory("android.intent.category.OPENABLE");
        return intent;
    }

    @DoNotRename
    public static byte[] convertFileToByteArray(File f) throws FileNotFoundException {
        FileInputStream fis = new FileInputStream(f);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int readNum;
            while ((readNum = fis.read(buf)) != -1) {
                bos.write(buf, 0, readNum);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        byte[] byteArray = bos.toByteArray();
        return byteArray;
    }

    @DoNotRename
    public static long getFileSize(String filePath) {
        File f = new File(filePath);
        if (f.exists()) {
            return f.length();
        }
        return 0L;
    }
}

