/*
 * Decompiled with CFR 0.152.
 */
package OnePoint.Common;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import com.allatori.annotations.DoNotRename;
import com.opg.sdk.OPGSDKConstant;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

@DoNotRename
public class Utils {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.UK);
    private static DateFormat iso = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    @DoNotRename
    public static String getCurrentDate() {
        return dateFormat.format(new Date());
    }

    @DoNotRename
    public static String convertToUTCFromDate(Date date) {
        return dateFormat.format(date);
    }

    @DoNotRename
    public static String convertToISOFromDate(Date date) {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        iso.setTimeZone(utc);
        Date today = new Date();
        SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
        String date2 = DATE_FORMAT.format(date);
        return date2;
    }

    @DoNotRename
    public static Date convertToDateFromUTC(String dateString) {
        dateString = dateString.replace("T", " ");
        Date date = null;
        try {
            date = dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    @DoNotRename
    public static String getApplicationName(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        int stringId = applicationInfo.labelRes;
        String appName = stringId == 0 ? applicationInfo.nonLocalizedLabel.toString() : context.getString(stringId);
        appName = appName.replaceAll("\n", "");
        appName = appName.replaceAll("\r", "");
        appName = appName.replaceAll(OPGSDKConstant.OPEN_BRACE1_KEY, "");
        appName = appName.replaceAll(OPGSDKConstant.CLOSE_BRACE1_KEY, "");
        appName = appName.replaceAll(OPGSDKConstant.OPEN_BRACE2_KEY, "");
        appName = appName.replaceAll(OPGSDKConstant.CLOSE_BRACE2_KEY, "");
        appName = appName.replaceAll(OPGSDKConstant.OPEN_BRACE3_KEY, "");
        appName = appName.replaceAll(OPGSDKConstant.CLOSE_BRACE3_KEY, "");
        appName = appName.replaceAll(" ", "");
        appName = appName.replaceAll("/", "");
        appName = appName.replaceAll(OPGSDKConstant.BACKSLASH_KEY, "");
        appName = appName.replaceAll(", ".trim(), "");
        appName = appName.replaceAll(":", "");
        appName = appName.replaceAll("-", "");
        appName = appName.replaceAll(";", "");
        appName = appName.replaceAll("'", "");
        appName = appName.replaceAll(OPGSDKConstant.AMP_KEY, "");
        appName = appName.replaceAll(OPGSDKConstant.CAP_KEY, "");
        appName = appName.replaceAll(OPGSDKConstant.QUE_KEY, "");
        appName = appName.replaceAll(OPGSDKConstant.PIPE_KEY, "");
        appName = appName.replaceAll(OPGSDKConstant.PLUS_KEY, "");
        appName = appName.replaceAll(OPGSDKConstant.ASTERIC_KEY, "");
        appName = appName.replaceAll(OPGSDKConstant.DOT_KEY_KEY, "");
        return appName;
    }
}

