/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.cordova.Config;
import org.apache.cordova.ConfigXmlParser;
import org.apache.cordova.CordovaInterfaceImpl;
import org.apache.cordova.CordovaPreferences;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.CordovaWebViewEngine;
import org.apache.cordova.CordovaWebViewImpl;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginEntry;
import org.apache.cordova.PluginManager;
import org.apache.cordova.engine.SystemWebViewClient;
import org.apache.cordova.engine.SystemWebViewEngine;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressLint(value={"InlinedApi", "NewApi"})
public class OPGBaseActivity
extends Activity {
    public static String TAG = "OPGActivity";
    protected CordovaWebView appView;
    protected boolean keepRunning = true;
    public boolean enableBackButton = true;
    protected boolean immersiveMode;
    protected CordovaPreferences preferences;
    protected String launchUrl;
    protected ArrayList<PluginEntry> pluginEntries;
    protected CordovaInterfaceImpl cordovaInterface;

    public void onCreate(Bundle savedInstanceState) {
        LOG.i(TAG, "Apache Cordova native platform version 5.1.1 is starting");
        LOG.d(TAG, "OPGActivity.onCreate()");
        this.loadConfig();
        if (!this.preferences.getBoolean("ShowTitle", false)) {
            this.getWindow().requestFeature(1);
        }
        if (this.preferences.getBoolean("SetFullscreen", false)) {
            Log.d((String)TAG, (String)"The SetFullscreen configuration is deprecated in favor of Fullscreen, and will be removed in a future version.");
            this.preferences.set("Fullscreen", true);
        }
        if (this.preferences.getBoolean("Fullscreen", false)) {
            if (Build.VERSION.SDK_INT >= 19) {
                this.immersiveMode = true;
            } else {
                this.getWindow().setFlags(1024, 1024);
            }
        } else {
            this.getWindow().setFlags(2048, 2048);
        }
        super.onCreate(savedInstanceState);
        this.cordovaInterface = this.makeCordovaInterface();
        if (savedInstanceState != null) {
            this.cordovaInterface.restoreInstanceState(savedInstanceState);
        }
    }

    protected void init() {
        this.appView = this.makeWebView();
        this.createViews();
        if (!this.appView.isInitialized()) {
            this.appView.init(this.cordovaInterface, this.pluginEntries, this.preferences);
        }
        ((WebView)this.appView.getView()).setWebViewClient((WebViewClient)new SystemWebViewClient((SystemWebViewEngine)this.appView.getEngine()){

            @Override
            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                if (url.contains("status=3")) {
                    view.stopLoading();
                    OPGBaseActivity.this.onSurveyCompleted();
                } else {
                    super.onPageStarted(view, url, favicon);
                    OPGBaseActivity.this.onQuestionStartLoading();
                }
            }

            @Override
            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                OPGBaseActivity.this.onQuestionStopLoading();
            }

            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                return super.shouldOverrideUrlLoading(view, url);
            }
        });
        this.cordovaInterface.onCordovaInit(this.appView.getPluginManager());
        String volumePref = this.preferences.getString("DefaultVolumeStream", "");
        if ("media".equals(volumePref.toLowerCase(Locale.ENGLISH))) {
            this.setVolumeControlStream(3);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            ((WebView)this.appView.getView()).getSettings().setMixedContentMode(2);
        }
    }

    protected void onQuestionStartLoading() {
    }

    protected void onQuestionStopLoading() {
    }

    protected void onSurveyCompleted() {
        this.finish();
    }

    protected void loadConfig() {
        ConfigXmlParser parser = new ConfigXmlParser();
        parser.parse((Context)this);
        this.preferences = parser.getPreferences();
        this.preferences.setPreferencesBundle(this.getIntent().getExtras());
        this.launchUrl = parser.getLaunchUrl();
        this.pluginEntries = parser.getPluginEntries();
        Config.parser = parser;
    }

    protected void createViews() {
        this.appView.getView().setId(100);
        this.appView.getView().setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.setContentView(this.appView.getView());
        if (this.preferences.contains("BackgroundColor")) {
            int backgroundColor = this.preferences.getInteger("BackgroundColor", -16777216);
            this.appView.getView().setBackgroundColor(backgroundColor);
        }
        this.appView.getView().requestFocusFromTouch();
    }

    protected CordovaWebView makeWebView() {
        return new CordovaWebViewImpl(this.makeWebViewEngine());
    }

    protected CordovaWebViewEngine makeWebViewEngine() {
        return CordovaWebViewImpl.createEngine((Context)this, this.preferences);
    }

    protected CordovaInterfaceImpl makeCordovaInterface() {
        return new CordovaInterfaceImpl(this){

            @Override
            public Object onMessage(String id2, Object data) {
                return OPGBaseActivity.this.onMessage(id2, data);
            }
        };
    }

    public void loadUrl(String url) {
        if (this.appView == null) {
            this.init();
        }
        this.keepRunning = this.preferences.getBoolean("KeepRunning", true);
        this.appView.loadUrlIntoView(url, true);
    }

    protected void onPause() {
        super.onPause();
        LOG.d(TAG, "OPGBaseActivity is paused.");
        if (this.appView != null) {
            boolean keepRunning = this.keepRunning || this.cordovaInterface.activityResultCallback != null;
            this.appView.handlePause(keepRunning);
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (this.appView != null) {
            this.appView.onNewIntent(intent);
        }
    }

    protected void onResume() {
        super.onResume();
        LOG.d(TAG, "OPGBaseActivity is resumed.");
        if (this.appView == null) {
            return;
        }
        this.getWindow().getDecorView().requestFocus();
        this.appView.handleResume(this.keepRunning);
    }

    protected void onStop() {
        super.onStop();
        LOG.d(TAG, "OPGBaseActivity is stopped.");
        if (this.appView == null) {
            return;
        }
        this.appView.handleStop();
    }

    protected void onStart() {
        super.onStart();
        LOG.d(TAG, "OPGBaseActivity is started.");
        if (this.appView == null) {
            return;
        }
        this.appView.handleStart();
    }

    public void onDestroy() {
        LOG.d(TAG, "OPGBaseActivity.onDestroy()");
        super.onDestroy();
        if (this.appView != null) {
            this.appView.handleDestroy();
        }
        this.appView = null;
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (hasFocus && this.immersiveMode) {
            int uiOptions = 5894;
            this.getWindow().getDecorView().setSystemUiVisibility(5894);
        }
    }

    @SuppressLint(value={"NewApi"})
    public void startActivityForResult(Intent intent, int requestCode, Bundle options) {
        try {
            this.cordovaInterface.setActivityResultRequestCode(requestCode);
            super.startActivityForResult(intent, requestCode, options);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        LOG.d(TAG, "Incoming Result. Request code = " + requestCode);
        super.onActivityResult(requestCode, resultCode, intent);
        this.cordovaInterface.onActivityResult(requestCode, resultCode, intent);
    }

    public void onReceivedError(int errorCode, final String description, final String failingUrl) {
        final OPGBaseActivity me = this;
        final String errorUrl = this.preferences.getString("errorUrl", null);
        if (errorUrl != null && !failingUrl.equals(errorUrl) && this.appView != null) {
            me.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    me.appView.showWebPage(errorUrl, false, true, null);
                }
            });
        } else {
            final boolean exit = errorCode != -2;
            me.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (exit) {
                        me.appView.getView().setVisibility(8);
                        me.displayError("Application Error 123", description + " (" + failingUrl + ")", "OK", exit);
                    }
                }
            });
        }
    }

    public void displayError(final String title, final String message, final String button, final boolean exit) {
        final OPGBaseActivity me = this;
        me.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    AlertDialog.Builder dlg = new AlertDialog.Builder((Context)me);
                    dlg.setMessage((CharSequence)message);
                    dlg.setTitle((CharSequence)title);
                    dlg.setCancelable(false);
                    dlg.setPositiveButton((CharSequence)button, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                            if (exit) {
                                OPGBaseActivity.this.finish();
                            }
                        }
                    });
                    dlg.create();
                    dlg.show();
                }
                catch (Exception e) {
                    OPGBaseActivity.this.finish();
                }
            }
        });
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        if (this.appView != null) {
            this.appView.getPluginManager().postMessage("onCreateOptionsMenu", menu);
        }
        return super.onCreateOptionsMenu(menu);
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        if (this.appView != null) {
            this.appView.getPluginManager().postMessage("onPrepareOptionsMenu", menu);
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (this.appView != null) {
            this.appView.getPluginManager().postMessage("onOptionsItemSelected", item);
        }
        return true;
    }

    public Object onMessage(String id2, Object data) {
        if ("onReceivedError".equals(id2)) {
            JSONObject d = (JSONObject)data;
            try {
                this.onReceivedError(d.getInt("errorCode"), d.getString("description"), d.getString("url"));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else if ("exit".equals(id2)) {
            this.finish();
        }
        return null;
    }

    protected void onSaveInstanceState(Bundle outState) {
        this.cordovaInterface.onSaveInstanceState(outState);
        super.onSaveInstanceState(outState);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.appView == null) {
            return;
        }
        PluginManager pm = this.appView.getPluginManager();
        if (pm != null) {
            pm.onConfigurationChanged(newConfig);
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        try {
            this.cordovaInterface.onRequestPermissionResult(requestCode, permissions, grantResults);
        }
        catch (JSONException e) {
            LOG.d(TAG, "JSONException: Parameters fed into the method are not valid");
            e.printStackTrace();
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
    }
}

