/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc.voiceengine;

import android.annotation.TargetApi;
import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Process;
import android.support.annotation.Nullable;
import java.nio.ByteBuffer;
import org.otwebrtc.ContextUtils;
import org.otwebrtc.Logging;
import org.otwebrtc.ThreadUtils;
import org.otwebrtc.voiceengine.WebRtcAudioUtils;

public class WebRtcAudioTrack {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioTrack";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final long AUDIO_TRACK_THREAD_JOIN_TIMEOUT_MS = 2000L;
    private static final int DEFAULT_USAGE;
    private static int usageAttribute;
    private static volatile boolean speakerMute;
    @Nullable
    private static WebRtcAudioTrackErrorCallback errorCallbackOld;
    @Nullable
    private static ErrorCallback errorCallback;
    private final long nativeAudioTrack;
    private final AudioManager audioManager;
    private final ThreadUtils.ThreadChecker threadChecker;
    private ByteBuffer byteBuffer;
    @Nullable
    private AudioTrack audioTrack;
    @Nullable
    private AudioTrackThread audioThread;
    private byte[] emptyBytes;

    public static synchronized void setAudioTrackUsageAttribute(int n) {
        Logging.w(TAG, "Default usage attribute is changed from: " + DEFAULT_USAGE + " to " + n);
        usageAttribute = n;
    }

    private static int getDefaultUsageAttribute() {
        if (Build.VERSION.SDK_INT >= 21) {
            return 2;
        }
        return 0;
    }

    @Deprecated
    public static void setErrorCallback(WebRtcAudioTrackErrorCallback webRtcAudioTrackErrorCallback) {
        Logging.d(TAG, "Set error callback (deprecated");
        errorCallbackOld = webRtcAudioTrackErrorCallback;
    }

    public static void setErrorCallback(ErrorCallback errorCallback) {
        Logging.d(TAG, "Set extended error callback");
        WebRtcAudioTrack.errorCallback = errorCallback;
    }

    WebRtcAudioTrack(long l) {
        WebRtcAudioTrack webRtcAudioTrack = this;
        this.threadChecker = new ThreadUtils.ThreadChecker();
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
        webRtcAudioTrack.nativeAudioTrack = l;
        webRtcAudioTrack.audioManager = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean initPlayout(int n, int n2, double d2) {
        block7: {
            AudioTrack audioTrack;
            WebRtcAudioTrack webRtcAudioTrack = this;
            this.threadChecker.checkIsOnValidThread();
            Logging.d(TAG, "initPlayout(sampleRate=" + n + ", channels=" + n2 + ", bufferSizeFactor=" + d2 + ")");
            webRtcAudioTrack.byteBuffer = ByteBuffer.allocateDirect(n2 * 2 * (n / 100));
            Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
            webRtcAudioTrack.emptyBytes = new byte[webRtcAudioTrack.byteBuffer.capacity()];
            ByteBuffer byteBuffer = webRtcAudioTrack.byteBuffer;
            long l = webRtcAudioTrack.nativeAudioTrack;
            webRtcAudioTrack.nativeCacheDirectBufferAddress(byteBuffer, l);
            int n3 = this.channelCountToConfiguration(n2);
            int n4 = (int)((double)AudioTrack.getMinBufferSize((int)n, (int)n3, (int)2) * d2);
            Logging.d(TAG, "minBufferSizeInBytes: " + n4);
            if (n4 < this.byteBuffer.capacity()) {
                this.reportWebRtcAudioTrackInitError("AudioTrack.getMinBufferSize returns an invalid value.");
                return false;
            }
            if (this.audioTrack != null) {
                this.reportWebRtcAudioTrackInitError("Conflict with existing AudioTrack.");
                return false;
            }
            try {
                AudioTrack audioTrack2;
                WebRtcAudioTrack webRtcAudioTrack2;
                if (Build.VERSION.SDK_INT >= 21) {
                    webRtcAudioTrack2 = this;
                    audioTrack2 = WebRtcAudioTrack.createAudioTrackOnLollipopOrHigher(n, n3, n4);
                } else {
                    webRtcAudioTrack2 = this;
                    audioTrack2 = WebRtcAudioTrack.createAudioTrackOnLowerThanLollipop(n, n3, n4);
                }
                webRtcAudioTrack2.audioTrack = audioTrack2;
                audioTrack = this.audioTrack;
                if (audioTrack == null) break block7;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string = illegalArgumentException.getMessage();
                WebRtcAudioTrack webRtcAudioTrack3 = this;
                webRtcAudioTrack3.reportWebRtcAudioTrackInitError(string);
                webRtcAudioTrack3.releaseAudioResources();
                return false;
            }
            if (audioTrack.getState() == 1) {
                WebRtcAudioTrack webRtcAudioTrack4 = this;
                webRtcAudioTrack4.logMainParameters();
                webRtcAudioTrack4.logMainParametersExtended();
                return true;
            }
        }
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.reportWebRtcAudioTrackInitError("Initialization of audio track failed.");
        webRtcAudioTrack.releaseAudioResources();
        return false;
    }

    private boolean startPlayout() {
        AudioTrackThread audioTrackThread;
        block2: {
            WebRtcAudioTrack webRtcAudioTrack;
            WebRtcAudioTrack webRtcAudioTrack2 = this;
            webRtcAudioTrack2.threadChecker.checkIsOnValidThread();
            Logging.d(TAG, "startPlayout");
            WebRtcAudioTrack.assertTrue(webRtcAudioTrack2.audioTrack != null);
            WebRtcAudioTrack.assertTrue(this.audioThread == null);
            try {
                WebRtcAudioTrack webRtcAudioTrack3 = this;
                webRtcAudioTrack3.audioTrack.play();
                if (webRtcAudioTrack3.audioTrack.getPlayState() == 3) break block2;
                webRtcAudioTrack = this;
            }
            catch (IllegalStateException illegalStateException) {
                WebRtcAudioTrack webRtcAudioTrack4 = this;
                webRtcAudioTrack4.reportWebRtcAudioTrackStartError(AudioTrackStartErrorCode.AUDIO_TRACK_START_EXCEPTION, "AudioTrack.play failed: " + illegalStateException.getMessage());
                webRtcAudioTrack4.releaseAudioResources();
                return false;
            }
            webRtcAudioTrack.reportWebRtcAudioTrackStartError(AudioTrackStartErrorCode.AUDIO_TRACK_START_STATE_MISMATCH, "AudioTrack.play failed - incorrect state :" + this.audioTrack.getPlayState());
            webRtcAudioTrack.releaseAudioResources();
            return false;
        }
        AudioTrackThread audioTrackThread2 = audioTrackThread;
        audioTrackThread2("AudioTrackJavaThread");
        this.audioThread = audioTrackThread2;
        audioTrackThread.start();
        return true;
    }

    private boolean stopPlayout() {
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "stopPlayout");
        WebRtcAudioTrack.assertTrue(webRtcAudioTrack.audioThread != null);
        WebRtcAudioTrack webRtcAudioTrack2 = this;
        webRtcAudioTrack2.logUnderrunCount();
        webRtcAudioTrack2.audioThread.stopThread();
        Logging.d(TAG, "Stopping the AudioTrackThread...");
        webRtcAudioTrack2.audioThread.interrupt();
        if (!ThreadUtils.joinUninterruptibly(webRtcAudioTrack2.audioThread, 2000L)) {
            Logging.e(TAG, "Join of AudioTrackThread timed out.");
            WebRtcAudioUtils.logAudioState(TAG);
        }
        Logging.d(TAG, "AudioTrackThread has now been stopped.");
        this.audioThread = null;
        this.releaseAudioResources();
        return true;
    }

    private int getStreamMaxVolume() {
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "getStreamMaxVolume");
        WebRtcAudioTrack.assertTrue(webRtcAudioTrack.audioManager != null);
        return this.audioManager.getStreamMaxVolume(0);
    }

    private boolean setStreamVolume(int n) {
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "setStreamVolume(" + n + ")");
        WebRtcAudioTrack.assertTrue(webRtcAudioTrack.audioManager != null);
        if (this.isVolumeFixed()) {
            Logging.e(TAG, "The device implements a fixed volume policy.");
            return false;
        }
        this.audioManager.setStreamVolume(0, n, 0);
        return true;
    }

    private boolean isVolumeFixed() {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        return this.audioManager.isVolumeFixed();
    }

    private int getStreamVolume() {
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "getStreamVolume");
        WebRtcAudioTrack.assertTrue(webRtcAudioTrack.audioManager != null);
        return this.audioManager.getStreamVolume(0);
    }

    private void logMainParameters() {
        Logging.d(TAG, "AudioTrack: session ID: " + this.audioTrack.getAudioSessionId() + ", channels: " + this.audioTrack.getChannelCount() + ", sample rate: " + this.audioTrack.getSampleRate() + ", max gain: " + AudioTrack.getMaxVolume());
    }

    @TargetApi(value=21)
    private static AudioTrack createAudioTrackOnLollipopOrHigher(int n, int n2, int n3) {
        Logging.d(TAG, "createAudioTrackOnLollipopOrHigher");
        int n4 = AudioTrack.getNativeOutputSampleRate((int)0);
        Logging.d(TAG, "nativeOutputSampleRate: " + n4);
        if (n != n4) {
            Logging.w(TAG, "Unable to use fast mode since requested sample rate is not native");
        }
        if (usageAttribute != DEFAULT_USAGE) {
            Logging.w(TAG, "A non default usage attribute is used: " + usageAttribute);
        }
        return new AudioTrack(new AudioAttributes.Builder().setUsage(usageAttribute).setContentType(1).build(), new AudioFormat.Builder().setEncoding(2).setSampleRate(n).setChannelMask(n2).build(), n3, 1, 0);
    }

    private static AudioTrack createAudioTrackOnLowerThanLollipop(int n, int n2, int n3) {
        return new AudioTrack(0, n, n2, 2, n3, 1);
    }

    private void logBufferSizeInFrames() {
        if (Build.VERSION.SDK_INT >= 23) {
            Logging.d(TAG, "AudioTrack: buffer size in frames: " + this.audioTrack.getBufferSizeInFrames());
        }
    }

    private void logBufferCapacityInFrames() {
        if (Build.VERSION.SDK_INT >= 24) {
            Logging.d(TAG, "AudioTrack: buffer capacity in frames: " + this.audioTrack.getBufferCapacityInFrames());
        }
    }

    private void logMainParametersExtended() {
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.logBufferSizeInFrames();
        webRtcAudioTrack.logBufferCapacityInFrames();
    }

    private void logUnderrunCount() {
        if (Build.VERSION.SDK_INT >= 24) {
            Logging.d(TAG, "underrun count: " + this.audioTrack.getUnderrunCount());
        }
    }

    private static void assertTrue(boolean bl) {
        if (bl) {
            return;
        }
        throw new AssertionError((Object)"Expected condition to be true");
    }

    private int channelCountToConfiguration(int n) {
        return n == 1 ? 4 : 12;
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeGetPlayoutData(int var1, long var2);

    public static void setSpeakerMute(boolean bl) {
        Logging.w(TAG, "setSpeakerMute(" + bl + ")");
        speakerMute = bl;
    }

    private void releaseAudioResources() {
        Logging.d(TAG, "releaseAudioResources");
        AudioTrack audioTrack = this.audioTrack;
        if (audioTrack != null) {
            audioTrack.release();
            this.audioTrack = null;
        }
    }

    private void reportWebRtcAudioTrackInitError(String string) {
        Logging.e(TAG, "Init playout error: " + string);
        WebRtcAudioUtils.logAudioState(TAG);
        Object object = errorCallbackOld;
        if (object != null) {
            object.onWebRtcAudioTrackInitError(string);
        }
        if ((object = errorCallback) != null) {
            object.onWebRtcAudioTrackInitError(string);
        }
    }

    private void reportWebRtcAudioTrackStartError(AudioTrackStartErrorCode audioTrackStartErrorCode, String string) {
        Logging.e(TAG, "Start playout error: " + (Object)((Object)audioTrackStartErrorCode) + ". " + string);
        WebRtcAudioUtils.logAudioState(TAG);
        Object object = errorCallbackOld;
        if (object != null) {
            object.onWebRtcAudioTrackStartError(string);
        }
        if ((object = errorCallback) != null) {
            object.onWebRtcAudioTrackStartError(audioTrackStartErrorCode, string);
        }
    }

    private void reportWebRtcAudioTrackError(String string) {
        Logging.e(TAG, "Run-time playback error: " + string);
        WebRtcAudioUtils.logAudioState(TAG);
        Object object = errorCallbackOld;
        if (object != null) {
            object.onWebRtcAudioTrackError(string);
        }
        if ((object = errorCallback) != null) {
            object.onWebRtcAudioTrackError(string);
        }
    }

    static {
        usageAttribute = DEFAULT_USAGE = WebRtcAudioTrack.getDefaultUsageAttribute();
    }

    private class AudioTrackThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioTrackThread(String string) {
            super(string);
            this.keepAlive = true;
        }

        private int writeBytes(AudioTrack audioTrack, ByteBuffer byteBuffer, int n) {
            if (Build.VERSION.SDK_INT >= 21) {
                return audioTrack.write(byteBuffer, n, 0);
            }
            ByteBuffer byteBuffer2 = byteBuffer;
            Object object = byteBuffer2.array();
            return audioTrack.write((byte[])object, byteBuffer2.arrayOffset(), n);
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            Logging.d(WebRtcAudioTrack.TAG, "AudioTrackThread" + WebRtcAudioUtils.getThreadInfo());
            WebRtcAudioTrack.assertTrue(WebRtcAudioTrack.this.audioTrack.getPlayState() == 3);
            int n = WebRtcAudioTrack.this.byteBuffer.capacity();
            while (this.keepAlive) {
                AudioTrackThread audioTrackThread = this;
                WebRtcAudioTrack webRtcAudioTrack = audioTrackThread.WebRtcAudioTrack.this;
                webRtcAudioTrack.nativeGetPlayoutData(n, webRtcAudioTrack.nativeAudioTrack);
                WebRtcAudioTrack.assertTrue(n <= audioTrackThread.WebRtcAudioTrack.this.byteBuffer.remaining());
                if (speakerMute) {
                    AudioTrackThread audioTrackThread2 = this;
                    audioTrackThread2.WebRtcAudioTrack.this.byteBuffer.clear();
                    audioTrackThread2.WebRtcAudioTrack.this.byteBuffer.put(WebRtcAudioTrack.this.emptyBytes);
                    audioTrackThread2.WebRtcAudioTrack.this.byteBuffer.position(0);
                }
                AudioTrackThread audioTrackThread3 = this;
                int n2 = audioTrackThread3.writeBytes(audioTrackThread3.WebRtcAudioTrack.this.audioTrack, WebRtcAudioTrack.this.byteBuffer, n);
                if (n2 != n) {
                    Logging.e(WebRtcAudioTrack.TAG, "AudioTrack.write played invalid number of bytes: " + n2);
                    if (n2 < 0) {
                        this.keepAlive = false;
                        WebRtcAudioTrack.this.reportWebRtcAudioTrackError("AudioTrack.write failed: " + n2);
                    }
                }
                WebRtcAudioTrack.this.byteBuffer.rewind();
            }
            if (WebRtcAudioTrack.this.audioTrack != null) {
                Logging.d(WebRtcAudioTrack.TAG, "Calling AudioTrack.stop...");
                try {
                    WebRtcAudioTrack.this.audioTrack.stop();
                    Logging.d(WebRtcAudioTrack.TAG, "AudioTrack.stop is done.");
                }
                catch (IllegalStateException illegalStateException) {
                    Logging.e(WebRtcAudioTrack.TAG, "AudioTrack.stop failed: " + illegalStateException.getMessage());
                }
            }
        }

        public void stopThread() {
            Logging.d(WebRtcAudioTrack.TAG, "stopThread");
            this.keepAlive = false;
        }
    }

    public static interface ErrorCallback {
        public void onWebRtcAudioTrackInitError(String var1);

        public void onWebRtcAudioTrackStartError(AudioTrackStartErrorCode var1, String var2);

        public void onWebRtcAudioTrackError(String var1);
    }

    @Deprecated
    public static interface WebRtcAudioTrackErrorCallback {
        public void onWebRtcAudioTrackInitError(String var1);

        public void onWebRtcAudioTrackStartError(String var1);

        public void onWebRtcAudioTrackError(String var1);
    }

    public static final class AudioTrackStartErrorCode
    extends Enum<AudioTrackStartErrorCode> {
        public static final /* enum */ AudioTrackStartErrorCode AUDIO_TRACK_START_EXCEPTION;
        public static final /* enum */ AudioTrackStartErrorCode AUDIO_TRACK_START_STATE_MISMATCH;
        private static final /* synthetic */ AudioTrackStartErrorCode[] $VALUES;

        public static AudioTrackStartErrorCode[] values() {
            return (AudioTrackStartErrorCode[])$VALUES.clone();
        }

        public static AudioTrackStartErrorCode valueOf(String string) {
            return Enum.valueOf(AudioTrackStartErrorCode.class, string);
        }

        static {
            AudioTrackStartErrorCode audioTrackStartErrorCode;
            AUDIO_TRACK_START_EXCEPTION = new AudioTrackStartErrorCode();
            AudioTrackStartErrorCode audioTrackStartErrorCode2 = audioTrackStartErrorCode;
            AUDIO_TRACK_START_STATE_MISMATCH = new AudioTrackStartErrorCode();
            $VALUES = new AudioTrackStartErrorCode[]{AUDIO_TRACK_START_EXCEPTION, audioTrackStartErrorCode2};
        }
    }
}

