/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc.audio;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Build;
import java.util.Arrays;
import org.otwebrtc.Logging;

final class WebRtcAudioUtils {
    private static final String TAG = "WebRtcAudioUtilsExternal";

    WebRtcAudioUtils() {
    }

    public static String getThreadInfo() {
        return "@[name=" + Thread.currentThread().getName() + ", id=" + Thread.currentThread().getId() + "]";
    }

    public static boolean runningOnEmulator() {
        return Build.HARDWARE.equals("goldfish") && Build.BRAND.startsWith("generic_");
    }

    static void logDeviceInfo(String string) {
        Logging.d(string, "Android SDK: " + Build.VERSION.SDK_INT + ", Release: " + Build.VERSION.RELEASE + ", Brand: " + Build.BRAND + ", Device: " + Build.DEVICE + ", Id: " + Build.ID + ", Hardware: " + Build.HARDWARE + ", Manufacturer: " + Build.MANUFACTURER + ", Model: " + Build.MODEL + ", Product: " + Build.PRODUCT);
    }

    static void logAudioState(String string, Context context, AudioManager audioManager) {
        String string2 = string;
        WebRtcAudioUtils.logDeviceInfo(string2);
        WebRtcAudioUtils.logAudioStateBasic(string2, context, audioManager);
        WebRtcAudioUtils.logAudioStateVolume(string2, audioManager);
        WebRtcAudioUtils.logAudioDeviceInfo(string2, audioManager);
    }

    static String deviceTypeToString(int n) {
        switch (n) {
            default: {
                return "TYPE_UNKNOWN";
            }
            case 22: {
                return "TYPE_USB_HEADSET";
            }
            case 21: {
                return "TYPE_BUS";
            }
            case 20: {
                return "TYPE_IP";
            }
            case 19: {
                return "TYPE_AUX_LINE";
            }
            case 18: {
                return "TYPE_TELEPHONY";
            }
            case 17: {
                return "TYPE_TV_TUNER";
            }
            case 16: {
                return "TYPE_FM_TUNER";
            }
            case 15: {
                return "TYPE_BUILTIN_MIC";
            }
            case 14: {
                return "TYPE_FM";
            }
            case 13: {
                return "TYPE_DOCK";
            }
            case 12: {
                return "TYPE_USB_ACCESSORY";
            }
            case 11: {
                return "TYPE_USB_DEVICE";
            }
            case 10: {
                return "TYPE_HDMI_ARC";
            }
            case 9: {
                return "TYPE_HDMI";
            }
            case 8: {
                return "TYPE_BLUETOOTH_A2DP";
            }
            case 7: {
                return "TYPE_BLUETOOTH_SCO";
            }
            case 6: {
                return "TYPE_LINE_DIGITAL";
            }
            case 5: {
                return "TYPE_LINE_ANALOG";
            }
            case 4: {
                return "TYPE_WIRED_HEADPHONES";
            }
            case 3: {
                return "TYPE_WIRED_HEADSET";
            }
            case 2: {
                return "TYPE_BUILTIN_SPEAKER";
            }
            case 1: 
        }
        return "TYPE_BUILTIN_EARPIECE";
    }

    @TargetApi(value=24)
    public static String audioSourceToString(int n) {
        switch (n) {
            default: {
                return "INVALID";
            }
            case 10: {
                return "VOICE_PERFORMANCE";
            }
            case 9: {
                return "UNPROCESSED";
            }
            case 7: {
                return "VOICE_COMMUNICATION";
            }
            case 6: {
                return "VOICE_RECOGNITION";
            }
            case 5: {
                return "CAMCORDER";
            }
            case 4: {
                return "VOICE_CALL";
            }
            case 3: {
                return "VOICE_DOWNLINK";
            }
            case 2: {
                return "VOICE_UPLINK";
            }
            case 1: {
                return "MIC";
            }
            case 0: 
        }
        return "DEFAULT";
    }

    public static String channelMaskToString(int n) {
        if (n != 12) {
            if (n != 16) {
                return "INVALID";
            }
            return "IN_MONO";
        }
        return "IN_STEREO";
    }

    @TargetApi(value=24)
    public static String audioEncodingToString(int n) {
        switch (n) {
            default: {
                return "Invalid encoding: " + n;
            }
            case 9: {
                return "MP3";
            }
            case 8: {
                return "DTS_HD";
            }
            case 7: {
                return "DTS";
            }
            case 6: {
                return "AC3";
            }
            case 5: {
                return "AC3";
            }
            case 4: {
                return "PCM_FLOAT";
            }
            case 3: {
                return "PCM_8BIT";
            }
            case 2: {
                return "PCM_16BIT";
            }
            case 0: 
        }
        return "INVALID";
    }

    private static void logAudioStateBasic(String string, Context context, AudioManager audioManager) {
        Logging.d(string, "Audio State: audio mode: " + WebRtcAudioUtils.modeToString(audioManager.getMode()) + ", has mic: " + WebRtcAudioUtils.hasMicrophone(context) + ", mic muted: " + audioManager.isMicrophoneMute() + ", music active: " + audioManager.isMusicActive() + ", speakerphone: " + audioManager.isSpeakerphoneOn() + ", BT SCO: " + audioManager.isBluetoothScoOn());
    }

    private static boolean isVolumeFixed(AudioManager audioManager) {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        return audioManager.isVolumeFixed();
    }

    private static void logAudioStateVolume(String string, AudioManager audioManager) {
        int n = 6;
        int[] nArray = new int[6];
        int[] nArray2 = nArray;
        nArray[0] = 0;
        nArray[1] = 3;
        nArray[2] = 2;
        nArray[3] = 4;
        nArray[4] = 5;
        nArray[5] = 1;
        Logging.d(string, "Audio State: ");
        int n2 = WebRtcAudioUtils.isVolumeFixed(audioManager);
        Logging.d(string, "  fixed volume=" + (n2 != 0));
        if (n2 == 0) {
            for (n2 = 0; n2 < n; ++n2) {
                StringBuilder stringBuilder;
                String string2 = string;
                int n3 = nArray2[n2];
                StringBuilder stringBuilder2 = stringBuilder;
                new StringBuilder().append("  " + WebRtcAudioUtils.streamTypeToString(n3) + ": ");
                stringBuilder2.append("volume=").append(audioManager.getStreamVolume(n3));
                stringBuilder2.append(", max=").append(audioManager.getStreamMaxVolume(n3));
                WebRtcAudioUtils.logIsStreamMute(string2, audioManager, n3, stringBuilder2);
                Logging.d(string2, stringBuilder2.toString());
            }
        }
    }

    private static void logIsStreamMute(String string, AudioManager audioManager, int n, StringBuilder stringBuilder) {
        if (Build.VERSION.SDK_INT >= 23) {
            stringBuilder.append(", muted=").append(audioManager.isStreamMute(n));
        }
    }

    private static void logAudioDeviceInfo(String string, AudioManager audioDeviceInfoArray) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        if ((audioDeviceInfoArray = audioDeviceInfoArray.getDevices(3)).length == 0) {
            return;
        }
        Logging.d(string, "Audio Devices: ");
        for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfoArray) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            new StringBuilder().append("  ").append(WebRtcAudioUtils.deviceTypeToString(audioDeviceInfo.getType()));
            String string2 = audioDeviceInfo.isSource() ? "(in): " : "(out): ";
            stringBuilder2.append(string2);
            if (audioDeviceInfo.getChannelCounts().length > 0) {
                StringBuilder stringBuilder3 = stringBuilder2;
                stringBuilder3.append("channels=").append(Arrays.toString(audioDeviceInfo.getChannelCounts()));
                stringBuilder3.append(", ");
            }
            if (audioDeviceInfo.getEncodings().length > 0) {
                StringBuilder stringBuilder4 = stringBuilder2;
                stringBuilder4.append("encodings=").append(Arrays.toString(audioDeviceInfo.getEncodings()));
                stringBuilder4.append(", ");
            }
            if (audioDeviceInfo.getSampleRates().length > 0) {
                StringBuilder stringBuilder5 = stringBuilder2;
                stringBuilder5.append("sample rates=").append(Arrays.toString(audioDeviceInfo.getSampleRates()));
                stringBuilder5.append(", ");
            }
            StringBuilder stringBuilder6 = stringBuilder2;
            stringBuilder6.append("id=").append(audioDeviceInfo.getId());
            Logging.d(string, stringBuilder6.toString());
        }
    }

    static String modeToString(int n) {
        switch (n) {
            default: {
                return "MODE_INVALID";
            }
            case 3: {
                return "MODE_IN_COMMUNICATION";
            }
            case 2: {
                return "MODE_IN_CALL";
            }
            case 1: {
                return "MODE_RINGTONE";
            }
            case 0: 
        }
        return "MODE_NORMAL";
    }

    private static String streamTypeToString(int n) {
        switch (n) {
            default: {
                return "STREAM_INVALID";
            }
            case 5: {
                return "STREAM_NOTIFICATION";
            }
            case 4: {
                return "STREAM_ALARM";
            }
            case 3: {
                return "STREAM_MUSIC";
            }
            case 2: {
                return "STREAM_RING";
            }
            case 1: {
                return "STREAM_SYSTEM";
            }
            case 0: 
        }
        return "STREAM_VOICE_CALL";
    }

    private static boolean hasMicrophone(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.microphone");
    }
}

