/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import java.util.IdentityHashMap;
import org.otwebrtc.MediaStreamTrack;
import org.otwebrtc.VideoSink;

public class VideoTrack
extends MediaStreamTrack {
    private final IdentityHashMap<VideoSink, Long> sinks;

    public VideoTrack(long l) {
        super(l);
        IdentityHashMap identityHashMap;
        IdentityHashMap identityHashMap2 = identityHashMap;
        identityHashMap = new IdentityHashMap();
        v1.sinks = identityHashMap2;
    }

    private static native void nativeAddSink(long var0, long var2);

    private static native void nativeRemoveSink(long var0, long var2);

    private static native long nativeWrapSink(VideoSink var0);

    private static native void nativeFreeSink(long var0);

    public void addSink(VideoSink videoSink) {
        if (videoSink != null) {
            if (!this.sinks.containsKey(videoSink)) {
                VideoTrack videoTrack = this;
                long l = VideoTrack.nativeWrapSink(videoSink);
                videoTrack.sinks.put(videoSink, l);
                VideoTrack.nativeAddSink(videoTrack.getNativeMediaStreamTrack(), l);
            }
            return;
        }
        throw new IllegalArgumentException("The VideoSink is not allowed to be null");
    }

    public void removeSink(VideoSink object) {
        if ((object = this.sinks.remove(object)) != null) {
            VideoTrack.nativeRemoveSink(this.getNativeMediaStreamTrack(), (Long)object);
            VideoTrack.nativeFreeSink((Long)object);
        }
    }

    @Override
    public void dispose() {
        for (long l : this.sinks.values()) {
            VideoTrack.nativeRemoveSink(this.getNativeMediaStreamTrack(), l);
            VideoTrack.nativeFreeSink(l);
        }
        VideoTrack videoTrack = this;
        videoTrack.sinks.clear();
        super.dispose();
    }

    long getNativeVideoTrack() {
        return this.getNativeMediaStreamTrack();
    }
}

