/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.support.annotation.Nullable;
import org.otwebrtc.CapturerObserver;
import org.otwebrtc.VideoFrame;
import org.otwebrtc.VideoSink;

public interface VideoProcessor
extends CapturerObserver {
    @Nullable
    public static VideoFrame applyFrameAdaptationParameters(VideoFrame videoFrame, FrameAdaptationParameters frameAdaptationParameters) {
        if (frameAdaptationParameters.drop) {
            return null;
        }
        FrameAdaptationParameters frameAdaptationParameters2 = frameAdaptationParameters;
        int n = frameAdaptationParameters2.cropX;
        int n2 = frameAdaptationParameters2.cropY;
        int n3 = frameAdaptationParameters2.cropWidth;
        int n4 = frameAdaptationParameters2.cropHeight;
        int n5 = frameAdaptationParameters2.scaleWidth;
        int n6 = frameAdaptationParameters2.scaleHeight;
        VideoFrame.Buffer buffer = videoFrame.getBuffer().cropAndScale(n, n2, n3, n4, n5, n6);
        int n7 = videoFrame.getRotation();
        long l = frameAdaptationParameters.timestampNs;
        return new VideoFrame(buffer, n7, l);
    }

    default public void onFrameCaptured(VideoFrame videoFrame, FrameAdaptationParameters frameAdaptationParameters) {
        if ((videoFrame = VideoProcessor.applyFrameAdaptationParameters(videoFrame, frameAdaptationParameters)) != null) {
            this.onFrameCaptured(videoFrame);
            videoFrame.release();
        }
    }

    public void setSink(@Nullable VideoSink var1);

    public static class FrameAdaptationParameters {
        public final int cropX;
        public final int cropY;
        public final int cropWidth;
        public final int cropHeight;
        public final int scaleWidth;
        public final int scaleHeight;
        public final long timestampNs;
        public final boolean drop;

        public FrameAdaptationParameters(int n, int n2, int n3, int n4, int n5, int n6, long l, boolean bl) {
            this.cropX = n;
            this.cropY = n2;
            this.cropWidth = n3;
            this.cropHeight = n4;
            this.scaleWidth = n5;
            this.scaleHeight = n6;
            this.timestampNs = l;
            this.drop = bl;
        }
    }
}

