/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.os.Handler;
import android.os.HandlerThread;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.CountDownLatch;
import org.otwebrtc.EglBase;
import org.otwebrtc.Logging;
import org.otwebrtc.ThreadUtils;
import org.otwebrtc.VideoFrame;
import org.otwebrtc.VideoSink;
import org.otwebrtc.YuvConverter;
import org.otwebrtc.YuvHelper;

public class VideoFileRenderer
implements VideoSink {
    private static final String TAG = "VideoFileRenderer";
    private final HandlerThread renderThread;
    private final Handler renderThreadHandler;
    private final HandlerThread fileThread;
    private final Handler fileThreadHandler;
    private final FileOutputStream videoOutFile;
    private final String outputFileName;
    private final int outputFileWidth;
    private final int outputFileHeight;
    private final int outputFrameSize;
    private final ByteBuffer outputFrameBuffer;
    private EglBase eglBase;
    private YuvConverter yuvConverter;
    private int frameCount;

    public VideoFileRenderer(String string, int n, int n2, final EglBase.Context context) {
        if (n % 2 != 1 && n2 % 2 != 1) {
            int n3;
            this.outputFileName = string;
            this.outputFileWidth = n;
            this.outputFileHeight = n2;
            this.outputFrameSize = n3 = n * n2 * 3 / 2;
            this.outputFrameBuffer = ByteBuffer.allocateDirect(n3);
            this.videoOutFile = new FileOutputStream(string);
            this.videoOutFile.write(("YUV4MPEG2 C420 W" + n + " H" + n2 + " Ip F30:1 A1:1\n").getBytes(Charset.forName("US-ASCII")));
            this.renderThread = new HandlerThread("VideoFileRendererRenderThread");
            this.renderThread.start();
            this.renderThreadHandler = new Handler(this.renderThread.getLooper());
            this.fileThread = new HandlerThread("VideoFileRendererFileThread");
            this.fileThread.start();
            this.fileThreadHandler = new Handler(this.fileThread.getLooper());
            ThreadUtils.invokeAtFrontUninterruptibly(this.renderThreadHandler, new Runnable(){

                @Override
                public void run() {
                    1 v0 = this;
                    VideoFileRenderer.access$002(v0.VideoFileRenderer.this, EglBase.create(context, EglBase.CONFIG_PIXEL_BUFFER));
                    v0.VideoFileRenderer.this.eglBase.createDummyPbufferSurface();
                    v0.VideoFileRenderer.this.eglBase.makeCurrent();
                    VideoFileRenderer.access$102(v0.VideoFileRenderer.this, new YuvConverter());
                }
            });
            return;
        }
        throw new IllegalArgumentException("Does not support uneven width or height");
    }

    private void renderFrameOnRenderThread(VideoFrame videoFrame) {
        float f2;
        VideoFrame videoFrame2 = videoFrame;
        VideoFrame.Buffer buffer = videoFrame2.getBuffer();
        int n = videoFrame2.getRotation() % 180 == 0 ? this.outputFileWidth : this.outputFileHeight;
        int n2 = videoFrame.getRotation() % 180 == 0 ? this.outputFileHeight : this.outputFileWidth;
        float f3 = (float)buffer.getWidth() / (float)buffer.getHeight();
        float f4 = (float)n / (float)n2;
        VideoFrame.Buffer buffer2 = buffer;
        int n3 = buffer2.getWidth();
        int n4 = buffer2.getHeight();
        if (f2 > f3) {
            n4 = (int)((float)n4 * (f3 / f4));
        } else {
            n3 = (int)((float)n3 * (f4 / f3));
        }
        VideoFrame.Buffer buffer3 = buffer;
        VideoFrame.Buffer buffer4 = buffer3.cropAndScale((buffer3.getWidth() - n3) / 2, (buffer.getHeight() - n4) / 2, n3, n4, n, n2);
        videoFrame.release();
        buffer = buffer4.toI420();
        buffer4.release();
        this.fileThreadHandler.post(() -> this.a((VideoFrame.I420Buffer)buffer, videoFrame));
    }

    private /* synthetic */ void a(VideoFrame.I420Buffer i420Buffer, VideoFrame object) {
        FileOutputStream fileOutputStream;
        VideoFileRenderer videoFileRenderer = object2;
        VideoFrame.I420Buffer i420Buffer2 = i420Buffer;
        VideoFrame videoFrame = object;
        VideoFrame.I420Buffer i420Buffer3 = i420Buffer;
        VideoFrame.I420Buffer i420Buffer4 = i420Buffer;
        int n = i420Buffer4.getStrideY();
        object = i420Buffer4.getDataU();
        int n2 = i420Buffer4.getStrideU();
        ByteBuffer byteBuffer = i420Buffer4.getDataV();
        int n3 = i420Buffer4.getStrideV();
        ByteBuffer byteBuffer2 = ((VideoFileRenderer)object2).outputFrameBuffer;
        int n4 = i420Buffer3.getWidth();
        int n5 = i420Buffer3.getHeight();
        int n6 = videoFrame.getRotation();
        YuvHelper.I420Rotate(i420Buffer2.getDataY(), n, (ByteBuffer)object, n2, byteBuffer, n3, byteBuffer2, n4, n5, n6);
        i420Buffer2.release();
        try {
            fileOutputStream = videoFileRenderer.videoOutFile;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error writing video to disk", iOException);
        }
        fileOutputStream.write("FRAME\n".getBytes(Charset.forName("US-ASCII")));
        FileOutputStream fileOutputStream2 = videoFileRenderer.videoOutFile;
        VideoFileRenderer videoFileRenderer2 = object2;
        VideoFileRenderer videoFileRenderer3 = videoFileRenderer2;
        VideoFileRenderer videoFileRenderer4 = videoFileRenderer2;
        Object object2 = videoFileRenderer2.outputFrameBuffer.array();
        n = videoFileRenderer4.outputFrameBuffer.arrayOffset();
        int n7 = videoFileRenderer3.outputFrameSize;
        fileOutputStream2.write((byte[])object2, n, n7);
        ++videoFileRenderer.frameCount;
    }

    static /* synthetic */ EglBase access$002(VideoFileRenderer videoFileRenderer, EglBase eglBase) {
        videoFileRenderer.eglBase = eglBase;
        return eglBase;
    }

    static /* synthetic */ YuvConverter access$102(VideoFileRenderer videoFileRenderer, YuvConverter yuvConverter) {
        videoFileRenderer.yuvConverter = yuvConverter;
        return yuvConverter;
    }

    @Override
    public void onFrame(VideoFrame videoFrame) {
        videoFrame.retain();
        this.renderThreadHandler.post(() -> this.renderFrameOnRenderThread(videoFrame));
    }

    public void release() {
        CountDownLatch countDownLatch;
        VideoFileRenderer videoFileRenderer = this;
        CountDownLatch countDownLatch2 = countDownLatch;
        countDownLatch2(1);
        this.renderThreadHandler.post(() -> {
            VideoFileRenderer videoFileRenderer = this;
            videoFileRenderer.yuvConverter.release();
            videoFileRenderer.eglBase.release();
            videoFileRenderer.renderThread.quit();
            countDownLatch2.countDown();
        });
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        videoFileRenderer.fileThreadHandler.post(() -> {
            VideoFileRenderer videoFileRenderer;
            try {
                VideoFileRenderer videoFileRenderer2 = this;
                videoFileRenderer = videoFileRenderer2;
                videoFileRenderer2.videoOutFile.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error closing output file", iOException);
            }
            Logging.d(TAG, "Video written to disk as " + this.outputFileName + ". The number of frames is " + this.frameCount + " and the dimensions of the frames are " + this.outputFileWidth + "x" + this.outputFileHeight + ".");
            videoFileRenderer.fileThread.quit();
        });
        try {
            videoFileRenderer.fileThread.join();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            Logging.e(TAG, "Interrupted while waiting for the write to disk to complete.", interruptedException);
        }
    }
}

