/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.graphics.Matrix;
import android.os.Handler;
import android.support.annotation.Nullable;
import org.otwebrtc.RefCountDelegate;
import org.otwebrtc.ThreadUtils;
import org.otwebrtc.VideoFrame;
import org.otwebrtc.YuvConverter;

public class TextureBufferImpl
implements VideoFrame.TextureBuffer {
    private final int unscaledWidth;
    private final int unscaledHeight;
    private final int width;
    private final int height;
    private final VideoFrame.TextureBuffer.Type type;
    private final int id;
    private final Matrix transformMatrix;
    private final Handler toI420Handler;
    private final YuvConverter yuvConverter;
    private final RefCountDelegate refCountDelegate;
    private final RefCountMonitor refCountMonitor;

    public TextureBufferImpl(int n, int n2, VideoFrame.TextureBuffer.Type type, int n3, Matrix matrix, Handler handler, YuvConverter yuvConverter, final @Nullable Runnable runnable) {
        RefCountMonitor refCountMonitor;
        TextureBufferImpl textureBufferImpl = refCountMonitor2;
        RefCountMonitor refCountMonitor2 = refCountMonitor;
        refCountMonitor = new RefCountMonitor(){

            @Override
            public void onRetain(TextureBufferImpl textureBufferImpl) {
            }

            @Override
            public void onRelease(TextureBufferImpl textureBufferImpl) {
            }

            @Override
            public void onDestroy(TextureBufferImpl textureBufferImpl) {
                Runnable runnable2 = runnable2.runnable;
                if (runnable2 != null) {
                    runnable2.run();
                }
            }
        };
        textureBufferImpl(n, n2, n, n2, type, n3, matrix, handler, yuvConverter, refCountMonitor2);
    }

    TextureBufferImpl(int n, int n2, VideoFrame.TextureBuffer.Type type, int n3, Matrix matrix, Handler handler, YuvConverter yuvConverter, RefCountMonitor refCountMonitor) {
        this(n, n2, n, n2, type, n3, matrix, handler, yuvConverter, refCountMonitor);
    }

    private TextureBufferImpl(int n, int n2, int n3, int n4, VideoFrame.TextureBuffer.Type type, int n5, Matrix matrix, Handler handler, YuvConverter yuvConverter, RefCountMonitor refCountMonitor) {
        TextureBufferImpl textureBufferImpl = this;
        this.unscaledWidth = n;
        this.unscaledHeight = n2;
        this.width = n3;
        this.height = n4;
        this.type = type;
        this.id = n5;
        this.transformMatrix = matrix;
        this.toI420Handler = handler;
        textureBufferImpl.yuvConverter = yuvConverter;
        textureBufferImpl.refCountDelegate = new RefCountDelegate(() -> refCountMonitor.onDestroy(this));
        this.refCountMonitor = refCountMonitor;
    }

    private TextureBufferImpl applyTransformMatrix(Matrix object, int n, int n2, int n3, int n4) {
        RefCountMonitor refCountMonitor;
        Matrix matrix;
        Matrix matrix2 = matrix;
        matrix2(this.transformMatrix);
        matrix.preConcat(object);
        this.retain();
        int n5 = n;
        TextureBufferImpl textureBufferImpl = this;
        object = textureBufferImpl.type;
        n = textureBufferImpl.id;
        Handler handler = textureBufferImpl.toI420Handler;
        YuvConverter yuvConverter = textureBufferImpl.yuvConverter;
        RefCountMonitor refCountMonitor2 = refCountMonitor;
        refCountMonitor = new RefCountMonitor(){

            @Override
            public void onRetain(TextureBufferImpl textureBufferImpl) {
                TextureBufferImpl.this.refCountMonitor.onRetain(TextureBufferImpl.this);
            }

            @Override
            public void onRelease(TextureBufferImpl textureBufferImpl) {
                TextureBufferImpl.this.refCountMonitor.onRelease(TextureBufferImpl.this);
            }

            @Override
            public void onDestroy(TextureBufferImpl textureBufferImpl) {
                TextureBufferImpl.this.release();
            }
        };
        return new TextureBufferImpl(n5, n2, n3, n4, (VideoFrame.TextureBuffer.Type)((Object)object), n, matrix2, handler, yuvConverter, refCountMonitor2);
    }

    @Override
    public VideoFrame.TextureBuffer.Type getType() {
        return this.type;
    }

    @Override
    public int getTextureId() {
        return this.id;
    }

    @Override
    public Matrix getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return ThreadUtils.invokeAtFrontUninterruptibly(this.toI420Handler, () -> this.yuvConverter.convert(this));
    }

    @Override
    public void retain() {
        TextureBufferImpl textureBufferImpl = this;
        textureBufferImpl.refCountMonitor.onRetain(this);
        textureBufferImpl.refCountDelegate.retain();
    }

    @Override
    public void release() {
        TextureBufferImpl textureBufferImpl = this;
        textureBufferImpl.refCountMonitor.onRelease(this);
        textureBufferImpl.refCountDelegate.release();
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int n, int n2, int n3, int n4, int n5, int n6) {
        Matrix matrix;
        Matrix matrix2 = matrix;
        TextureBufferImpl textureBufferImpl = this;
        int n7 = n;
        matrix2();
        n = this.height;
        n2 = n - (n2 + n4);
        matrix2.preTranslate((float)n7 / (float)this.width, (float)n2 / (float)n);
        matrix2.preScale((float)n3 / (float)this.width, (float)n4 / (float)this.height);
        n = Math.round((float)(textureBufferImpl.unscaledWidth * n3) / (float)this.width);
        return this.applyTransformMatrix(matrix, n, Math.round((float)(textureBufferImpl.unscaledHeight * n4) / (float)this.height), n5, n6);
    }

    public int getUnscaledWidth() {
        return this.unscaledWidth;
    }

    public int getUnscaledHeight() {
        return this.unscaledHeight;
    }

    public Handler getToI420Handler() {
        return this.toI420Handler;
    }

    public YuvConverter getYuvConverter() {
        return this.yuvConverter;
    }

    public TextureBufferImpl applyTransformMatrix(Matrix matrix, int n, int n2) {
        return this.applyTransformMatrix(matrix, n, n2, n, n2);
    }

    static interface RefCountMonitor {
        public void onRetain(TextureBufferImpl var1);

        public void onRelease(TextureBufferImpl var1);

        public void onDestroy(TextureBufferImpl var1);
    }
}

