/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import org.otwebrtc.EglBase;
import org.otwebrtc.GlUtil;
import org.otwebrtc.Logging;
import org.otwebrtc.ThreadUtils;
import org.otwebrtc.YuvConverter61;

public class SurfaceTextureHelper61 {
    private static final String TAG = "SurfaceTextureHelper61";
    private final Handler handler;
    private final EglBase eglBase;
    private final SurfaceTexture surfaceTexture;
    private final int oesTextureId;
    private YuvConverter61 yuvConverter;
    private OnTextureFrameAvailableListener listener;
    private boolean hasPendingTexture = false;
    private volatile boolean isTextureInUse = false;
    private boolean isQuitting = false;
    private OnTextureFrameAvailableListener pendingListener;
    final Runnable setListenerRunnable = new Runnable(){

        @Override
        public void run() {
            2 v0 = this;
            Logging.d(SurfaceTextureHelper61.TAG, "Setting listener to " + SurfaceTextureHelper61.this.pendingListener);
            SurfaceTextureHelper61 surfaceTextureHelper61 = v0.SurfaceTextureHelper61.this;
            SurfaceTextureHelper61.access$202(surfaceTextureHelper61, surfaceTextureHelper61.pendingListener);
            SurfaceTextureHelper61.access$102(v0.SurfaceTextureHelper61.this, null);
            if (v0.SurfaceTextureHelper61.this.hasPendingTexture) {
                2 v2 = this;
                v2.SurfaceTextureHelper61.this.updateTexImage();
                SurfaceTextureHelper61.access$302(v2.SurfaceTextureHelper61.this, false);
            }
        }
    };

    public static SurfaceTextureHelper61 create(final String string, final EglBase.Context context) {
        Handler handler;
        HandlerThread handlerThread;
        HandlerThread handlerThread2 = handlerThread;
        new HandlerThread(string).start();
        final Handler handler2 = handler;
        return ThreadUtils.invokeAtFrontUninterruptibly(new Handler(handlerThread2.getLooper()), new Callable<SurfaceTextureHelper61>(){

            @Override
            public SurfaceTextureHelper61 call() {
                EglBase.Context context2;
                1 v4;
                SurfaceTextureHelper61 surfaceTextureHelper61;
                SurfaceTextureHelper61 surfaceTextureHelper612;
                try {
                    SurfaceTextureHelper61 surfaceTextureHelper613;
                    surfaceTextureHelper612 = surfaceTextureHelper613;
                    surfaceTextureHelper61 = surfaceTextureHelper613;
                    1 v3 = this;
                    v4 = v3;
                    context2 = v3.context;
                }
                catch (RuntimeException runtimeException) {
                    Logging.e(SurfaceTextureHelper61.TAG, string + " create failure", runtimeException);
                    return null;
                }
                surfaceTextureHelper612(context2, v4.handler2);
                return surfaceTextureHelper61;
            }
        });
    }

    private SurfaceTextureHelper61(EglBase.Context context, Handler handler) {
        if (handler.getLooper().getThread() == Thread.currentThread()) {
            this.handler = handler;
            this.eglBase = EglBase.create(context, EglBase.CONFIG_PIXEL_BUFFER);
            try {
                this.eglBase.createDummyPbufferSurface();
                this.eglBase.makeCurrent();
            }
            catch (RuntimeException runtimeException) {
                this.eglBase.release();
                handler.getLooper().quit();
                throw runtimeException;
            }
            this.oesTextureId = GlUtil.generateTexture(36197);
            this.surfaceTexture = new SurfaceTexture(this.oesTextureId);
            this.surfaceTexture.setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

                public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                    3 v0 = this;
                    SurfaceTextureHelper61.access$302(v0.SurfaceTextureHelper61.this, true);
                    v0.SurfaceTextureHelper61.this.tryDeliverTextureFrame();
                }
            });
            return;
        }
        throw new IllegalStateException("SurfaceTextureHelper must be created on the handler thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTexImage() {
        Object object = EglBase.lock;
        synchronized (object) {
            this.surfaceTexture.updateTexImage();
            return;
        }
    }

    private void tryDeliverTextureFrame() {
        if (this.handler.getLooper().getThread() == Thread.currentThread()) {
            if (!this.isQuitting && this.hasPendingTexture && !this.isTextureInUse && this.listener != null) {
                SurfaceTextureHelper61 surfaceTextureHelper61 = this;
                surfaceTextureHelper61.isTextureInUse = true;
                surfaceTextureHelper61.hasPendingTexture = false;
                surfaceTextureHelper61.updateTexImage();
                float[] fArray = new float[16];
                surfaceTextureHelper61.surfaceTexture.getTransformMatrix(fArray);
                long l = surfaceTextureHelper61.surfaceTexture.getTimestamp();
                surfaceTextureHelper61.listener.onTextureFrameAvailable(this.oesTextureId, fArray, l);
                return;
            }
            return;
        }
        throw new IllegalStateException("Wrong thread.");
    }

    private void release() {
        if (this.handler.getLooper().getThread() == Thread.currentThread()) {
            if (!this.isTextureInUse && this.isQuitting) {
                Object object = this.yuvConverter;
                if (object != null) {
                    ((YuvConverter61)object).release();
                }
                SurfaceTextureHelper61 surfaceTextureHelper61 = this;
                int[] nArray = new int[1];
                object = nArray;
                nArray[0] = this.oesTextureId;
                GLES20.glDeleteTextures((int)1, (int[])object, (int)0);
                surfaceTextureHelper61.surfaceTexture.release();
                surfaceTextureHelper61.eglBase.release();
                surfaceTextureHelper61.handler.getLooper().quit();
                return;
            }
            throw new IllegalStateException("Unexpected release.");
        }
        throw new IllegalStateException("Wrong thread.");
    }

    static /* synthetic */ OnTextureFrameAvailableListener access$202(SurfaceTextureHelper61 surfaceTextureHelper61, OnTextureFrameAvailableListener onTextureFrameAvailableListener) {
        surfaceTextureHelper61.listener = onTextureFrameAvailableListener;
        return onTextureFrameAvailableListener;
    }

    static /* synthetic */ OnTextureFrameAvailableListener access$102(SurfaceTextureHelper61 surfaceTextureHelper61, OnTextureFrameAvailableListener onTextureFrameAvailableListener) {
        surfaceTextureHelper61.pendingListener = onTextureFrameAvailableListener;
        return onTextureFrameAvailableListener;
    }

    static /* synthetic */ boolean access$302(SurfaceTextureHelper61 surfaceTextureHelper61, boolean bl) {
        surfaceTextureHelper61.hasPendingTexture = bl;
        return bl;
    }

    static /* synthetic */ boolean access$602(SurfaceTextureHelper61 surfaceTextureHelper61, boolean bl) {
        surfaceTextureHelper61.isTextureInUse = bl;
        return bl;
    }

    static /* synthetic */ boolean access$702(SurfaceTextureHelper61 surfaceTextureHelper61, boolean bl) {
        surfaceTextureHelper61.isQuitting = bl;
        return bl;
    }

    static /* synthetic */ YuvConverter61 access$902(SurfaceTextureHelper61 surfaceTextureHelper61, YuvConverter61 yuvConverter61) {
        surfaceTextureHelper61.yuvConverter = yuvConverter61;
        return yuvConverter61;
    }

    public void startListening(OnTextureFrameAvailableListener onTextureFrameAvailableListener) {
        if (this.listener == null && this.pendingListener == null) {
            this.pendingListener = onTextureFrameAvailableListener;
            this.handler.post(this.setListenerRunnable);
            return;
        }
        throw new IllegalStateException("SurfaceTextureHelper listener has already been set.");
    }

    public void stopListening() {
        SurfaceTextureHelper61 surfaceTextureHelper61 = this;
        Logging.d(TAG, "stopListening()");
        surfaceTextureHelper61.handler.removeCallbacks(this.setListenerRunnable);
        ThreadUtils.invokeAtFrontUninterruptibly(surfaceTextureHelper61.handler, new Runnable(){

            @Override
            public void run() {
                4 v0 = this;
                SurfaceTextureHelper61.access$202(v0.SurfaceTextureHelper61.this, null);
                SurfaceTextureHelper61.access$102(v0.SurfaceTextureHelper61.this, null);
            }
        });
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void returnTextureFrame() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                5 v0 = this;
                SurfaceTextureHelper61.access$602(v0.SurfaceTextureHelper61.this, false);
                if (v0.SurfaceTextureHelper61.this.isQuitting) {
                    SurfaceTextureHelper61.this.release();
                } else {
                    SurfaceTextureHelper61.this.tryDeliverTextureFrame();
                }
            }
        });
    }

    public boolean isTextureInUse() {
        return this.isTextureInUse;
    }

    public void dispose() {
        Logging.d(TAG, "dispose()");
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

            @Override
            public void run() {
                6 v0 = this;
                SurfaceTextureHelper61.access$702(v0.SurfaceTextureHelper61.this, true);
                if (!v0.SurfaceTextureHelper61.this.isTextureInUse) {
                    SurfaceTextureHelper61.this.release();
                }
            }
        });
    }

    public void textureToYUV(final ByteBuffer byteBuffer, final int n, final int n2, final int n3, final int n4, final float[] fArray) {
        if (n4 == this.oesTextureId) {
            ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

                @Override
                public void run() {
                    if (byteBuffer2.SurfaceTextureHelper61.this.yuvConverter == null) {
                        SurfaceTextureHelper61.access$902(byteBuffer2.SurfaceTextureHelper61.this, new YuvConverter61());
                    }
                    7 v0 = byteBuffer2;
                    ByteBuffer byteBuffer2 = v0.byteBuffer;
                    int n5 = v0.n;
                    int n22 = v0.n2;
                    int n32 = v0.n3;
                    int n42 = v0.n4;
                    float[] fArray2 = v0.fArray;
                    byteBuffer2.SurfaceTextureHelper61.this.yuvConverter.convert(byteBuffer2, n5, n22, n32, n42, fArray2);
                }
            });
            return;
        }
        throw new IllegalStateException("textureToByteBuffer called with unexpected textureId");
    }

    public static interface OnTextureFrameAvailableListener {
        public void onTextureFrameAvailable(int var1, float[] var2, long var3);
    }
}

