/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.otwebrtc.CalledByNative;
import org.otwebrtc.JniCommon;
import org.otwebrtc.MediaStreamTrack;
import org.otwebrtc.RtpParameters;
import org.otwebrtc.RtpReceiver;
import org.otwebrtc.RtpSender;

public class RtpTransceiver {
    private long nativeRtpTransceiver;
    private RtpSender cachedSender;
    private RtpReceiver cachedReceiver;

    @CalledByNative
    protected RtpTransceiver(long l) {
        this.nativeRtpTransceiver = l;
        this.cachedSender = RtpTransceiver.nativeGetSender(l);
        this.cachedReceiver = RtpTransceiver.nativeGetReceiver(l);
    }

    private void checkRtpTransceiverExists() {
        if (this.nativeRtpTransceiver != 0L) {
            return;
        }
        throw new IllegalStateException("RtpTransceiver has been disposed.");
    }

    private static native MediaStreamTrack.MediaType nativeGetMediaType(long var0);

    private static native String nativeGetMid(long var0);

    private static native RtpSender nativeGetSender(long var0);

    private static native RtpReceiver nativeGetReceiver(long var0);

    private static native boolean nativeStopped(long var0);

    private static native RtpTransceiverDirection nativeDirection(long var0);

    private static native RtpTransceiverDirection nativeCurrentDirection(long var0);

    private static native void nativeStop(long var0);

    private static native void nativeSetDirection(long var0, RtpTransceiverDirection var2);

    public MediaStreamTrack.MediaType getMediaType() {
        RtpTransceiver rtpTransceiver = this;
        rtpTransceiver.checkRtpTransceiverExists();
        return RtpTransceiver.nativeGetMediaType(rtpTransceiver.nativeRtpTransceiver);
    }

    public String getMid() {
        RtpTransceiver rtpTransceiver = this;
        rtpTransceiver.checkRtpTransceiverExists();
        return RtpTransceiver.nativeGetMid(rtpTransceiver.nativeRtpTransceiver);
    }

    public RtpSender getSender() {
        return this.cachedSender;
    }

    public RtpReceiver getReceiver() {
        return this.cachedReceiver;
    }

    public boolean isStopped() {
        RtpTransceiver rtpTransceiver = this;
        rtpTransceiver.checkRtpTransceiverExists();
        return RtpTransceiver.nativeStopped(rtpTransceiver.nativeRtpTransceiver);
    }

    public RtpTransceiverDirection getDirection() {
        RtpTransceiver rtpTransceiver = this;
        rtpTransceiver.checkRtpTransceiverExists();
        return RtpTransceiver.nativeDirection(rtpTransceiver.nativeRtpTransceiver);
    }

    public RtpTransceiverDirection getCurrentDirection() {
        RtpTransceiver rtpTransceiver = this;
        rtpTransceiver.checkRtpTransceiverExists();
        return RtpTransceiver.nativeCurrentDirection(rtpTransceiver.nativeRtpTransceiver);
    }

    public void setDirection(RtpTransceiverDirection rtpTransceiverDirection) {
        RtpTransceiver rtpTransceiver = this;
        rtpTransceiver.checkRtpTransceiverExists();
        RtpTransceiver.nativeSetDirection(rtpTransceiver.nativeRtpTransceiver, rtpTransceiverDirection);
    }

    public void stop() {
        RtpTransceiver rtpTransceiver = this;
        rtpTransceiver.checkRtpTransceiverExists();
        RtpTransceiver.nativeStop(rtpTransceiver.nativeRtpTransceiver);
    }

    @CalledByNative
    public void dispose() {
        RtpTransceiver rtpTransceiver = this;
        rtpTransceiver.checkRtpTransceiverExists();
        rtpTransceiver.cachedSender.dispose();
        rtpTransceiver.cachedReceiver.dispose();
        JniCommon.nativeReleaseRef(rtpTransceiver.nativeRtpTransceiver);
        rtpTransceiver.nativeRtpTransceiver = 0L;
    }

    public static final class RtpTransceiverInit {
        private final RtpTransceiverDirection direction;
        private final List<String> streamIds;
        private final List<RtpParameters.Encoding> sendEncodings;

        public RtpTransceiverInit() {
            this(RtpTransceiverDirection.SEND_RECV);
        }

        public RtpTransceiverInit(RtpTransceiverDirection rtpTransceiverDirection) {
            RtpTransceiverInit rtpTransceiverInit = list;
            List list = Collections.emptyList();
            rtpTransceiverInit(rtpTransceiverDirection, Collections.emptyList(), list);
        }

        public RtpTransceiverInit(RtpTransceiverDirection rtpTransceiverDirection, List<String> list) {
            RtpTransceiverInit rtpTransceiverInit = list2;
            List list2 = Collections.emptyList();
            rtpTransceiverInit(rtpTransceiverDirection, list, list2);
        }

        public RtpTransceiverInit(RtpTransceiverDirection rtpTransceiverDirection, List<String> list, List<RtpParameters.Encoding> list2) {
            ArrayList<RtpParameters.Encoding> arrayList;
            ArrayList<String> arrayList2;
            ((RtpTransceiverInit)object).direction = rtpTransceiverDirection;
            Object object = arrayList2;
            arrayList2 = new ArrayList<String>(list);
            v1.streamIds = object;
            object = arrayList;
            arrayList = new ArrayList<RtpParameters.Encoding>(list2);
            v1.sendEncodings = object;
        }

        @CalledByNative(value="RtpTransceiverInit")
        int getDirectionNativeIndex() {
            return this.direction.getNativeIndex();
        }

        @CalledByNative(value="RtpTransceiverInit")
        List<String> getStreamIds() {
            return new ArrayList<String>(this.streamIds);
        }

        @CalledByNative(value="RtpTransceiverInit")
        List<RtpParameters.Encoding> getSendEncodings() {
            return new ArrayList<RtpParameters.Encoding>(this.sendEncodings);
        }
    }

    public static final class RtpTransceiverDirection
    extends Enum<RtpTransceiverDirection> {
        public static final /* enum */ RtpTransceiverDirection SEND_RECV;
        public static final /* enum */ RtpTransceiverDirection SEND_ONLY;
        public static final /* enum */ RtpTransceiverDirection RECV_ONLY;
        public static final /* enum */ RtpTransceiverDirection INACTIVE;
        private static final /* synthetic */ RtpTransceiverDirection[] $VALUES;
        private final int nativeIndex;

        public static RtpTransceiverDirection[] values() {
            return (RtpTransceiverDirection[])$VALUES.clone();
        }

        public static RtpTransceiverDirection valueOf(String string) {
            return Enum.valueOf(RtpTransceiverDirection.class, string);
        }

        private RtpTransceiverDirection(int n2) {
            this.nativeIndex = n2;
        }

        @CalledByNative(value="RtpTransceiverDirection")
        static RtpTransceiverDirection fromNativeIndex(int n) {
            for (RtpTransceiverDirection rtpTransceiverDirection : RtpTransceiverDirection.values()) {
                if (rtpTransceiverDirection.getNativeIndex() != n) continue;
                return rtpTransceiverDirection;
            }
            throw new IllegalArgumentException("Uknown native RtpTransceiverDirection type" + n);
        }

        static {
            RtpTransceiverDirection rtpTransceiverDirection;
            SEND_RECV = new RtpTransceiverDirection(0);
            SEND_ONLY = new RtpTransceiverDirection(1);
            RECV_ONLY = new RtpTransceiverDirection(2);
            RtpTransceiverDirection rtpTransceiverDirection2 = rtpTransceiverDirection;
            INACTIVE = new RtpTransceiverDirection(3);
            $VALUES = new RtpTransceiverDirection[]{SEND_RECV, SEND_ONLY, RECV_ONLY, rtpTransceiverDirection2};
        }

        @CalledByNative(value="RtpTransceiverDirection")
        int getNativeIndex() {
            return this.nativeIndex;
        }
    }
}

