/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.support.annotation.Nullable;
import java.util.List;
import org.otwebrtc.CalledByNative;
import org.otwebrtc.DtmfSender;
import org.otwebrtc.FrameEncryptor;
import org.otwebrtc.JniCommon;
import org.otwebrtc.MediaStreamTrack;
import org.otwebrtc.RtpParameters;

public class RtpSender {
    private long nativeRtpSender;
    @Nullable
    private MediaStreamTrack cachedTrack;
    private boolean ownsTrack = true;
    @Nullable
    private final DtmfSender dtmfSender;

    @CalledByNative
    public RtpSender(long l) {
        DtmfSender dtmfSender;
        this.nativeRtpSender = l;
        this.cachedTrack = MediaStreamTrack.createMediaStreamTrack(RtpSender.nativeGetTrack(l));
        l = RtpSender.nativeGetDtmfSender(l);
        if (l != 0L) {
            DtmfSender dtmfSender2;
            dtmfSender = dtmfSender2;
            dtmfSender2 = new DtmfSender(l);
        } else {
            dtmfSender = null;
        }
        this.dtmfSender = dtmfSender;
    }

    private void checkRtpSenderExists() {
        if (this.nativeRtpSender != 0L) {
            return;
        }
        throw new IllegalStateException("RtpSender has been disposed.");
    }

    private static native boolean nativeSetTrack(long var0, long var2);

    private static native long nativeGetTrack(long var0);

    private static native void nativeSetStreams(long var0, List<String> var2);

    private static native List<String> nativeGetStreams(long var0);

    private static native long nativeGetDtmfSender(long var0);

    private static native boolean nativeSetParameters(long var0, RtpParameters var2);

    private static native RtpParameters nativeGetParameters(long var0);

    private static native String nativeGetId(long var0);

    private static native void nativeSetFrameEncryptor(long var0, long var2);

    public boolean setTrack(@Nullable MediaStreamTrack mediaStreamTrack, boolean bl) {
        RtpSender rtpSender = this;
        rtpSender.checkRtpSenderExists();
        long l = rtpSender.nativeRtpSender;
        long l2 = mediaStreamTrack == null ? 0L : mediaStreamTrack.getNativeMediaStreamTrack();
        if (!RtpSender.nativeSetTrack(l, l2)) {
            return false;
        }
        MediaStreamTrack mediaStreamTrack2 = this.cachedTrack;
        if (mediaStreamTrack2 != null && this.ownsTrack) {
            mediaStreamTrack2.dispose();
        }
        RtpSender rtpSender2 = this;
        rtpSender2.cachedTrack = mediaStreamTrack;
        rtpSender2.ownsTrack = bl;
        return true;
    }

    @Nullable
    public MediaStreamTrack track() {
        return this.cachedTrack;
    }

    public void setStreams(List<String> list) {
        RtpSender rtpSender = this;
        rtpSender.checkRtpSenderExists();
        RtpSender.nativeSetStreams(rtpSender.nativeRtpSender, list);
    }

    public List<String> getStreams() {
        RtpSender rtpSender = this;
        rtpSender.checkRtpSenderExists();
        return RtpSender.nativeGetStreams(rtpSender.nativeRtpSender);
    }

    public boolean setParameters(RtpParameters rtpParameters) {
        RtpSender rtpSender = this;
        rtpSender.checkRtpSenderExists();
        return RtpSender.nativeSetParameters(rtpSender.nativeRtpSender, rtpParameters);
    }

    public RtpParameters getParameters() {
        RtpSender rtpSender = this;
        rtpSender.checkRtpSenderExists();
        return RtpSender.nativeGetParameters(rtpSender.nativeRtpSender);
    }

    public String id() {
        RtpSender rtpSender = this;
        rtpSender.checkRtpSenderExists();
        return RtpSender.nativeGetId(rtpSender.nativeRtpSender);
    }

    @Nullable
    public DtmfSender dtmf() {
        return this.dtmfSender;
    }

    public void setFrameEncryptor(FrameEncryptor frameEncryptor) {
        RtpSender rtpSender = this;
        rtpSender.checkRtpSenderExists();
        RtpSender.nativeSetFrameEncryptor(rtpSender.nativeRtpSender, frameEncryptor.getNativeFrameEncryptor());
    }

    public void dispose() {
        RtpSender rtpSender = this;
        rtpSender.checkRtpSenderExists();
        Object object = rtpSender.dtmfSender;
        if (object != null) {
            ((DtmfSender)object).dispose();
        }
        if ((object = this.cachedTrack) != null && this.ownsTrack) {
            ((MediaStreamTrack)object).dispose();
        }
        JniCommon.nativeReleaseRef(this.nativeRtpSender);
        this.nativeRtpSender = 0L;
    }

    long getNativeRtpSender() {
        RtpSender rtpSender = this;
        rtpSender.checkRtpSenderExists();
        return rtpSender.nativeRtpSender;
    }
}

