/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.support.annotation.Nullable;
import org.otwebrtc.CalledByNative;
import org.otwebrtc.FrameDecryptor;
import org.otwebrtc.JniCommon;
import org.otwebrtc.MediaStreamTrack;
import org.otwebrtc.RtpParameters;

public class RtpReceiver {
    private long nativeRtpReceiver;
    private long nativeObserver;
    @Nullable
    private MediaStreamTrack cachedTrack;

    @CalledByNative
    public RtpReceiver(long l) {
        this.nativeRtpReceiver = l;
        this.cachedTrack = MediaStreamTrack.createMediaStreamTrack(RtpReceiver.nativeGetTrack(l));
    }

    private void checkRtpReceiverExists() {
        if (this.nativeRtpReceiver != 0L) {
            return;
        }
        throw new IllegalStateException("RtpReceiver has been disposed.");
    }

    private static native long nativeGetTrack(long var0);

    private static native RtpParameters nativeGetParameters(long var0);

    private static native String nativeGetId(long var0);

    private static native long nativeSetObserver(long var0, Observer var2);

    private static native void nativeUnsetObserver(long var0, long var2);

    private static native void nativeSetFrameDecryptor(long var0, long var2);

    @Nullable
    public MediaStreamTrack track() {
        return this.cachedTrack;
    }

    public RtpParameters getParameters() {
        RtpReceiver rtpReceiver = this;
        rtpReceiver.checkRtpReceiverExists();
        return RtpReceiver.nativeGetParameters(rtpReceiver.nativeRtpReceiver);
    }

    public String id() {
        RtpReceiver rtpReceiver = this;
        rtpReceiver.checkRtpReceiverExists();
        return RtpReceiver.nativeGetId(rtpReceiver.nativeRtpReceiver);
    }

    @CalledByNative
    public void dispose() {
        RtpReceiver rtpReceiver = this;
        rtpReceiver.checkRtpReceiverExists();
        rtpReceiver.cachedTrack.dispose();
        long l = rtpReceiver.nativeObserver;
        if (l != 0L) {
            RtpReceiver.nativeUnsetObserver(this.nativeRtpReceiver, l);
            this.nativeObserver = 0L;
        }
        JniCommon.nativeReleaseRef(this.nativeRtpReceiver);
        this.nativeRtpReceiver = 0L;
    }

    public void SetObserver(Observer observer) {
        RtpReceiver rtpReceiver = this;
        rtpReceiver.checkRtpReceiverExists();
        long l = rtpReceiver.nativeObserver;
        if (l != 0L) {
            RtpReceiver.nativeUnsetObserver(this.nativeRtpReceiver, l);
        }
        this.nativeObserver = RtpReceiver.nativeSetObserver(this.nativeRtpReceiver, observer);
    }

    public void setFrameDecryptor(FrameDecryptor frameDecryptor) {
        RtpReceiver rtpReceiver = this;
        rtpReceiver.checkRtpReceiverExists();
        RtpReceiver.nativeSetFrameDecryptor(rtpReceiver.nativeRtpReceiver, frameDecryptor.getNativeFrameDecryptor());
    }

    public static interface Observer {
        @CalledByNative(value="Observer")
        public void onFirstPacketReceived(MediaStreamTrack.MediaType var1);
    }
}

